//======================================================================
/**
 * @file  PokemonValidation.h
 *
 * @author  suzuki
 */
//======================================================================
#ifndef _POKEMON_VALIDATION_H_
#define _POKEMON_VALIDATION_H_

#include <gflib.h>
#include <gflnet.h>


GFL_NAMESPACE_BEGIN(netapp)

/**
 * @namespace netapp::validation
 * @brief     GTSp|Ps`FbN
 */
GFL_NAMESPACE_BEGIN(validation)


//--------------------------------------------------------------------------------------------
/**
 * @brief |Ps`FbNT[oANZXNX
 */
//--------------------------------------------------------------------------------------------
class PokemonValidation : public gfl::base::Singleton<PokemonValidation>
{
private:
  static const nn::nex::qInt32 POKEMON_NUM     = 10;    //!< `FbN|P̐
  static const nn::nex::qInt32 INDEX_SIZE      = 160;   //!< CfNXf[^̃TCY
  static const nn::nex::qInt32 POKEMON_SIZE    = 232;   //!< |Pf[^̃TCY
  static const nn::nex::qInt32 SIGNATURE_SIZE  = 256;   //!< ̃TCY
  static const nn::nex::qInt32 POST_BUFF_SIZE  = 8192;  //!< POSTobt@TCY
  static const nn::nex::qInt32 CA_BUFFER_SIZE  = 1024;  //!< [gؖ̊i[Ɏgpobt@TCY
  static const nn::nex::qInt32 ROM_BUFFER_SIZE = 128;   //!< ROMA[JCũ}EgɎgpobt@TCY

private:
  /**
  * @brief s`FbNT[oɓnf[^\
   */
  typedef struct
  {
    nn::nex::qChar8 authToken[nn::nex::IndependentServer::AUTH_TOKEN_SIZE]; // F؃g[N
    nn::nex::qChar8 terminator;                                             // F؃g[N̏I[
    nn::nex::qInt16 gameMode;                                               // Q[[h
    nn::nex::qByte  data[POKEMON_NUM][INDEX_SIZE + POKEMON_SIZE];           // `FbNΏۂ̃f[^
  }POKMEON_CHECKDATA;

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param none
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
   PokemonValidation( void );

   //--------------------------------------------------------------------------------------------
   /**
    * @brief fXgN^
    *
    * @param none
    *
    * @return none
    */
   //--------------------------------------------------------------------------------------------
   virtual ~PokemonValidation();

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief iubN֐j
   *
   * @param heap    obt@mۗpɎgpq[v
   * @param devHeap ؖǂݍ݂ɎgpfoCXq[v
   *
   * @return ȂtrueAsȂfalseԋp
   */
  //--------------------------------------------------------------------------------------------
  bool Initialize( gfl::heap::HeapBase *heap, gfl::heap::HeapBase* devHeap );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief I
   *
   * @param none
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
  void Finalize();

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief F؃g[N̎擾iubN֐j
   *
   * @note  InitializeA1񂾂{֐R[Ă
   *
   * @param none
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
  bool  GetAuthenticationToken( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief ғԔ
   *
   * @param none
   *
   * @return ғԂɂȂtrueAғԂȂfalseԋp
   */
  //--------------------------------------------------------------------------------------------
  bool IsEnable( void );

private:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief ؖt@C̓ǂݍ
   *
   * @param devHeap [hɎgpfoCX
   *
   * @return [hɐȂtrueԋp
   */
  //--------------------------------------------------------------------------------------------
  bool LoadCertifyFile( gfl::heap::HeapBase * devHeap );

private:
  bool                          m_isInit;                   // tO
  nn::nex::qChar8*              m_postBuffer;               // Postpobt@
  u8*                           m_caBuffer;                 // ؖpobt@
};


GFL_NAMESPACE_END(subscription)
GFL_NAMESPACE_END(netapp)

#endif  // _POKEMON_VALIDATION_H_
