//=============================================================================
/**
 * @file   PssRuleSelectUIListener.h
 * @brief  PSS[Ij[pCxgXi[NX
 * @author h.suzuki
 */
//=============================================================================

#ifndef __PSS_RULE_SELECT_UI_LISTENER_H__
#define __PSS_RULE_SELECT_UI_LISTENER_H__

#include <nn.h>
#include <gflib.h>


namespace app {
namespace pss {
namespace pss_rule_select {


class PssRuleSelectUIListener
{
public:

  //------------------------------------------------------------------
  /**
  * @brief  j[̃LZʒmiOʂցj
  */
  //------------------------------------------------------------------
  virtual void OnMenuBackAction( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  j[̃LZʒmiPSSgbvʂցj
  */
  //------------------------------------------------------------------
  virtual void OnMenuCloseAction( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  {^̉ʒm
  */
  //------------------------------------------------------------------
  virtual void OnButtonAction( const u32 painId ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐlu2lv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedVS2( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐlu4lv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedVS4( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ탋[um[}v̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedRuleNormal( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ탋[utbgv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedRuleFlat( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ탋[uȂv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedRuleUnlimit( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ^CvuVOogv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleTypeSingle( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ^Cvu_uogv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleTypeDouble( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ^Cvugvogv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleTypeTriple( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐ^Cvu[e[Vogv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleTypeRotation( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐunfv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleHandicapOn( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐunfȂv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleHandicapOff( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐnfuƓv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleHandicapPowerSame( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐnfûقアv̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleHandicapPowerWeak( void ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  ʐMΐnfu̕v̑Iʒm
  */
  //------------------------------------------------------------------
  virtual void OnSelectedBattleHandicapPowerStrong( void ) = 0;
};


}	// pss_rule_select
}	// pss
}	// app


#endif // __PSS_RULE_SELECT_UI_LISTENER_H__
