//------------------------------------------------------------------------------
//  AppÑgbvj[
//------------------------------------------------------------------------------
#ifndef __PROMOTION_MENU_H__
#define __PROMOTION_MENU_H__

#include <gflib.h>
#include "app/ui/UIView.h"
#include "app/tool/app_tool_MenuCursor.h"
#include "app/tool/app_tool_ButtonManager.h"
#include "app/tool/app_tool_CursorManager.h"
#include "app/ui/UITouchBarView.h"
#include "app/ui/UITouchBarListener.h"
#include "app/tool/app_tool_TouchPanelOperator.h"

// j[EBhE
#include "app/tool/app_tool_MenuWindowSystem.h"
#include "app/tool/app_tool_MenuWindow.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

class Menu : public app::ui::UIView, public app::ui::UITouchBarListener
{
public:
  enum Result
  {
    RESULT_NONE = -100,
    RESULT_EXIT,
    
    RESULT_PLAY,
    RESULT_EDIT,
  };
  
  enum State
  {
    STATE_TOP,
    STATE_MENU,
  };
  
public:
  Menu( Main* main, app::util::Heap * heap, gfl::grp::g2d::LytSys* layout, gfl::ui::DeviceManager* device, int select);
  ~Menu();
  
  virtual void Draw();
  virtual void Update();
  
  
  Result GetResult(){return m_result;}
  int GetSelectedVideo(){return m_select;}
  
  
  // override 
  bool OnSelectedButton(u32 button);
  
private:
  // CAEg̐E폜
  void CreateLayout(gfl::grp::g2d::LytSys* layout);
  void DeleteLayout();
  
  void SetCursor(int id);
  void SetMessage(int id);
  void SetOnAir(int id);
  
  int GetVideoIDFromPos(const gfl::math::VEC2& v);
  
private:
  void CreateTopMenu();
  void CreateEditMenu(){}
  void DeleteTopMenu();
  
  void UpdateTop();
  void UpdateMenu();
  
private:
  Main* m_main;
  gfl::ui::DeviceManager* m_device;
  app::util::Heap* m_heap;
  
  // ^b`
  app::tool::TouchPanelOperator* m_touchpanel;
  
  // J[\
  app::tool::MenuCursor* m_cursor;
  app::tool::ButtonManager* m_button_manager;
  app::tool::CursorManager* m_cursor_manager;
  
  // ^b`o[
  app::ui::UITouchBarView* m_touchbar;
  
  // j[EBhE
  app::tool::MenuWindowSystem* m_menu_sys;
  app::tool::MenuWindow* m_menu;
  
  // Ԗڂ̃rfII
  int m_select;
  
  State m_state;
  
  // 
  Result m_result;
  
  gfl::grp::g2d::LytSys* m_layout;
};

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__PROMOTION_MENU_H__
