
#include "Menu.h"
#include "common_res/msg_window_res.h"
#include "lyt/layout.h"
#include "lyt/layout_pane.h"

#include "message/msg_promo_video_system.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)
//------------------------------------------------------------------------------
enum
{
  VIDEO_LEFT,
  VIDEO_CENTER,
  VIDEO_RIGHT,
};


static const int VIDEO_PANE[] = {
  PANENAME_P_VIDEO00_LOWER_PANE_SELECT_01,
  PANENAME_P_VIDEO00_LOWER_PANE_SELECT_02,
  PANENAME_P_VIDEO00_LOWER_PANE_SELECT_03,
};

static const int ONAIR_PANE[] = {
  PANENAME_P_VIDEO00_LOWER_PANE_ON_AIR_MARK_B_00,
  PANENAME_P_VIDEO00_LOWER_PANE_ON_AIR_MARK_B_01,
  PANENAME_P_VIDEO00_LOWER_PANE_ON_AIR_MARK_B_02,
};
//------------------------------------------------------------------------------
Menu::Menu( Main* main, app::util::Heap * heap, gfl::grp::g2d::LytSys* layout, gfl::ui::DeviceManager* device, int select) : 
app::ui::UIView(heap),
m_main(main),
m_device(device),
m_heap(heap),
m_select(select),
m_result(RESULT_NONE)
{
  m_layout = layout;
  gamesystem::GameManager* gm = GFL_SINGLETON_INSTANCE(gamesystem::GameManager);
  m_graphicSystem = gm->GetGraphicsSystem();
  
  // CAEg̍쐬
  this->CreateLayout(layout);
  
  // bZ[W̃Zbg
  // rfIIł
  this->SetMessage(pvd_select01);
  
  // ʃCAEǵAJ[\
  m_g2dUtil->SetPaneVisible(1, PANENAME_P_VIDEO01_UPPER_PANE_COURSOL_POS, false);
  
  // Aj[ṼZbg
  // IGA}[N[ɂāAAjĐ
  // @todo Z[uf[^āAǂɃIGA}[N邩߂
  m_g2dUtil->StartAnime(0, LYTRES_LAYOUT_P_VIDEO00_LOWER_ON_AIR_MARK_ANM_BCLAN);
  this->SetOnAir(m_select);
  this->SetCursor(m_select);
  
}

Menu::~Menu()
{
  if(m_menu)
  {
    GFL_DELETE m_menu;
    m_menu = NULL;
    GFL_DELETE m_menu_sys;
    m_menu_sys = NULL;
  }
  
  
  this->DeleteLayout();
}

//------------------------------------------------------------------------------
// ^b`o[̔
//------------------------------------------------------------------------------
bool Menu::OnSelectedButton(u32 button)
{
  m_result = RESULT_EXIT;
  return false;
}
//------------------------------------------------------------------------------
// Update, Draw
//------------------------------------------------------------------------------
void Menu::Update()
{
  UIView::Update();
  m_cursor->Update();
  m_touchpanel->Update();
  
  switch(m_state)
  {
  case STATE_TOP:
    this->UpdateTop();
    break;
  case STATE_MENU:
    this->UpdateMenu();
    break;
  }
}
  
void Menu::UpdateTop()
{
  // ^b`
  if(m_touchpanel->IsDecide())
  {
    // J[\ʒu𐳂
    gfl::math::VEC2 v;m_touchpanel->GetDecideValue(&v);
    int i = this->GetVideoIDFromPos(v);
    if(i != -1)
    {
      m_select = i;
      this->SetCursor(i);
      // ̃rfIǂH
      this->SetMessage(pvd_select02);
      
      // j[̍쐬
      this->CreateTopMenu();
      m_state = STATE_MENU;
    }
  }
  else
  if(m_touchpanel->IsDrag())
  {
    // J[\ʒu𐳂
    gfl::math::VEC2 v;m_touchpanel->GetDragStartValue(&v);
    int i = this->GetVideoIDFromPos(v);
    if(i != -1)
    {
      this->SetCursor(i);
    }
  }
  
  // L[
  if(m_cursor_manager->MainRepeat() == app::tool::CursorManager::RET_MOVE)
  {
    // J[\ʒu𐳂
    this->SetCursor(m_cursor_manager->GetPos());
  }
  if(m_device->GetButton(0)->IsTrigger(gfl::ui::BUTTON_A))
  {
    m_select = m_cursor_manager->GetPos();
    
    // ̃rfIǂH
    this->SetMessage(pvd_select02);
    // j[̍쐬
    this->CreateTopMenu();
    
    m_state = STATE_MENU;
  }
  
  m_touchbar->Update();
}

void Menu::UpdateMenu()
{
  m_menu_sys->UpdateControl();
  m_menu_sys->UpdateView();
  
  if(!m_menu_sys->IsAlternativeSelected()){return;}
  
  switch(m_menu_sys->GetSelectedAlternativeValue())
  {
  case 0:// ݂ȂɌ
    // ݂ȂɌrfIIт܂
    this->SetMessage(pvd_select03);
    this->DeleteTopMenu();
    m_state = STATE_TOP;
    
    this->SetOnAir(m_select);
    break;
  case 1:// 
    m_result = RESULT_PLAY;
    break;
  case 2:// ҏW
    m_result = RESULT_EDIT;
    break;
  case 3:// ߂
    this->DeleteTopMenu();
    // rfIIł
    this->SetMessage(pvd_select01);
    m_state = STATE_TOP;
    break;
  }
}

void Menu::Draw()
{
  m_g2dUtil->Draw2D(m_graphicSystem, 0);
  m_g2dUtil->Draw2D(m_graphicSystem, 1);
  
  m_cursor->Draw(m_graphicSystem, gfl::grp::DISPLAY_LOWER);
  m_touchbar->Draw();
  if(m_menu){m_menu_sys->DrawMenuWindow();}
}

//------------------------------------------------------------------------------
// Layout̍쐬
//------------------------------------------------------------------------------
void Menu::CreateLayout(gfl::grp::g2d::LytSys* layout)
{
  static const app::util::G2DUtil::LYT_RES_DATA tbl[] = {
    { ARCID_PROMOTION,         0, LYTRES_MSG_WINDOW_RES_END, app::util::G2DUtil::ATTACH_ROOT },
    { ARCID_COMMON_MSGWINDOW,  0,                         0, app::util::G2DUtil::ATTACH_RESOURCE  }, // 01: ʃ\[X: bZ[WEBhE
  };
  static const gfl::grp::g2d::LytArcIndex anim[] = {
  LYTRES_LAYOUT_P_VIDEO00_LOWER_ON_AIR_MARK_ANM_BCLAN,
  };
  static const gfl::grp::g2d::LytArcIndex anim2[] = {
  };
  static const app::util::G2DUtil::LYTWK_DATA data[] = {
    {
      0,
      LYTRES_LAYOUT_P_VIDEO00_LOWER_BCLYT,
      anim,
      GFL_NELEMS(anim),
      GFL_NELEMS(anim),
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true, // \ݒ
    },
    {
      0,
      LYTRES_LAYOUT_P_VIDEO01_UPPER_BCLYT,
      anim2,
      GFL_NELEMS(anim2),
      GFL_NELEMS(anim2),
      false,
      app::util::G2DUtil::SETUP_UPPER,
      true, // \ݒ
    },
  };
  
  this->Create2D(
    m_heap,
    layout,
    GFL_NELEMS(data),
    tbl,
    GFL_NELEMS(tbl),
    data,
    GFL_NELEMS(data),
    GARC_message_promo_video_system_DAT
  );
  
  // bZ[WEBhE̍쐬
  {
    static const gfl::grp::g2d::LytPaneIndex msg_table[] = {
      PANENAME_P_VIDEO00_LOWER_PANE_TEXT_00,
      PANENAME_P_VIDEO00_LOWER_PANE_TEXT_00,
    };
    m_g2dUtil->CreateMessageWindow(m_device, 0, msg_table, 0, m_heap);
  }
  
  // ^b`o[̍쐬
  {
    // @todo ^b`o[r[Ɋ߂{^߁ABUTON_SEARCHgpĂ̂ŁA㍷ւ
    static const app::ui::UITouchBarView::SETUP touch_setup[] = {
      {app::ui::UITouchBarView::BUTTON_ID_RETURN, PANENAME_P_VIDEO00_LOWER_PANE_RETURN_ICON_POS},
    };
    
    m_touchbar = GFL_NEW(m_heap->pHeap) app::ui::UITouchBarView(
      m_heap,
      this->GetGraphicSystem(),
      layout,
      this->GetLayoutWork(0),
      touch_setup,
      GFL_NELEMS(touch_setup)
    );
    
    m_touchbar->SetListener(this);
  }
  
  // ^b`͍쐬
  m_touchpanel = GFL_NEW(m_heap->pHeap) app::tool::TouchPanelOperator(m_device->GetTouchPanel(0), gamesystem::FRAMEMODE_30);
  
  // J[\̍쐬
  {
    m_cursor = GFL_NEW(m_heap->pHeap) app::tool::MenuCursor(m_g2dUtil->GetLayoutSystem());
    m_cursor->LoadLayoutResource(m_heap->pHeap, m_heap->pDevHeapAllocator);
    static const gfl::grp::g2d::LytWkSetUp CURSOR_SETUP = {
      gfl::math::VEC3( 0, -290, 0 ), // pos
      gfl::math::VEC2( 1, 1 ), // scale
      gfl::math::VEC3( 0, 0, 0 ), // rotate
      1, // priority
    };
    m_cursor->CreateLayoutWork(&CURSOR_SETUP, false);
    
    // J[\̓Aʒu0bڂɃZbg
    m_cursor->SetVisible(true);
    m_cursor->StartAnime(gamesystem::FRAMEMODE_30);
    this->SetCursor(VIDEO_LEFT);
  }
  
  // J[\}l[W̍쐬
  {
    static const app::tool::CursorManager::MOVE_DATA CURSOR_DATA[] = {
      {
        VIDEO_LEFT,// ㉺E
        {VIDEO_LEFT, VIDEO_LEFT, VIDEO_LEFT, VIDEO_CENTER}
      },
      {
        VIDEO_CENTER,// ㉺E
        {VIDEO_CENTER, VIDEO_CENTER, VIDEO_LEFT, VIDEO_RIGHT}
      },
      {
        VIDEO_RIGHT,// ㉺E
        {VIDEO_RIGHT, VIDEO_RIGHT, VIDEO_CENTER, VIDEO_RIGHT}
      },
    };
    
    m_cursor_manager = GFL_NEW(m_heap->pHeap) app::tool::CursorManager(
      CURSOR_DATA,
      GFL_NELEMS(CURSOR_DATA),
      m_heap->pHeap
    );
    
    m_cursor_manager->SetPos(m_select);
  }
}

void Menu::DeleteLayout()
{
  // J[\}l[W̍폜
  GFL_DELETE m_cursor_manager;
  
  // J[\̍폜
  m_cursor->DeleteLayoutWork();
  m_cursor->ReleaseLayoutResource();
  GFL_DELETE m_cursor;
  
  // ^b`o[̍폜
  GFL_DELETE m_touchbar;
  
  GFL_DELETE m_touchpanel;
  
  // bZ[WEBhE̍폜
  m_g2dUtil->DeleteMessageWindow();
  
  // CAEg{̂̍폜
  this->Delete2D();
}


//------------------------------------------------------------------------------
// J[\ʒu̐ݒ
//------------------------------------------------------------------------------
void Menu::SetCursor(int id)
{
  m_cursor->Put(m_g2dUtil->GetLayoutWork(0), VIDEO_PANE[id]);
}

void Menu::SetMessage(int id)
{
  m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO00_LOWER_PANE_TEXT_00, id, m_heap);
}

void Menu::SetOnAir(int id)
{
  for(int i = 0; i < 3; ++i)
  {
    m_g2dUtil->SetPaneVisible(0, ONAIR_PANE[i], (i == id)); 
  }
}

int Menu::GetVideoIDFromPos(const gfl::math::VEC2& v)
{
  for(int i = 0; i < GFL_NELEMS(VIDEO_PANE); ++i)
  {
    if(m_g2dUtil->GetHitPane(0, VIDEO_PANE[i], v.x, v.y, false))
    {
      return i;
    }
  }
  return -1;
}

//------------------------------------------------------------------------------
// j[̍쐬(FɌE݂EҏWE߂)
//------------------------------------------------------------------------------
void Menu::CreateTopMenu()
{
  if(m_menu){this->DeleteTopMenu();}
  
  
  // j[EBhEVXe̍쐬
  {
    static const gfl::grp::g2d::LytWkSetUp MENU_SETUP = {
      gfl::math::VEC3( 0, -290, 0 ), // pos
      gfl::math::VEC2( 1, 1 ), // scale
      gfl::math::VEC3( 0, 0, 0 ), // rotate
      1, // priority
    };
    
    m_menu_sys = GFL_NEW(m_heap->pHeap) app::tool::MenuWindowSystem(
      m_heap->pHeap,
      m_heap->pDevHeap,
      m_device,
      m_graphicSystem,
      m_layout,
      gamesystem::FRAMEMODE_30,
      &MENU_SETUP
    );
    
    m_menu_sys->SetAutoDrawFlag(false);
  }
  
  static const app::tool::MenuWindow::MenuParameter menu_param = {
    gfl::grp::DISPLAY_LOWER,
    app::tool::MenuWindow::X_POSITION_TYPE_RIGHT,
    app::tool::MenuWindow::Y_POSITION_TYPE_BOTTOM,
    160,
    -85,
    80, // ŏ
    4,  // s
    1,  // 
    false // J[\̈ړ[v邩
  };
  m_menu = GFL_NEW(m_heap->pHeap) app::tool::MenuWindow(m_heap->pHeap, menu_param);
  
  // I𑫂Ă
  static const app::tool::MenuWindow::AlternativeParameter alt_param[] = {
    {
      0,//s
      0,//
      0,//AĂ錋
      false,//B{^Ɋ֘At邩ǂ
      false //߂{^\邩ǂ
    },
    {
      1,//s
      0,//
      1,//AĂ錋
      false,//B{^Ɋ֘At邩ǂ
      false //߂{^\邩ǂ
    },
    {
      2,//s
      0,//
      2,//AĂ錋
      false,//B{^Ɋ֘At邩ǂ
      false //߂{^\邩ǂ
    },
    {
      3,//s
      0,//
      3,//AĂ錋
      true,//B{^Ɋ֘At邩ǂ
      true //߂{^\邩ǂ
    },
  };
  
  gfl::str::StrBuf strbuf( 128, m_heap->pHeap );
  // FɌ
  m_g2dUtil->GetString(&strbuf, pvd_select09);
  m_menu->AddAlternative(alt_param[0], &strbuf);
  // 
  m_g2dUtil->GetString(&strbuf, pvd_select10);
  m_menu->AddAlternative(alt_param[1], &strbuf);
  // ҏW
  m_g2dUtil->GetString(&strbuf, pvd_select11);
  m_menu->AddAlternative(alt_param[2], &strbuf);
  // ߂
  m_g2dUtil->GetString(&strbuf, pvd_select12);
  m_menu->AddAlternative(alt_param[3], &strbuf);
  
  // j[̂ŁAj[ǗVXeɓo^
  m_menu_sys->SetMenuWindow(m_menu);
  m_menu_sys->Start();
}

void Menu::DeleteTopMenu()
{
  GFL_DELETE m_menu;
  m_menu = NULL;
  
  // j[ǗVXe̍폜
  GFL_DELETE m_menu_sys;
  m_menu_sys = NULL;
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

