//=============================================================================
/**
 * @file   gflnet_NexMatchingRule.h
 *
 *  @brief MatchMakingClientpNX
 *
 * @author h.suzuki
 */
//=============================================================================

#ifndef __GFLNET_NEX_MATCHING_RULE_H__
#define __GFLNET_NEX_MATCHING_RULE_H__


#include <nex.h>
#include <nex_P2p.h>

#include <nn/friends.h>


#include <gflib.h>
#include <gflnet_NetworkDefine.h>
#include <nex/gflnet_NexMatchmakeListener.h>
#include <nex/gflnet_NexSessionEventListener.h>

GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(nex)

//------------------------------------------------------------------
/**
*  @brief MatchMakingClientpNX
*/
//------------------------------------------------------------------
class NexMatchMakingRule
{
public:
  //------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param index      ݒCfbNX(0`4)
   * @param baseValue  x[XlB̊{lƂĎgpB
   * @param valueMin   ͈͍ŏlB͈͂w肵ȂꍇbaseValueƓlw肷邱ƁB
   * @param valueMax   ͈͍őlB͈͂w肵ȂꍇbaseValueƓlw肷邱ƁB
   *
   * @note  (baseValue==valueMin==valueMax)̏ꍇ́ÁulƁvƂĉ߂B
   */
  //------------------------------------------------------------------
  NexMatchMakingRule( u32 index, u32 baseValue, u32 valueMin, u32 valueMax );

public:
  //------------------------------------------------------------------
  /**
  * @brief ݒCfbNX擾
  *
  * @return ݒCfbNXl
  */
  //------------------------------------------------------------------
  u32     GetIndex( void ) const;

  //------------------------------------------------------------------
  /**
  * @brief ͈͎wł邩
  *
  * @return ͈͎włȂtrueԋp
  */
  //------------------------------------------------------------------
  u32     GetBaseValue( void ) const;

  //------------------------------------------------------------------
  /**
  * @brief ͈͎wl̍ŏl擾
  *
  * @return ͈͎wl̍ŏl
  */
  //------------------------------------------------------------------
  bool    IsRangeValue( void ) const;

  /**
   * @brief
   *
   * @return
   */
  u32     GetRangeMinValue( void ) const;


  //------------------------------------------------------------------
  /**
  * @brief ͈͎wl̍ől擾
  *
  * @return ͈͎wl̍ől
  */
  //------------------------------------------------------------------
  u32     GetRangeMaxValue( void ) const;

private:
  u32     m_index;      //!< ݒCfbNX
  u32     m_baseValue;  //!< x[Xl
  u32     m_valueMin;   //!< ͈͍ŏl
  u32     m_valueMax;   //!< ͈͍ől

public:
  nw::ut::LinkListNode node;   //!< List Node
};


GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(gflnet)


#endif  // __GFLNET_NEX_MATCHING_RULE_H__
