//=============================================================================
/**
 * @file   gflnet_NdmManager.h
 * @brief  nn::ndm̃bp[NXBef[̓Ǘ
 * @author Shin Kosaka
 * @date   2012.08.02
 */
//=============================================================================

#ifndef __GFLNET_NDM_MANAGER_H__
#define __GFLNET_NDM_MANAGER_H__

#include <nn.h>
#include <nn/ndm.h>

#include <gflib.h>
#include <ndm/gflnet_NdmEventListener.h>


GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(ndm)


class NdmSuspendThread;

class NdmManager : public gfl::base::Singleton<NdmManager>
{
  GFL_FORBID_COPY_AND_ASSIGN(NdmManager); //Rs[RXgN^{֎~

private:
	
	enum
	{
		THREAD_STACK_SIZE = 8192,//XbhX^bNTCY
	};
	
public:
  //------------------------------------------------------------------
  /**
   * @brief   NdmManagerRXgN^
   *
   * @param   heap Xbh𐶐ۂɎgpq[v
   */
  //------------------------------------------------------------------
  NdmManager( gfl::heap::HeapBase *pHeap );

  //------------------------------------------------------------------
  /**
   * @brief   NdmManagerfXgN^
   */
  //------------------------------------------------------------------
  virtual ~NdmManager();


public:
  //------------------------------------------------------------------
  /**
   * @brief  NdmManageȑ
   *         
   *
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result Initialize( void );

  //------------------------------------------------------------------
  /**
   * @brief  NdmManageȑI
   *
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result Finalize( void );

  //------------------------------------------------------------------
  /**
   * @brief  LANXCb`Lǂ
   *
   * @return Ltrue : false
   */
  //------------------------------------------------------------------
  bool IsWLANSwitchEnable( void ) const;

	
  //------------------------------------------------------------------
  /**
   * @brief  ꂿf[~inn::cecj
   * @note
   * ꂿʐMs߂̃f[~܂B
   * ŃA~ĂȂԂɂȂĂ܂B
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result SuspendCec( void );

  //------------------------------------------------------------------
  /**
   * @brief  ꂿf[̒~
   *
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result ResumeCec( void );


  //------------------------------------------------------------------
  /**
   * @brief  thEv[Xf[~inn::friendsj
   * @note
   * thEv[XʐMs߂̃f[~܂B
   * ŃA~ĂȂԂɂȂĂ܂B
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result SuspendFriends( void );

  //------------------------------------------------------------------
  /**
   * @brief  thEv[Xf[̒~
   *
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result ResumeFriends( void );
	
  //------------------------------------------------------------------
  /**
   * @brief  BOSSf[~inn::bossj
   * @note
   * BOSSʐMs߂̃f[~܂B
   * ̃f[̂݁AŃA~ĂԂɂȂĂ܂B
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result SuspendBoss( void );

  //------------------------------------------------------------------
  /**
   * @brief  BOSSf[̒~
   *
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result ResumeBoss( void );
	
  //------------------------------------------------------------------
  /**
   * @brief  f[XPW[Ŝ~ij
   * @note
   * ׂẴf[сAANZX|CǧAڑ̃obNOEh
   * Sɒ~܂B܂ŌĂяõXbhubN܂B
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result SuspendDeamonSchedulerSync( void );

  //------------------------------------------------------------------
  /**
   * @brief  f[XPW[Ŝ~i񓯊j
   * @note
   * ׂẴf[сAANZX|CǧAڑ̃obNOEh
   * Sɒ~܂B~̊҂ɏԂ܂Bʂ̓CxgŒʒm܂B
   * @return s
   */
  //------------------------------------------------------------------
  bool SuspendDeamonSchedulerASync( NdmEventListener *pListener, gfl::base::Thread::Priority threadPriority );
	
  //------------------------------------------------------------------
  /**
   * @brief   f[XPW[Ŝ̒~
   *
   *	vZX SuspendScheduler 𕡐ĂяoĂꍇ́AResumeScheduler ̉񐔕ĂяoȂƒ~͉܂B 
   * @return s
   */
  //------------------------------------------------------------------
  nn::Result ResumeDeamonScheduler( void );
	
public:

  //------------------------------------------------------------------
  /**
   * @brief  G[eR\[ɏo
   *
   * @param  result o͑ΏۂƂȂnn::Result
   */
  //------------------------------------------------------------------
  static void PrintError( const nn::Result &result );



private:

  //-------------------------------------------------------------------------------
  /**
   * @brief   ʃf[̒~
   *
   * @return s
   */
  //-------------------------------------------------------------------------------
  nn::Result _Suspend( nn::ndm::DaemonName name );

  //-------------------------------------------------------------------------------
  /**
   * @brief   ʃf[̒~
   *
   * @return s
   */
  //-------------------------------------------------------------------------------
  nn::Result _Resume( nn::ndm::DaemonName name );
	
private:	
  //-------------------------------------------------------------------------------
  /**
   * @brief 񓯊ʐMsǂ𒲂ׂ
   * @retval true   s
   * @retval false  sĂȂ
   */
  //-------------------------------------------------------------------------------
  bool _CheckAsync( void ) const;

  //-------------------------------------------------------------------------------
  /**
   * @brief s̔񓯊ʐMLZ
   */
  //-------------------------------------------------------------------------------
  void _CancelAsync( void );

  //-------------------------------------------------------------------------------
  /**
   * @brief Xbh̏I҂s܂B
   */
  //-------------------------------------------------------------------------------
  void _WaitAsyncFinished( void ) const;

  //-------------------------------------------------------------------------------
  /**
   * @brief 񓯊Xbhj
   */
  //-------------------------------------------------------------------------------
  void _DeleteAsync( void );

private:
  gfl::heap::HeapBase*              m_pHeapBase;     	//q[vx[X
  gflnet::ndm::NdmSuspendThread*   	m_pThread;			//񓯊pXbh
  bool								m_isInitialized;	//tO
};

GFL_NAMESPACE_END(ndm)
GFL_NAMESPACE_END(gflnet)

#endif // __GFLNET_NDM_MANAGER_H__

