//=============================================================================
/**
 * @file   gflnet_BossManager.h
 * @brief  BOSSǗ}l[WNX
 * @author shin kosaka
 */
//=============================================================================
#ifndef __GFLNET_BOSS_MANAGER_H__
#define __GFLNET_BOSS_MANAGER_H__

#include <nn.h>
#include <nn/boss.h>

#include <gflib.h>
#include <gflnet_NetworkDefine.h>

#include <boss/gflnet_BossEventListener.h>

GFL_NAMESPACE_BEGIN(gflnet)
/**
* @namespace gflnet::boss
* @brief     BOSS֘A
*/
GFL_NAMESPACE_BEGIN(boss)

//--------------------------------------------------------------------------
class BossFilelistDownloadThread;
class BossFileReadThread;
class BossCheckNewArrivalDataThread;
class BossImmediateTaskThread;
class BossTaskRegisterThread;
//--------------------------------------------------------------------------

/***************************************************************************!
 * @brief  BOSSǗ}l[WNX
 ***************************************************************************/
class BossManager : public gfl::base::Singleton<BossManager>
{
	GFL_FORBID_COPY_AND_ASSIGN(BossManager); //Rs[RXgN^{֎~

public:
	//}l[Wp[^
 	struct BOSS_INIT_PARAM
	{
		BOSS_INIT_PARAM()
		: storageId(gfl::core::Math::S32_MAX)
		, storageSize((size_t)gfl::core::Math::U64_MAX)
		, entryCount(gfl::core::Math::U16_MAX)
		, pBossCode(NULL)
		, pMountName(NULL)
		{};//[Up[^ݒ肵ȂꍇG[ɂȂ悤ɍ\̂
		
		s32 		storageId; 		//!<BOSSŎgpgZ[uf[^̈ID
		size_t		storageSize;	//!<gpTCYif[^Mɗ݌ṽTCYȏɂȂAÂ̂폜j
		u16			entryCount;		//!<őt@C(1~2000)if[^MɃt@CȏɂȂAÂ̂폜j
		const char*	pBossCode;		//!<BOSSR[hi\0ŏI[Ă镶j
		const char* pMountName;		//!<gZ[uf[^}Eg
	};

	/*
		t@Cւ̃ANZX́̂悤URLɂȂ܂B
		https://npdl.cdn.nintendowifi.net/p01/nsa/[BOSSR[h]/[^XNID]/[t@C]
	 	[BOSSR[h]NADL^XNp\ۂɂ̃AvP[VɐU郉_ȕłB
	 	[^XNID]͊Y^XNIDłB^XNo^ɐݒ肵܂B
		[t@C]̓_E[ht@Ĉ̖ɂȂ܂B
	*/
	
	//^XNo^p[^
	struct TASK_INIT_PARAM
	{
		TASK_INIT_PARAM()
		: pTaskName(NULL)
		, interval(gfl::core::Math::U32_MAX)
		, count(gfl::core::Math::U32_MAX)
		, pFileName(NULL)
		{};//[Up[^ݒ肵ȂꍇG[ɂȂ悤ɍ\̂
		
		const char* pTaskName;		//!<^XN(char[TASK_NAME_LENGTH(8)])
		u32			interval;		//!<^XNsԊuiPʂhourj
		u32			count;			//!<^XNs񐔁i1~100j
		const char* pFileName;		//!<_E[ht@C
	};
	
	//萔
	enum
	{
		MAX_LISTENER_NUM = 16,									//!<őo^Xi[
		TASK_NAME_LENGTH = nn::boss::TASK_ID_LENGTH,			//!<[I[܂ރ^XN̍ő啶i8j
		TASK_COUNT_MAX = 100,									//!<ݒ\ȍő^XNs
		MOUNT_NAME_LENGTH = 32,									//!<gZ[uf[^}EgTCY
		THREAD_STACK_SIZE = 8192,								//!<XbhX^bNTCY
		NSA_LIST_INFO_NUM = 64,									//!<_E[h\ȃt@CXg(220byte * 64)
		TEMP_BUFFER_SIZE = 1000 * 32,							//!<e|obt@TCY
		SELIAL_ID_LIST_SIZE = TEMP_BUFFER_SIZE/4,				//!<VAIDXgTCY(u8 -> u32Ȃ̂41)
	};
	
	/*  [nn::boss̒萔]
		MAX_FILEPATH_LENGTH =  256; 	//t@CpXő咷
		MAX_URL_LENGTH =  512;			//URLő咷
		TASK_ID_LENGTH =  8;			//[I[܂ރ^XN̍ő啶
		MAX_TASK_ID =  128;				//o^\ȃ^XNID̍ő
		MAX_STORAGE_ENTRY_COUNT =  2000;//BOSSXg[Wt@C̍ől
		FG_ONLY_TASK_ID[] = "FGONLYT";	//s^XN
	*/
	
public:
	//------------------------------------------------------------------
	/**
	* @brief   RXgN^
	* @param[in] pHeap q[v
	*/
	//------------------------------------------------------------------
	BossManager();

	//------------------------------------------------------------------
	/**
	* @brief   fXgN^
	*/
	//------------------------------------------------------------------
	virtual ~BossManager();

	//------------------------------------------------------------------
	/**
	* @brief  BossManageȑ
	* @param[in] initParam p[^
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result Initialize( const BOSS_INIT_PARAM& initParam );

	//------------------------------------------------------------------
	/**
	* @brief  BossManageȑI
	* @param[in] isUnregistStorage	Xg[W̓o^邩ǂ
									ƈȍ~̓obNOEhł_E[hsȂȂ܂B
									ʏ͉Kv͂܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result Finalize( bool isUnregistStorage = false );

	//------------------------------------------------------------------
	/**
	* @brief  gpq[vݒit@CǂݍݓŃTCY傫ׁAgpAvP[Vݒj
	*/
	//------------------------------------------------------------------
	void SetAppHeap( gfl::heap::HeapBase* pHeapBase );
	
	//------------------------------------------------------------------
	/**
	* @brief  gpq[v̐ݒ
	*/
	//------------------------------------------------------------------
	void RemoveAppHeap();
	
	//------------------------------------------------------------------
	/**
	* @brief  XVB
	*
	* @note   	C[vɃ|[O邱
	*			BossEventListenerɒʒmCxgׂ͂Ă̊֐Ŏs܂B
	*/
	//------------------------------------------------------------------
	void Update( void );

	//------------------------------------------------------------------
	/**
	* @brief  Ԃ𒲍
	*
	* @retval trueF ς
	* @retval false: E܂͏
	*/
	//------------------------------------------------------------------
	bool IsInitialized( void ) const;
	
	//------------------------------------------------------------------
	/**
	* @brief  CxgXi[̒ǉiő16j
	* @param[in] pListener CxgXi[
	*
	* @return s
	*/
	//------------------------------------------------------------------
	bool AddEventListener( BossEventListener* pListener );
	
	//------------------------------------------------------------------
	/**
	* @brief  Xi[
	* @param[in] pListener CxgXi[
	*/
	//------------------------------------------------------------------
	void RemoveEventListener( BossEventListener* pListener );
	
	//------------------------------------------------------------------
	/**
	* @brief  V_E[hf[^BOSSXg[WɓĂ邩
	*
	*	̃tORequestNewArrivalDataHeaderRequestAllDataHeadersɁA
	*	BossManagerUpdate邱ƂŃZbg܂B
	*
	* @return V_E[hf[^ꍇtrue
	*/
	//------------------------------------------------------------------
	bool IsArrivalNewData() const;
	
	//------------------------------------------------------------------
	/**
	* @brief  BOSSXg[Wɑ݂SV_E[hf[^̃wb_v
	*
	*	ʂOnReadHeaderCxgŎ擾܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	//bool RequestNewArrivalDataHeader(); 
	
	//------------------------------------------------------------------
	/**
	* @brief  BOSSXg[Wɑ݂S_E[hf[^̃wb_v
	*
	*	VȊÕwb_v܂B
	*	ʂOnReadHeaderCxgŎ擾܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	//bool RequestAllDataHeader(); 
	
	//------------------------------------------------------------------
	/**
	* @brief  BOSSXg[Wɑ݂_E[hf[^̖{̂v
	* @param[in] serialId	f[^̃VAID
	* @param[in] threadPriority XbhDx
	*
	*	VAIDOnRecvNewDataCxǵAwb_񂩂擾ł܂B
	*	ʂOnReadDataCxgŎ擾܂B
	*
	*/
	//------------------------------------------------------------------
	bool RequestDataBody( const u32 serialId , gfl::base::Thread::Priority threadPriority );
	
	//------------------------------------------------------------------
	/**
	* @brief  ^XN̓o^iobNOEhsj
	* @param[in] taskInitParam o^p[^
	*
	*	擾f[^̓Xi[oRŎ󂯎܂B
	*	łɓ̃^XNo^ĂꍇA㏑܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result RegisterTask( gfl::base::Thread::Priority threadPriority , const TASK_INIT_PARAM& taskInitParam );
	
	
	//------------------------------------------------------------------
	/**
	* @brief  ^XN̓o^
	* @param[in] pTaskName ^XN(char[TASK_NAME_LENGTH(8)])
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result UnregisterTask( const char* pTaskName );
	
	//------------------------------------------------------------------
	/**
	* @brief  s^XNJnitHAOEhsj
	* @param[in] pTaskName ^XN
	* @param[in] pFileName t@C
	*
	*	s^XN͓ɂPsł܂B
	*	s^XN1񂾂s܂B擾f[^̓Xi[oRŎ󂯎܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result StartImmidiateTask( gfl::base::Thread::Priority threadPriority , const char* pFileName );
	
	//------------------------------------------------------------------
	/**
	* @brief  s^XNLZ
	*
	*	s^XNLZA^XNj܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result CancelImmidiateTask();
	
	//------------------------------------------------------------------
	/**
	* @brief  t@CXg̃_E[hJnitHAOEhsj
	* @param[in] pTaskName ^XN(ȗꍇFGONRYTݒ肳)
	* @param[in] threadPriority XbhDx
	*
	*	t@CXg_E[h1񂾂s܂B擾Xg̓Xi[oRŎ󂯎܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	bool StartDownloadFileList( gfl::base::Thread::Priority threadPriority , const char* pTaskName = NULL );
	
	//------------------------------------------------------------------
	/**
	* @brief  t@CXg̃_E[hLZ
	*
	*	t@CXg̃_E[hLZ܂B
	*
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result CancelDownloadFileList();
	
	//------------------------------------------------------------------
	/**
	* @brief  tHAOEhsǂ
	*
	* @retval true tHAOEhs : false tHAOEh͎sł͂Ȃ
	*/
	//------------------------------------------------------------------
	bool IsRunningThread() const;
	
	//------------------------------------------------------------------
	/**
	* @brief  ^XN̓ݒύX
	* @param[in] pTaskName ^XN(char[TASK_NAME_LENGTH(8)])
	* @param[in] interval ^XNsԊuiPʂhourj
	* @param[in] count ^XNs񐔁i1~100)
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result ChangeTaskConfig( const char* pTaskName , const u32 interval , const u32 count );
	
	//------------------------------------------------------------------
	/**
	* @brief  o^̃^XN擾
	*
	* @retval ^XN
	*/
	//------------------------------------------------------------------
	u16 GetRegisterTaskNum( void );
	
	//------------------------------------------------------------------
	/**
	* @brief  o^̃^XN擾
	* @param[in] index CfbNX
	*
	* @retval ^XN(ȏꍇNULL)
	*/
	//------------------------------------------------------------------
	const char* GetRegisterTaskNum( const u16 index );
	
	//------------------------------------------------------------------
	/**
	* @brief  o^ĂXg[W̍őTCY擾
	*
	* @retval Xg[Ẅ̍őTCY
	*/
	//------------------------------------------------------------------
	size_t GetStorageSizeMax( void ) const;
	
	//------------------------------------------------------------------
	/**
	* @brief  o^ĂXg[W̍őt@C擾
	*
	* @retval Xg[W̍őt@C
	*/
	//------------------------------------------------------------------
	u16 GetStorageFileNumMax( void ) const;
	
	//------------------------------------------------------------------
	/**
	* @brief  OptOuttOݒ
	* @param[in] flag		trueݒ肷ƁANADL ^XN̎sɁANS A[JCuɊ܂܂Ă邨点f[^͔j܂BiVʒmȂj
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result SetOptoutFlag( const bool flag );

	//------------------------------------------------------------------
	/**
	* @brief  ݒ肳ĂOptOuttO擾
	* @param[out] pOutput ʂ󂯎ϐ
	* @return s
	*/
	//------------------------------------------------------------------
	nn::Result GetOptoutFlag( bool* pOutput ) const;
	
	
	//------------------------------------------------------------------
	/**
	* @brief  BOSSXg[W̃}Eg擾
	* @return }Eg
	*/
	//------------------------------------------------------------------
	const char* GetMountName( void ) const;
	
	//------------------------------------------------------------------
	/**
	* @brief  BOSSR[h擾
	* @return BOSSR[h
	*/
	//------------------------------------------------------------------
	const char* GetBossCode( void ) const;
	
public:

	//------------------------------------------------------------------
	/**
	* @brief  BOSSG[\
	*/
	//------------------------------------------------------------------
	static void PrintError( const nn::Result& result );
	
private://

	//------------------------------------------------------------------
	/**
	* @brief  Vf[^`FbN
	*/
	//------------------------------------------------------------------
	void _CheckNewArrivalData();

private://Cxgʒm֘A

	//------------------------------------------------------------------
	/**
	* @brief  Vf[^Cxg
	*/
	//------------------------------------------------------------------
	void _NotifyOnBossArrivalNewData( const u32 serialId );
	
	//------------------------------------------------------------------
	/**
	* @brief  f[^ǂݍ݊Cxg
	*/
	//------------------------------------------------------------------
	bool _NotifyOnBossReadData( const nn::boss::NsDataHeaderInfo* pHeader , const size_t bodySize , const u8* pBody );

	//------------------------------------------------------------------
	/**
	* @brief  t@CXg_E[hCxgs
	*/
	//------------------------------------------------------------------
	void _NotifyBossRecvFileListEvent( const char* pTaskName , const nn::boss::NsaList::NsaInformation* pFileList , const u32 fileNum );

	//------------------------------------------------------------------
	/**
	* @brief  t@CXg_E[hsCxgs
	*/
	//------------------------------------------------------------------
	void _NotifyBossRecvFileListEventFailed( const char* pTaskName , const nn::Result& result );
	
	//------------------------------------------------------------------
	/**
	* @brief  G[Cxgs
	*/
	//------------------------------------------------------------------
	void _NotifyOnBossError( const nn::Result& result );

	//------------------------------------------------------------------
	/**
	* @brief  ^XNG[Cxgs
	*/
	//------------------------------------------------------------------
	void _NotifyOnBossTaskError( const char* pTaskName , const u32 errorCode );

	
private://Xbh֘A

	//-------------------------------------------------------------------------------
	/**
	* @brief 񓯊ʐMsǂ𒲂ׂ
	* @retval true   s
	* @retval false  sĂȂ
	*/
	//-------------------------------------------------------------------------------
	bool _CheckAsync( void ) const;

	//-------------------------------------------------------------------------------
	/**
	* @brief s̔񓯊ʐMLZ
	*/
	//-------------------------------------------------------------------------------
	void _CancelAsync( void );

	//-------------------------------------------------------------------------------
	/**
	* @brief 񓯊̏I҂s܂B
	*/
	//-------------------------------------------------------------------------------
	void _WaitAsyncFinished( void ) const;

	//-------------------------------------------------------------------------------
	/**
	* @brief 񓯊VXej
	*/
	//-------------------------------------------------------------------------------
	void _DeleteAsync( void );
	
	
private:
 	gfl::heap::HeapBase* m_pHeapBase;     		//!< q[vx[X
	bool                 m_isInit;            	//!< ς݃tO
	nn::fnd::TimeSpan    m_timeout;           	//!< 񓯊^CAEg
	
	BossFilelistDownloadThread* m_pListDLThread;//!<_E[hXbh
	BossFileReadThread*	m_pFileReadThread;//!<t@Cǂݍ݃Xbh
	BossCheckNewArrivalDataThread* m_pCheckNewArrivalDataThread;//!<Vt@C擾Xbh
	BossImmediateTaskThread* m_pImmediateTaskThread;//!<s^XNXbh
	BossTaskRegisterThread* m_pTaskRegisterThread;//!<^XNo^Xbh

	s32					m_storageId;			//!<BOSSŎgpgZ[uf[^̈ID
	size_t				m_storageSize;			//!<gpTCYif[^Mɗ݌ṽTCYȏɂȂAÂ̂폜j
	u16					m_entryCount;			//!<őt@C(1~2000)if[^MɃt@CȏɂȂAÂ̂폜j
	nn::boss::TaskIdList m_taskList;			//!<^XNIDXg

	bool				m_isRunningImmediateTask;	//!<s^XNsǂ
	
	gfl::base::Thread::Priority m_threadPriority;//!<XbhDx
	
	nn::boss::NsaList::NsaInformation* m_pNsaListInfo; //!<_E[ht@CXg
	u32*				m_pSerialIDList;//!<Vt@CVAIDXg

	char				m_bossCode[MOUNT_NAME_LENGTH];//!<BOSSR[hi\0ŏI[Ă镶j	
	char				m_mountName[MOUNT_NAME_LENGTH];//!<gZ[uf[^}Eg
	BossEventListener*	m_apEventListener[MAX_LISTENER_NUM];	//!<CxgXi[
};

GFL_NAMESPACE_END(boss)
GFL_NAMESPACE_END(gflnet)

#endif // __GFLNET_BOSS_MANAGER_H__

