//=============================================================================
/**
 * @file   gflnet_BossEventListener.h
 * @brief  BossʒmCxgnhpNX
 * @author shin kosaka
 */
//=============================================================================

#ifndef __GFLNET_BOSS_EVENT_LISTENER_H__
#define __GFLNET_BOSS_EVENT_LISTENER_H__

#include <nn.h>
#include <gflib.h>


GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(boss)

//------------------------------------------------------------------
/**
 * @brief BossCxgʒmpNX
 *
 * @note Boss֘A̒ʒm󂯎ꍇ́A
 *       {NXpz֐ĂB
 */
//------------------------------------------------------------------
class BossEventListener
{
  //GFL_FORBID_COPY_AND_ASSIGN(BossEventListener); //Rs[RXgN^{֎~
public:

	//------------------------------------------------------------------
	/**
	* @brief Vf[^ʒmCxg
	* @param[in] serialId			f[^̃VAID
	*
	*		Vf[^BOSSXg[WɓƂʒmCxgłB
	*/
	//------------------------------------------------------------------
	virtual void OnBossArrivalNewData( const u32 serialId ) = 0;
	
	//------------------------------------------------------------------
	/**
	* @brief wb_ǂݍ݊Cxg
	*
	* @param[in] pHeader		f[^wb_(NsDataHeaderInfo)
	* @return 	true : lς݃tOONɂiȍ~̃Xi[ɂʒm܂j
	* 			false: lς݃tOONɂȂiȍ~̃Xi[ɂʒm܂j
	*
	* 			struct NsDataHeaderInfo
	* 			{
	* 			   s64 titleId;					//64rbg̃^CgID
	* 			   bit32 flags;					//NSD̃tO
	* 	    	   bit32 dataType;				//NSD̃f[^^Cv
	* 	    	   s32 length;					//NSD̒
	* 	    	   u32 serialId;				//NSD̃VAID
	* 	    	   u32 version;					//NSD̃o[Wԍ
	* 	    	};
	*		
	*/
	//------------------------------------------------------------------
	virtual bool OnBossReadHeader( const nn::boss::NsDataHeaderInfo* pHeader ) = 0;
	
	//------------------------------------------------------------------
	/**
	* @brief f[^ǂݍ݊Cxg
	*
	* @param[in] pHeader		f[^wb_(NsDataHeaderInfo)
	* @param[in] bodySize    	{fBTCY
	* @param[in] pBody			f[^{
	* @return 	true : lς݃tOONɂiȍ~̃Xi[ɂʒm܂j
	* 			false: lς݃tOONɂȂiȍ~̃Xi[ɂʒm܂j
	*
	* 			struct NsDataHeaderInfo
	* 			{
	* 			   s64 titleId;					//64rbg̃^CgID
	* 			   bit32 flags;					//NSD̃tO
	* 	    	   bit32 dataType;				//NSD̃f[^^Cv
	* 	    	   s32 length;					//NSD̒
	* 	    	   u32 serialId;				//NSD̃VAID
	* 	    	   u32 version;					//NSD̃o[Wԍ
	* 	    	};
	*		
	*/
	//------------------------------------------------------------------
	virtual bool OnBossReadData( const nn::boss::NsDataHeaderInfo* pHeader , const size_t bodySize , const u8* pBody ) = 0;

	//------------------------------------------------------------------
	/**
	* @brief t@CXg_E[hCxg
	*
	* @param[in] pTaskName		^XNi[U^XN_E[hJnɐݒ肵́j
	* @param[in] pFileList    	t@CXg(nn::boss::NsaList::NsaInformation)
	* @param[in] fileNum    		t@C
	* 		
	* @note pFileList͔zɂȂĂ܂B
	*       pFileList[fileNum-1]܂ŃANZXł܂B
	* 
	* 		struct NsaInformation
	* 		{
	* 		   char fileName[32];      	//t@C(ő31)
	* 		   u32 fileSize;			//t@CTCY(Pʂ̓oCg)
	* 	       u32 updateEpochTime;		//t@C̍XV(unix epochł邽߁A1970-01-01 00:00:00̌oߕb)BNSǍJJnlp邽߁A_E[hHTTPX|XLast-ModifiedƈvlƂȂB
	* 	       char attribute1[10];		//1(ő9̕)Bgp\ȕ́Al(0-9)AAt@xbg(a-z,A-Z)AA_[o[(_)݂̂łBT[oUINSAƂɔCӂ̒lݒłBNSAXg擾ɂɊ܂܂NSAw肷邽߂̌vfƂȂB
	* 	       char attribute2[10];		//2(ő9̕)Bgp\ȕʒuẤAattribute1 Ɠl
	* 	       char attribute3[10];		//3(ő9̕)Bgp\ȕʒuẤAattribute1 Ɠl
	* 	       u8 caption[150];			//BUTF-8ōŒ50̕BT[oUINSAƂɔCӂ̒lݒłB
	*		};
	*/
	//------------------------------------------------------------------
	virtual void OnBossRecvFileList( const char* pTaskName , const nn::boss::NsaList::NsaInformation* pFileList , const u32 fileNum ) = 0;
	
	//------------------------------------------------------------------
	/**
	* @brief t@CXg_E[hsʒmCxg
	*
	* @param[in] pTaskName		^XNi[U^XNo^ɐݒ肵́j
	* @param[in] result			s
	*/
	//------------------------------------------------------------------
	virtual void OnBossRecvFileListFailed( const char* pTaskName , const nn::Result& result ) = 0;
	
	//------------------------------------------------------------------
	/**
	* @brief G[ʒmCxg
	*
	* @param[in] result		s
	*/
	//------------------------------------------------------------------
	virtual void OnBossError( const nn::Result& result ) = 0;

	//------------------------------------------------------------------
	/**
	* @brief ^XNG[ʒmCxg
	*
	* @param[in] pTaskName		^XNi[U^XNo^ɐݒ肵́j
	* @param[in] errorCode		G[R[h(nn::boss::TaskResultCode)
	*/
	//------------------------------------------------------------------
	virtual void OnBossTaskError( const char* pTaskName , const u32 errorCode ) = 0;
};


GFL_NAMESPACE_END(boss)
GFL_NAMESPACE_END(gflnet)



#endif // __GFLNET_BOSS_EVENT_LISTENER_H__
