//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		DistritionDraw.cpp
 *	@brief  DistritionDraw
 *	@author	Masateru Ishiguro
 *	@date		2012.07.26
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system/DistritionDraw.h"

namespace xy_system {

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::RenderTarget* DrawUtil::CreatreRenderTarget( gfl::grp::GraphicsSystem* graphics_system, gfl::grp::DisplayType displayType, gfl::heap::NwAllocator* p_heap_allocator, gfl::heap::NwAllocator* p_device_allocator )
{
  gfl::grp::RenderTarget*               p_render_target;
  const gfl::grp::RenderTarget          *p_frame_buffer = NULL;
  gfl::grp::FrameBufferManager          *p_frame_buffer_manager = NULL;
  gfl::grp::RenderTarget::Description   desc;

  p_frame_buffer_manager = graphics_system->GetFrameBufferManager();
  p_frame_buffer = p_frame_buffer_manager->GetRenderTarget( graphics_system->GetCurrentFrameBufferID( displayType ) );

  desc.width = p_frame_buffer->GetWidth();//512
  desc.height = p_frame_buffer->GetHeight();//256
  desc.display_type = displayType;

  p_render_target = GFL_NEW(p_heap_allocator->GetHeapBase()) gfl::grp::RenderTarget();
  p_render_target->Create( p_heap_allocator, p_device_allocator, &desc );
  
  return p_render_target;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void DrawUtil::DeleteRenderTarget( gfl::grp::RenderTarget* renderTarget )
{
  renderTarget->Destroy();
  GFL_DELETE renderTarget;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void DrawUtil::FrameBufferCopy( gfl::grp::GraphicsSystem* graphics_system, gfl::grp::DisplayType displayType, gfl::grp::RenderTarget* render_target )
{
  gfl::grp::FrameBufferManager  *frame_buffer_manager = graphics_system->GetFrameBufferManager();
  gfl::grp::RenderTarget        *p_frame_buffer = frame_buffer_manager->GetRenderTarget( displayType );
  static const s32              VERTEX_MAX = 4;
  gfl::grp::util::Vertex        vertex[VERTEX_MAX];

  graphics_system->BindCurrentCommandList( displayType );
    
  gfl::grp::util::DrawUtil::BeginRender( render_target );
  
  {
    gfl::math::MTX44 identity_matrix;
    gfl::math::MTX44Identity( &identity_matrix );
    
    gfl::grp::util::DrawUtil::SetViewMatrix( identity_matrix );
    gfl::grp::util::DrawUtil::SetProjectionMatrix( identity_matrix );
    gfl::grp::util::DrawUtil::SetModelMatrix( identity_matrix );
  }
  
  if ( 1 )
  {//J[C[Wxb^Rs[
    
    vertex[0].m_Position.Set(  -1,  1, 0 );
    vertex[1].m_Position.Set(   1,  1, 0 );
    vertex[2].m_Position.Set(  -1, -1, 0 );
    vertex[3].m_Position.Set(   1, -1, 0 );
      
    {
      f32 left, top, right, bottom;

      p_frame_buffer->GetViewport( &left, &top, &right, &bottom );

      //f32   u = 240.0f / 256.0f;
      //f32   v = 400.0f / 512.0f;
      f32   u = (bottom - top) / p_frame_buffer->GetHeight();
      f32   v = (right - left) / p_frame_buffer->GetWidth();

      vertex[0].m_Uv.Set( 0.0f,    v );//fkW
      vertex[1].m_Uv.Set(    u,    v );//EfkW
      vertex[2].m_Uv.Set( 0.0f, 0.0f );//fkW
      vertex[3].m_Uv.Set(    u, 0.0f );//EfkW
    }
    
    for( s32 cnt = 0; cnt < VERTEX_MAX; ++cnt )
    {
      vertex[cnt].m_Color.Set(  1.0f,  1.0f, 1.0f, 1.0f );
    }

    gfl::grp::util::DrawUtil::MaterialInfo    info;
    info.m_ShadingType = gfl::grp::util::DrawUtil::MaterialInfo::RGBTEXTURE_SHADER;
    gfl::grp::util::DrawUtil::SetMaterial( info );

    gfl::grp::util::DrawUtil::SetTexture( 0, nngxGetPhysicalAddr(p_frame_buffer->GetColorAddress()), p_frame_buffer->GetHeight(), p_frame_buffer->GetWidth(), GL_RGBA );
    gfl::grp::util::DrawUtil::SetRenderState( gfl::grp::util::DrawUtil::RenderStateType::MODEL_3D );

    static const u32 s_RenderStateCommands[] =
    {
        // fvXeXg𖳌
        // J[obt@̃ɂ͏܂Ȃ
        NW_FONT_CMD_SET_DEPTH_FUNC_COLOR_MASK(
            false,   // isDepthTestEnabled
            PICA_DATA_DEPTH_TEST_ALWAYS,      // depthFunc
            false,   // depthMask
            true,   // red
            true,   // green
            true,   // blue
            false), // alpha

        // t[obt@ANZX
        NW_FONT_CMD_SET_FBACCESS(
            true,   // colorRead
            true,   // colorWrite
            false,  // depthRead
            false,  // depthWrite
            false,  // stencilRead
            false), // stencilWrite
    };

    nngxAdd3DCommand(s_RenderStateCommands, sizeof(s_RenderStateCommands), true);

    gfl::grp::util::DrawUtil::DrawVertexStrip( vertex, 4, false );
  }

  gfl::grp::util::DrawUtil::EndRender();
  
  nngxFlush3DCommand();
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void DrawUtil::ShaerChangeFn::SetRenderTexture( const gfl::grp::RenderTarget* pRenderTarget, s32 textureNo )
{
  s32   materialNum = m_pModel->GetNwModel()->GetMaterialCount();

  for( s32 materialNo = 0; materialNo < materialNum; ++materialNo )
  {
    nw::gfx::Material                     *material = m_pModel->GetNwModel()->GetMaterial( materialNo );
    nw::gfx::ResMaterial                  res_material = material->GetMaterialColorResMaterial();   

    {//eNX`ݒ
      nw::gfx::ResPixelBasedTextureMapper   res_tex_mapper = res_material.GetTextureMappers( textureNo );
        
      if ( res_tex_mapper.IsValid() == false )
        continue;
      
      nw::gfx::res::ResTexture              render_texture = pRenderTarget->GetNwResTexture();
      
      res_tex_mapper.SetTexture( render_texture );
      
      // eNX`ύXꍇ̓eNX`}bp[̃nbVOɐݒ肵܂B
      res_material.SetTextureMappersHash(0x0);
    }
  }
}

}  // namespace xy_system

