//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		poke_tool_ExtendData.cpp
 *	@brief  p[\iOɂ|PƂ̃f[^
 *	@author	Toru=Nagihashi
 *	@date		2012.05.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <poke_tool/poke_tool_ExtendData.h>
#include <arc/zukan_data.gaix>

GFL_NAMESPACE_BEGIN(poke_tool)


//--------------------------------------------------------------------
// Ej
//--------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 */
ExtendData::ExtendData( gfl::heap::HeapBase *heap ) :
  m_next_form_table(NULL),
  m_next_form_table_size(0),
  m_zenkoku_to_local_table(NULL),
  m_local_table_size(0),
  m_style_table(NULL),
  m_style_table_size(0),
  m_initial_table(NULL),
  m_initial_table_size(0)
{
  m_arc_file  = GFL_NEW( heap ) gfl::fs::ArcFile( heap, ARCID_ZUKAN_DATA, gfl::fs::ArcFile::OPEN );
}

/**
 * @brief fXgN^
 */
ExtendData::~ExtendData()
{
  if( m_initial_table )
  {
    GflHeapFreeMemory( m_initial_table );
  }
  if( m_next_form_table )
  {
    GflHeapFreeMemory( m_next_form_table );
  }
  if( m_style_table )
  {
    GflHeapFreeMemory( m_style_table );
  }
  if( m_zenkoku_to_local_table )
  {
    GflHeapFreeMemory( m_zenkoku_to_local_table );
  }
  
  GFL_SAFE_DELETE( m_arc_file );
}

/**
 * @brief ǂݍ
 *
 * @param heap  q[v
 */
void ExtendData::Load( gfl::heap::HeapBase *heap )
{
  //Sne[u
  m_zenkoku_to_local_table = pml::personal::PersonalData::CreateZenkokuToChihouTable( heap, &m_local_table_size );
  
  m_style_table = static_cast<u8*>( this->AllocData( heap, m_arc_file, GARC_zukan_data_zkn_style_DAT, &m_style_table_size ) );
  
  m_next_form_table = static_cast<u16*>( this->AllocData( heap, m_arc_file, GARC_zukan_data_zkn_next_form_pos_DAT, &m_next_form_table_size ) );

  //@todo ΉH
  m_initial_table = static_cast<u8*>( this->AllocData( heap, m_arc_file, GARC_zukan_data_zkn_initial_DAT, &m_initial_table_size ) );
}

//--------------------------------------------------------------------
// 擾
//--------------------------------------------------------------------
/**
 * @brief n}ӂɂ邩ǂ
 *
 * @return truen}ӂɂ falseȂ
 */
bool ExtendData::IsExistLocalZukan( u32 zenkoku_num ) const
{
  return this->GetLocalNumber( zenkoku_num ) != pml::personal::CHIHOU_NO_NONE;
}
bool ExtendData::IsExistLocalZukan( const pml::pokepara::CoreParam *core_param ) const
{
  return this->IsExistLocalZukan( static_cast<u32>(core_param->GetMonsNo()) );
}

/**
 * @brief n}Ӕԍ擾
 *
 * @return n}Ӕԍ Ȃꍇpml::personal::CHIHOU_NO_NONE
 * 
 * @note āuS}ӔԍvƂӖ̂MonsNo`ɂĂ܂
 */
u32 ExtendData::GetLocalNumber( u32 zenkoku_num ) const
{
  GFL_ASSERT( zenkoku_num < m_local_table_size/2 );
  return m_zenkoku_to_local_table[ zenkoku_num ];
}
u32 ExtendData::GetLocalNumber( const pml::pokepara::CoreParam *core_param ) const
{
  return this->GetLocalNumber(core_param->GetMonsNo() );
}

/**
 * @brief S}Ӕԍ擾
 *
 * @return S}Ӕԍ
 */
u32 ExtendData::GetZenkokuNumber( u32 local_num ) const
{
  for(int i=0; i <= MONSNO_END; ++i)
  {
    if( m_zenkoku_to_local_table[i] == local_num )
    {
      return i;
    }
  }
  GFL_ASSERT_MSG( 0, "݂Ȃnԍ=%d\n", local_num);
  return MONSNO_NULL;
}

/**
 * @brief   `擾
 *
 * @param simple_param    Vvp
 *
 * @return  `
 */
ExtendData::StyleType ExtendData::GetStyleType( const SimpleParam & simple_param ) const
{
  u32 index = this->GetTableIndex( simple_param.monsNo, simple_param.formNo );
  
  GFL_ASSERT( index < m_style_table_size );
  return static_cast<StyleType>( m_style_table[ index ] );

}
ExtendData::StyleType ExtendData::GetStyleType( const pml::pokepara::CoreParam *core_param ) const
{
  SimpleParam simple_param;
  GetSimpleParam( &simple_param, core_param );
  return this->GetStyleType( simple_param );
}

/**
 * @brief CfbNX擾
 *
 * @return CfbNX
 *
 * @note  zkn_sort_aiueo_idx̃CfbNX܂
 * 
 * @todo ΉH
 */
u8 ExtendData::GetInitialIndex( const SimpleParam & simple_param ) const
{
  GFL_ASSERT( simple_param.monsNo < m_initial_table_size );
  return m_initial_table[ simple_param.monsNo ];
}
u8 ExtendData::GetInitialIndex( const pml::pokepara::CoreParam *core_param ) const
{
  SimpleParam simple_param;
  GetSimpleParam( &simple_param, core_param );
  return this->GetInitialIndex( simple_param );
}

//--------------------------------------------------------------------
// 擾
//--------------------------------------------------------------------
/**
 * @brief AP[gāÄ̗Ƀt@CǍ
 *
 * @param arc_file  A[Nt@C
 * @param gfl::fs::ArcFile::ARCDATID  ǂݍރf[^ID
 * @param size ǂݍ񂾃t@C̃TCYiۂ̃obt@͂̃TCŶSoCgACgj
 *
 * @return AP[g
 */
void * ExtendData::AllocData( gfl::heap::HeapBase * heap, gfl::fs::ArcFile *arc_file, gfl::fs::ArcFile::ARCDATID dat_id, size_t * size )
{
  *size  = arc_file->GetDataSize( dat_id );
  void * data = GflHeapAllocMemoryAlign( heap, *size, 4 );
  m_arc_file->LoadData( dat_id, data );
  return data;
}

/**
 * @brief tH݃e[ũCfbNX߂
 *
 * @param monsno  X^[ԍ
 * @param formno  tHԍ
 *
 * @return  CfbNX
 */
u32 ExtendData::GetTableIndex( MonsNo monsno, FormNo formno ) const
{  
  u16 formno_count = 0;
  u16 pos = static_cast<u16>(monsno);

  while( formno_count != formno )
  {
    pos = m_next_form_table[pos];
    if( pos == 0 ) break;
    formno_count++;
  }
  
  GFL_ASSERT_MSG( pos > 0, "tHԍُłBmosno=%d form=%d pos=%d\n", monsno, formno, pos );

  return pos;
}
  
GFL_NAMESPACE_END(poke_tool)
