//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_search_ParentView.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.08.08
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_search_ParentView.h"
#include "app_zukan_search_InputView.h"
#include "app_zukan_search_ResultView.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)
GFL_NAMESPACE_BEGIN(search)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief RXgN^
 *  @param heap q[v
 *  @param Graphics OtBbN}l[W[
 *  @param data_manager f[^}l[W[
 */
ParentView::ParentView( app::util::Heap * heap, Graphics * graphics, DataManager * data_manager ) :
  IView( heap, graphics ),
  m_data_manager( data_manager ),
  m_listener( NULL ),
  m_input_view( NULL ),
  m_result_view( NULL )
{
  m_input_view = GFL_NEW( heap->GetSystemHeap()) InputView( heap, graphics, data_manager );
  this->AddSubView( m_input_view );

  m_result_view = GFL_NEW( heap->GetSystemHeap()) ResultView( heap, graphics, data_manager );
  this->AddSubView( m_result_view );

  //ʃ^b`o[
  m_touchbar_view = graphics->GetTouchbarView();
  m_touchbar_view->ChangeMode( graphics->GetLayoutSystem(), TouchbarView::MODE_LIST, m_result_view->GetLayoutWork(0) );
  m_touchbar_view->SetListener( this );
  this->AddSubView( m_touchbar_view );
}

/**
 *  @brief fXgN^
 */
ParentView::~ParentView()
{
  m_touchbar_view->SetListener( NULL );
  m_touchbar_view->RemoveFromSuperView();
  
  m_result_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_result_view );

  m_input_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_input_view );
 
}
//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 *  @brief `
 */
void ParentView::Draw(void)
{
  //ʂView𓝊邾ŁAg̕`͂ȂɂȂ
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief Xio^
 *
 * @param listenerXi[
 */
void ParentView::SetListener( ParentViewListener *listener )
{
  m_listener  = listener;
}


//-----------------------------------------------------------------------
// TouchbarListerp
//-----------------------------------------------------------------------
/**
 * @brief ^b`o[ŉ{^Ԃ
 *
 * @param buttonID@{^
 *
 * @return trueő̃Xis
 */
bool ParentView::OnSelectedButton( u32 buttonID )
{
  if( m_listener )
  {
    //Parent̃XiĂяo
    return m_listener->OnTouchbarSelected( buttonID );
  }
  
  return true;
}

/**
 * @brief |P̑I؂ւ
 *
 * @param monsno  I𒆂̃|Pԍ
 *
 * @return  trueő̃Xis  falseŔr 
 */
bool ParentView::OnSelectPokemon( MonsNo monsno )
{
  poke_tool::SimpleParam  param;
  
  m_data_manager->GetListData()->GetCurrentPokemon( &param );

  //m_detail_view->WritePokemonDetail( &param );
  
  const savedata::ZukanData *zukan_save = m_data_manager->GetZukanData();
  
  if( m_graphics->GetPokeModel() )
  {
    m_graphics->GetPokeModel()->SetVisible( false );
  }

  if( zukan_save->GetPokeGetFlag( monsno )
    || zukan_save->GetPokeSeeFlag( monsno ) )
  {
    m_graphics->RequestChangePokeModel( &param );
  }
  return false;
}

/**
 * @brief |P肵
 *
 * @param monsno  肵|Pԍ
 *
 * @return  trueő̃Xis  falseŔr
 */
bool ParentView::OnDecidePokemon( MonsNo monsno )
{
  //@todo ڍׂւ
  return false;
}

GFL_NAMESPACE_END(search)
GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
