//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkProc.cpp
 *  @brief   lbg[NŃzObpQ[vZXNX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <Gamesystem/GameProcManager.h>
#include <app/hologram_mail/app_hologrammail_NetworkProc.h>
#include <app/util/app_util_Common.h>

#include "app_hologrammail_NetworkMain.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief  RXgN^
 *  @param  param 
 */
NetworkProc::NetworkProc( PARAM *param ) :
  gamesystem::GameProc(),
  m_param( param ),
  m_main( NULL )
{
  //q[v쐬
  m_heap.Create( HEAPID_HOLOGRAMMAIL_SYSTEM, SYSTEM_HEAP_SIZE, HEAPID_HOLOGRAMMAIL_DEVICE, DEVICE_HEAP_SIZE );
}


/**
 *  @brief  fXgN^
 */
NetworkProc::~NetworkProc()
{
  //q[vj
  m_heap.Delete();
}


//-----------------------------------------------------------------------
// GameProcI[o[Cg
//-----------------------------------------------------------------------
/**
 *  @brief  PROC
 *  @param  Manager vZX}l[W[
 *  @return Result IR[h
 */
gfl::proc::Result NetworkProc::InitFunc(gfl::proc::Manager *proc )
{
  gamesystem::GameManager* gameMgr = mpGameProcManager->GetGameManager();

  //쐬
  m_main = GFL_NEW( m_heap.GetSystemHeap() ) NetworkMain( &m_heap );
  m_main->Initialize( gameMgr );

  return gfl::proc::RES_FINISH;
}

/**
 *  @brief  PROCj
 *  @param  Manager vZX}l[W[
 *  @return Result IR[h
 */
gfl::proc::Result NetworkProc::EndFunc(gfl::proc::Manager * )
{
  if( m_main != NULL )
  {
    m_main->Finalize();

    GFL_SAFE_DELETE( m_main );
    m_main = NULL;
  }

  return gfl::proc::RES_FINISH;
}

/**
 *  @brief  PROCC
 *  @param  Manager vZX}l[W[
 *  @return Result IR[h
 */
gfl::proc::Result NetworkProc::UpdateFunc(gfl::proc::Manager * )
{
  if( m_main != NULL )
  {
    if( !m_main->Update() )
    {
      return gfl::proc::RES_CONTINUE;
    }
  }
  return gfl::proc::RES_FINISH;
}

/**
 *  @brief  PROC`
 *  @param  Manager vZX}l[W[
 *  @return Result IR[h
 */
void NetworkProc::DrawFunc(gfl::proc::Manager * )
{
  if( m_main != NULL )
  {
    m_main->Draw();
  }
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------


GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

