//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkMain.h
 *  @brief   lbg[NŃzOb̃CRg[NX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#pragma once
#if !defined( __APP_HOLOGRAMMAIL_NETWORK_MAIN_H__)
#define __APP_HOLOGRAMMAIL_NETWORK_MAIN_H__

#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <app/util/app_util_heap.h>
#include "app_hologrammail_NetworkParentViewListener.h"
#include "app_hologrammail_NetworkMailListView.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

class NetworkParentView;

/**
*  @brief   lbg[NŃzOb̃CRg[NX
*/
class NetworkMain : public NetworkParentViewListener
{
  GFL_FORBID_COPY_AND_ASSIGN(NetworkMain);
public:

  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   *  @brief  RXgN^
   *  @param  param (OAllocĂ)
   */
  NetworkMain( app::util::Heap* heap );
  /**
   *  @brief  fXgN^
   */
  virtual ~NetworkMain();

  //-----------------------------------------------------------------------
  //
  //-----------------------------------------------------------------------
  void Initialize( gamesystem::GameManager* gameMgr );
  void Finalize( void );


  bool Update( void );
  void Draw( void );


  //-----------------------------------------------------------------------
  // NetworkParentViewListener̎
  //-----------------------------------------------------------------------
  /**
   * @brief Xg莞ɌĂ΂
   *        Xg͒~[hɈڍsA
   *        NetworkParentView::RestartListĂ΂ȂƍĊJȂB
   *
   * @param list_index  Xg̃CfbNX
   */
  virtual void OnSelectedList( u16 list_index );
  /**
   * @brief ʂ̘bA̗ꂪIɌĂ΂
   *        bA̗NetworkParentView::StartTalkCharacterԂƂŊJn
   */
  virtual void OnEndTalkCharacter(void );
  /**
   * @brief Exit{^ꂽɌĂ΂
   */
  virtual void OnSelectedExitButton( void );
  /**
   * @brief Return{^ꂽɌĂ΂
   */
  virtual void OnSelectedReturnButton( void );

private:
  bool UpdateSequence( void );

  void CreateListData( void );
  void DeleteListData( void );

private:
  /**
   * @brief V[PXf[^
   */
  enum Sequence
  {
    SEQUENCE_START,        //!< SEQUENCE_START
    SEQUENCE_LOAD,         //!< SEQUENCE_LOAD
    SEQUENCE_FADEIN_START, //!< SEQUENCE_FADEIN_START
    SEQUENCE_FADEIN_WAIT,  //!< SEQUENCE_FADEIN_WAIT
    SEQUENCE_MAIN,         //!< SEQUENCE_MAIN
    SEQUENCE_FADEOUT_START,//!< SEQUENCE_FADEOUT_START
    SEQUENCE_FADEOUT_WAIT, //!< SEQUENCE_FADEOUT_WAIT
    SEQUENCE_END,          //!< SEQUENCE_END
  };

private:
  NetworkParentView*             m_parent_view;   //!< lbg[NyAgVIEW
  NetworkMailListView::ListData* m_list_data;     //!< XgVIEW
  app::util::Heap*               m_heap;          //!< q[v
  Sequence                       m_sequence;      //!< V[PX
  u32                            m_list_data_num; //!< Xg
  gfl::str::StrBuf*              m_talk_message;  //!< bbZ[W
};


GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)



#endif    // __APP_HOLOGRAMMAIL_NETWORK_MAIN_H__


