//==============================================================================
/**
 * @file	handicap_battle.cpp
 * @brief	nf	vZ`
 * @author	ichiraku_katsuhiko
 * @data	2012/08/08, 19:40
 */
// =============================================================================

#include <battle/handicap_battle.h>
#include <nn/math.h>

GFL_NAMESPACE_BEGIN(btl)

f32 HandicapBattle::S8ToF32( s8 value )
{
	return (f32)( (value) / (f32)(1 << FX8_SHIFT) );
}

s8 HandicapBattle::F32ToS8( f32 value )
{
	if( value > 0.0f ){
		return (s8)( (value) * ( 1 << FX8_SHIFT) + 0.5f );
	}else {
		return (s8)( (value) * ( 1 << FX8_SHIFT) - 0.5f );
	}
}

GFL_NAMESPACE_END(btl)
