//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		EventAppCallCommon.h
 *	@brief  EventAppCalľĂяoAR[obN̎
 *	@author	Toru=Nagihashi
 *	@date		2012.08.08
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <gflib.h>
#include <gamesystem/GameData.h>
#include "EventAppCall.h"
#include "EventAppCallCommon.h"

#include <app/box/box.h>

namespace field {
namespace app_call {
  
//=============================================================================
/**
 *  {bNXIʌĂяo
 */
//=============================================================================
/**
 * @brief   CallBoxSelectŎgpR[obN
 *
 * @param p_work  R[obN[N
 * @param p_gman  Q[}l[W[
 */
static void CallBackBoxSelect( EventAppCall::CALLBACK_WORK* p_work, gamesystem::GameManager* p_gman )
{
  gamesystem::GameData* game_data = p_gman->GetGameData();
  field::EventWork* event_work  = game_data->GetEventWork();
  app::box::APP_PARAM * box_param = static_cast<app::box::APP_PARAM *>(p_work->p_param);
  
  u16 *wk_is_select     =  event_work->GetEventWorkAdrs( p_work->ret_wk1 );
  u16 *wk_box_or_party  =  event_work->GetEventWorkAdrs( p_work->ret_wk2 );
  u16 *wk_ret_index     =  event_work->GetEventWorkAdrs( p_work->ret_wk3 );
  
  switch( box_param->endMode )
  {
  case app::box::BOX_END_SELECT_TRAY_BATTLE_BOX:  //ogBOX
    *wk_is_select     = true;
    *wk_box_or_party  = CALL_BOX_SELECT_BATTLE_BOX;
    *wk_ret_index     = box_param->selPos;
    break;
  case app::box::BOX_END_SELECT_TRAY_PARTY: //莝
    *wk_is_select     = true;
    *wk_box_or_party  = CALL_BOX_SELECT_PARTY;
    *wk_ret_index     = box_param->selPos;
    break;
  default://BOXI
    *wk_is_select     = true;
    *wk_box_or_party  = box_param->selTray;
    *wk_ret_index     = box_param->selPos;
    break;
  case app::box::BOX_END_SELECT_NONE: //LZ
    *wk_is_select     = false;
    break;
  }
}

/**
 * @brief {bNXIAvĂяo
 *
 * @param heap  q[v
 * @param ret_is_select   uIHvۑCxg[NID
 * @param ret_box_or_partyuǂIvۑCxg[NID@`͏L
 * @param ret_index uIʒuvۑCxg[NID
 *
 * @return  EventAppCall
 */
EventAppCall * CallBoxSelect( gfl::heap::HeapBase * heap, gamesystem::GameData * game_data, u16 ret_is_select, u16 ret_box_or_party, u16 ret_index )
{
  EventAppCall * event  = GFL_NEW(heap) EventAppCall( heap );
  
  app::box::APP_PARAM * param = reinterpret_cast<app::box::APP_PARAM *>( event->SetCallTargetApplicationAndAllocParam( EventAppCall::CALL_TARGET_BOX_ONLY, sizeof(app::box::APP_PARAM), CallBackBoxSelect ) );
  
  param->pSaveBox     = game_data->GetBox();
  param->pSaveBoxPokemon  = game_data->GetBoxPokemon();
  param->pBattleBox   = game_data->GetBattleBox();
  param->pPokeParty   = game_data->GetPlayerParty();
  param->pMyStatus    = game_data->GetPlayerStatus();
  param->pSaveMyItem  = game_data->GetMyItem();
  param->pSaveBag     = game_data->GetBag();
  param->pPlayData    = game_data->GetBagPlayData();
  param->pMisc        = game_data->GetMisc();
  param->callMode     = app::box::BOX_CALL_MODE_TRADE;
  //param->trade      =;  RXgN^ŎwȂɂȂĂ
    
  event->SetRetWork( ret_is_select, ret_box_or_party, ret_index );

  return event;
}

}  //namespace app_call
}  //namespace field
