//============================================================================================
/**
 * @file		trade_demo.h
 * @brief		fProc
 * @author	Akito Mori
 * @date		12.08.07
 *
 * namespace	app::trade_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#if !defined( __TRADE_DEMO_H__ )
#define __TRADE_DEMO_H__

#include <gflib.h>
#include <gfl_Device.h>
#include "gamesystem/GameProc.h"
#include "system/sequence/Player.h"

/**
  * @namespace app::trade_demo
  * @brief     f
  */
namespace app {
namespace trade_demo {

/// f̃[h
enum DEMO_MODE{
  MODE_EXCHANGE=0,        ///< ʏ̌f
  MODE_UPLOAD,            ///< Abv[ĥ
  MODE_DOWNLOAD,          ///< _E[ĥ
  MODE_EXCHANGE_DOWNLOAD, ///< ă_E[h
  MODE_MAX,
};

/// Oݒp[^if[^EĨf[^Ȃǁj
typedef struct {
  DEMO_MODE                DemoMode;       ///< f̍Đ[h
  pml::pokepara::CoreParam *pMyPoke;       ///< ̃|P
  pml::pokepara::CoreParam *pOthersPoke;   ///< ̃|P
  savedata::MyStatus       *pMyStatus;     ///< vC[Xe[^XiobOŕKvj
  xynet::XyNetManager      *pXyNetManager; ///< lbg}l[W[NX̃|C^
}APP_PARAM;

class MainSystem;

class Proc : public gamesystem::GameProc {		// NX[gamesystem::GameProc]p
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	Proc( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~Proc();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result InitFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcI
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result EndFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcAbvf[g
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc`揈
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void DrawFunc( gfl::proc::Manager * proc_manager );

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateHeap(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteHeap(void);

private:
	gfl::heap::HeapBase * pHeap;	///< VXeq[v
	MainSystem * pMain;           ///< NX
};


}	// trade_demo
}	// app

#endif // __TRADE_DEMO_H__
