//============================================================================================
/**
 * @file		trade_demo_ui.cpp
 * @brief		UI֘A
 * @author	mori
 * @date		12.08.07
 *
 * namespace	app::trade_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "trade_demo_ui.h"


namespace app {
namespace trade_demo {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		man			UIfoCX}l[W
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
UI::UI( gfl::ui::DeviceManager * man, app::util::Heap * heap )
{
	CreateUI( man, heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
UI::~UI()
{
	DeleteUI();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fobOpI{^擾
 *
 * @param		none
 *
 * @retval	"true = ꂽ"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool UI::DEBUG_GetEndButton(void)
{
	return pButton->IsTrigger( gfl::ui::BUTTON_B );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		UI֘A쐬
 *
 * @param		man			UIfoCX}l[W
 * @param		haap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void UI::CreateUI( gfl::ui::DeviceManager * man, app::util::Heap * heap )
{
	pUiDeviceManager = man;
	pButton     = pUiDeviceManager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
	pKey        = pUiDeviceManager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
	pStick      = pUiDeviceManager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
	pTouchPanel = pUiDeviceManager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );

#ifdef	TRADE_DEMO_USE_UI_GYROSCOPE
	// WC
	pUiDeviceManager->BootGyroscope( heap->pHeap, gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	pGyroscope  = pUiDeviceManager->GetGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	pGyroscope->SetZeroDriftMode( gfl::ui::Gyroscope::ZERO_DRIFT_MODE_TIGHT );
	pGyroscope->DisableRevisionByAcceleration();
	pGyroscope->DisableZeroDrift();
#endif	// TRADE_DEMO_USE_UI_GYROSCOPE

#ifdef	TRADE_DEMO_USE_UI_ACCELEROMETER
	// xZT[
	pUiDeviceManager->BootAccelerometer( heap->pHeap, gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
	pAccelerometer = pUiDeviceManager->GetAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
#endif	// TRADE_DEMO_USE_UI_ACCELEROMETER
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		UI֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void UI::DeleteUI(void)
{
#ifdef	TRADE_DEMO_USE_UI_ACCELEROMETER
	pUiDeviceManager->StopAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
#endif	// TRADE_DEMO_USE_UI_ACCELEROMETER
#ifdef	TRADE_DEMO_USE_UI_GYROSCOPE
	pUiDeviceManager->StopGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
#endif	// TRADE_DEMO_USE_UI_GYROSCOPE
}


}		// trade_demo
}		// app
