//============================================================================================
/**
 * @file		trade_demo_graphic.cpp
 * @brief		OtBbN֘A
 * @author	mori
 * @date		12.08.07
 *
 * namespace	app::trade_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
//#include "arc/arc_def.h"
#include "trade_demo_graphic.h"
#include "arc/arc_def.h"
#include "arc/demo_data.gaix"
//#include "message/msg_trade_demo.h"
//#include "trade_demo_res.h"
//#include "trade_demo_res_pane.h"


namespace app {
namespace trade_demo {

static const u32 TRADE_DEMO_MODEL_DATA_MAX = 2;		// ff[^o^


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap, APP_PARAM *param )
{
  m_param = param;
  
	CreateGraphicsSystem( heap );

	Create2D( heap );
	Create3D( heap );
	
	m_pokecount = 0;
  m_pokecount += SetupSimpleParam( 0, m_param->pMyPoke );
  m_pokecount += SetupSimpleParam( 1, m_param->pOthersPoke );
  CreateSeqPlayer( heap );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork()
{
  DeleteSeqPlayer();
	Delete3D();
	Delete2D();

	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
  // |PfXV
  m_poke_sys->UpdateSystem();
  m_poke_sys->UpdateModel();

  // V[PXvC[XV
  m_player->Update();

//	pG2dUtil->Update2D();
	pG3dUtil->Update3D();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
  gfl::grp::g3d::Scene *scene = pG3dUtil->GetScene();

  // |Pf`
  m_poke_sys->DrawRareEffectOff();
  scene->StereoEdgeMapDraw( pGraSystem, pG3dUtil->GetUpperCamera() );
  scene->StereoDraw( pGraSystem, pG3dUtil->GetUpperCamera() );
  scene->StereoPostEffectDraw( pGraSystem, pG3dUtil->GetUpperCamera() );
  m_poke_sys->DrawRareEffectOn();


//	pG2dUtil->Draw2D( pGraSystem, 0 );
	pG3dUtil->Draw3D( pGraSystem );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreateGraphicsSystem( app::util::Heap * heap )
{
	gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	pGraSystem = gm->GetGraphicsSystem();
	pGraSystem->InitializeApplicationMemory( heap->pDevHeapAllocator );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeleteGraphicsSystem(void)
{
	pGraSystem->FinalizeApplicationMemory();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create2D( app::util::Heap * heap )
{
	pG2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );
/*
	// \[Xf[^e[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[] =
	{
	};
	// CAEgf[^
	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
	};
*/
	pG2dUtil->CreateLayoutSystem( heap );
//	pG2dUtil->SetDefaultFont( const char * file );
	pG2dUtil->CreateLayoutEnv( heap );
//	pG2dUtil->CreateLayoutWork( GFL_NELEMS(layoutData), heap );
//	pG2dUtil->CreateLayoutResource( GFL_NELEMS(resTbl), heap );
//	pG2dUtil->LoadLayoutResource( 0, resTbl, GFL_NELEMS(resTbl), heap, true );
//	pG2dUtil->TransferLayoutTexture();
//	pG2dUtil->SetLayoutWork( layoutData, 0, GFL_NELEMS(layoutData) );
//	pG2dUtil->CreateMessageData( const wchar_t * arcFilePath, u32 datID, gfl::str::MsgData::LoadType loadType, Heap * heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete2D(void)
{
//	pG2dUtil->DeleteMessageData();
//	pG2dUtil->DeleteLayoutResource();
//	pG2dUtil->DeleteLayoutWork2();
	pG2dUtil->DeleteLayoutEnv();
	pG2dUtil->DeleteLayoutSystem();

	GFL_DELETE	pG2dUtil;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create3D( app::util::Heap * heap )
{
	pG3dUtil = GFL_NEW( heap->pHeap ) app::util::G3DUtil();

	pG3dUtil->CreateG3dSystem( heap );
	pG3dUtil->CreateG3dScene( app::util::G3DUtil::ENVIRONMENT_RES_NONE, 0, heap );

  // J
  const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
  {
    {
      gfl::math::VEC3( 0.0f, 0.0f, 800.0f ),  // Jʒu
      gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),   // _ʒu
      1.0f,
      1000.0f,
      gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
      0.0f,
      gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
      gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
      gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
    },
  };
	pG3dUtil->CreateG3dCamera( heap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL );

  // Cg̐
//	pG3dUtil->CreateG3dLight( gfl::fs::ArcFile::ARCID arcID, gfl::fs::ArcFile::ARCDATID datID, app::util::Heap * heap );


	pG3dUtil->CreateG3dModelWork( heap, TRADE_DEMO_MODEL_DATA_MAX );

/*
	const app::util::G3DUtil::ANIME_DATA anmData = {
	};
	gfl::fs::ArcFile * af = GFL_NEW(  heap->pHeap  ) gfl::fs::ArcFile(  heap->pHeap , ARCID_PMAV_GRA, gfl::fs::ArcFile::OPEN );
	pG3dUtil->AddG3dModel( af, GARC_pmav_gra_025_K_idleA_BCMDL, heap, app::util::G3DUtil::ADD_MODEL_ID_FREE, &anmData, 1 );
	GFL_DELETE af;
	pG3dUtil->ChangeG3dModelAnime( 0, 0, heap );
*/
	pG3dUtil->SetupG3dScene();

  pG3dUtil->CreateEdgeSystem( pGraSystem, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, heap );
  // |Pf`VXȅ
  m_poke_sys = GFL_NEW(heap->pHeap) poke_tool::PokeModelSystem();
  m_poke_sys->InitSystem( heap->pHeapAllocator,
                          heap->pDevHeapAllocator,
                          GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetFileReadManager());
  

}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete3D(void)
{
  // |PfVXȅI
  m_poke_sys->ExitSystem();
  GFL_DELETE(m_poke_sys);
  
/*
	for( int i=0; i<TRADE_DEMO_MODEL_DATA_MAX; i++ ){
		pG3dUtil->DelG3dModel( i );
	}
*/
  pG3dUtil->DeleteG3dModelWork();

  pG3dUtil->DeleteEdgeSystem();

//	pG3dUtil->DeleteG3dLight();
  pG3dUtil->DeleteG3dCamera();

  pG3dUtil->DeleteG3dScene();
	pG3dUtil->DeleteG3dSystem();

	GFL_DELETE	pG3dUtil;
}

//=============================================================================================
/**
 * @brief	V[PXvC[
 *
 * @param   heap  app::util::heap
 */
//=============================================================================================
void GraphicWork::CreateSeqPlayer( app::util::Heap * heap )
{
  // V[PXvC[̍쐬
  {
    // ʂ̃_[^[Qbg擾
    gfl::grp::FrameBufferManager* frameBufferManager = pGraSystem->GetFrameBufferManager( );
    gfl::grp::RenderTarget* renderTarget = frameBufferManager->GetRenderTarget(
                                           pGraSystem->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
    
    static xy_system::sequence::Param param = {
      heap->pHeap,
      heap->pHeapAllocator,
      heap->pDevHeapAllocator,
      pG3dUtil->GetScene(),
      pG3dUtil->GetUpperCamera(),
      renderTarget,   // ʃ_[^[Qbg
      m_poke_sys,     // Ƀ|PfVXe
      m_simple_poke,  // |PSimpleParam̔z
      m_pokecount,    // Simpleparam̐
      0,//f`
      0,//fvZ
      0,//|Pf`
      0,//|PfvZ
      0,//p[eBN`
      0,//p[eBNvZ
      0,//XN[p[eBN`
      0,//XN[p[eBNvZ
      
      NULL // app::util::G2dUtil*
    };
    
    m_player = GFL_NEW(heap->pHeap) xy_system::sequence::Player(&param);
    //m_player->LoadRequest(ARCID_DEMO_TEST, GARC_demo_test_test2_BSEQ);
    //m_player->LoadRequest(ARCID_DEMO_TEST, GARC_demo_test_test_poke_BSEQ);
    //m_player->LoadRequest(ARCID_DEMO_TEST, GARC_demo_test_test_particle_BSEQ);
    GFL_PRINT("fV[PXf[^ǂݍ start\n");
    m_player->LoadRequest(ARCID_DEMO_DATA, GARC_demo_data_trade_demo01_BSEQ );
    GFL_PRINT("fV[PXf[^ǂݍ end\n");
    
    // A񓯊ǂݍ݂ɑΉĂȂAIɂ͑Ή邱ƂɂȂ邾낤̂ŁA
    // {͓ǂݍ݊mFƍs悤ɂĂ
    if(m_player->IsReady())
    {
      // hogehoge
    }
    m_player->Play();
    
  }  
}


//=============================================================================================
/**
 * @brief	V[PXvC[
 *
 * @param   none		
 */
//=============================================================================================
void GraphicWork::DeleteSeqPlayer( void )
{
  m_player->UnLoad(true);
  GFL_DELETE(m_player);
}

//=============================================================================================
/**
 * @brief	V[PvC[p̃|P𐶐
 *
 * @param   index		
 * @param   core		
 *
 * @retval  int		
 */
//=============================================================================================
int GraphicWork::SetupSimpleParam( int index, pml::pokepara::CoreParam *core )
{
  if(core!=NULL){
    m_simple_poke[index].monsNo = core->GetMonsNo();
    m_simple_poke[index].formNo = core->GetFormNo();
    m_simple_poke[index].sex    = core->GetSex();
    m_simple_poke[index].isRare = core->IsRare();
    m_simple_poke[index].isEgg  = core->IsEgg(pml::pokepara::CHECK_BOTH_EGG);
    m_simple_poke[index].perRand = 0;
    return 1;
  }

  return 0;
}

}	// trade_demo
}	// app
