//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_NetworkParentView.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.07.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_NetworkParentView.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 * @param MailManager [}l[W[
 */
NetworkParentView::NetworkParentView( app::util::Heap * heap, gamesystem::GameManager *game_manager ) :
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_mail_list_view( NULL ),
  m_hologram_view( NULL ),
  m_listener( NULL )
{
  //OtBbNXVXe쐬
  this->CreateGraphicsSystem( heap );
  
  //CAEgVXe쐬
  m_g2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );
  m_g2dUtil->CreateLayoutSystem( heap );
  
  m_mail_list_view  = GFL_NEW( heap->GetSystemHeap() ) NetworkMailListView( heap, m_graphicSystem, this->GetLayoutSystem(), game_manager->GetGameData() );
  m_mail_list_view->Initialize();
  m_mail_list_view->SetListener( this );
  this->AddSubView( m_mail_list_view );
  
  //zOr[
  m_hologram_view = GFL_NEW( heap->GetSystemHeap() ) NetworkHologramView( heap, m_graphicSystem, this->GetLayoutSystem(), game_manager );
  m_hologram_view->SetListener( this );
  m_hologram_view->Initialize();
  this->AddSubView( m_hologram_view );

}
/**
 * @brief fXgN^
 */
NetworkParentView::~NetworkParentView()
{
  m_hologram_view->RemoveFromSuperView();
  
  m_hologram_view->Finalize();
  GFL_SAFE_DELETE( m_hologram_view );

  m_mail_list_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_mail_list_view );

  m_g2dUtil->DeleteLayoutSystem();
  GFL_SAFE_DELETE( m_g2dUtil );

  GFL_SAFE_DELETE( m_mail_list_view );
  this->DeleteGraphicsSystem();
}
//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief `
 */
void NetworkParentView::Draw( void )
{
}

/**
 * @brief Xi[o^
 *
 * @param listener  Xi[
 */
void NetworkParentView::SetListener( NetworkParentViewListener *listener )
{
  m_listener  = listener;
}

/**
 * @brief CuACR̕\
 *
 * @param is_visible  \
 */
void NetworkParentView::SetVisibleLiveIcon( bool is_visible )
{
  m_hologram_view->SetVisibleLiveIcon( is_visible );
}

/**
 * @brief ʍĐ
 */
void NetworkParentView::StartTalkCharacter( const NetworkHologramView::LoadDataParameters & param )
{
  m_hologram_view->Start( param );
}
  /**
   * @brief ʃXgɕ\̂ݒ肷A\z
   * @param cursor_pos  ʓɂ郊XgJ[\̈ʒuicursor_pos+list_posXg̃CfbNXɂȂ܂j
   * @param list_pos  Xg̈ʒuicursor_pos+list_posXg̃CfbNXɂȂ܂j
   * @param list_data Xgɕ\̂̃e[u
   * @param list_num  Le[u̗vf
   */
void NetworkParentView::SetupList( u16 cursor_pos, u16 list_pos, const NetworkMailListView::ListData * list_data, u32 list_num )
{
  m_mail_list_view->SetListData( list_data, list_num );
  m_mail_list_view->ReLoadList( cursor_pos, list_pos );
}
/**
 * @brief ʃXgx肷ƁA{֐Ă΂ȂƃX^[g܂
 */
void NetworkParentView::ReStartList( void )
{
  m_mail_list_view->ReturnMailList();
}

/**
 * @brief ʃXg̕\ݒ
 *
 * @param is_visible  true\  false\
 */
void NetworkParentView::SetVisibleList( bool is_visible )
{
  m_mail_list_view->SetVisibleList( is_visible );
}

/**
 * @brief ʃ^b`o[{^̕\ݒ
 *
 * @param is_visible  true\  false\
 */
void NetworkParentView::SetVisibleTouchbar( bool is_visible )
{
  m_mail_list_view->SetVisibleTouchbar( is_visible );
}

//-----------------------------------------------------------------------
// HologramViewListener̎
//-----------------------------------------------------------------------
void NetworkParentView::OnFinishLoadedBackGround(void)
{
}
void NetworkParentView::OnEndScript(void)
{
  if( m_listener )
  {
    m_listener->OnEndTalkCharacter();
  }
}
//-----------------------------------------------------------------------
// MailListViewListener̎
//-----------------------------------------------------------------------
void NetworkParentView::OnDecideMailList( u16 mail_index )
{
  if( m_listener )
  {
    m_listener->OnSelectedList( mail_index );
  }
}
void NetworkParentView::OnSelectedReturnButton( void )
{
#if PM_DEBUG
  if( m_hologram_view->IsDebugMode() )
  {
    return;
  }
#endif
  if( m_listener )
  {
    m_listener->OnSelectedReturnButton();
  }
}

void NetworkParentView::OnSelectedExitButton( void )
{
#if PM_DEBUG
  if( m_hologram_view->IsDebugMode() )
  {
    return;
  }
#endif
  if( m_listener )
  {
    m_listener->OnSelectedExitButton();
  }
}
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
