//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_NetworkMailListView.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.07.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_NetworkMailListView.h"
#include <arc/arc_def.h>
#include <arc/message.gaix>
#include <arc/hologram_mail_gra.gaix>
#include "../hologram_lower.h"
#include "../hologram_lower_pane.h"
#include "../app_hologrammail_common_define.h"
#include <message/msg_hologram_mail.h>
#include <common_res/msg_window_res.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param mail_manager  [}l[W[
 */
NetworkMailListView::NetworkMailListView( app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, const gamesystem::GameData *game_data ):
  MailListView( heap, graphics_system, layout_system, game_data )
{
}

/**
 * @brief fXgN^
 */
NetworkMailListView::~NetworkMailListView()
{
}

/**
* @brief 
*/
void NetworkMailListView::Initialize( void )
{
  this->MailListView::Initialize();
  this->SetVisibleList( true );
}


/**
 * @brief Xg\̂̐ݒ
 *
 * @param list_table  Xg\̂̃e[u  ŃRs[|C^ێ݂̂ł
 * @param list_num  e[u
 */
void NetworkMailListView::SetListData( const ListData * list_table, u32 list_num )
{
  m_list_table  = list_table;
  m_list_num    = list_num;
}
/**
 * @brief Xgēǂݍ
 *
 * @param cursor_pos  J[\ʒu
 * @param list_pos    Xgʒu
 */
void NetworkMailListView::ReLoadList( u16 cursor_pos, u16 list_pos )
{
  this->ReLoadPaneList( cursor_pos, list_pos, m_list_num );
}

/**
 * @brief Xg̕\
 *
 * @param is_visible  trueŕ\  falseŔ\
 */
void NetworkMailListView::SetVisibleList( bool is_visible )
{
  this->MailListView::SetVisibleList( is_visible );
}


/**
 * @brief ^b`o[{^̕\
 *
 * @param is_visible  trueŕ\  falseŔ\
 */
void NetworkMailListView::SetVisibleTouchbar( bool is_visible )
{
  if( is_visible )
  {
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_NORMAL );
  }
  else
  {
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_ALL_VANISH );
  }
}

//-----------------------------------------------------------------------
// MailListView̎
//-----------------------------------------------------------------------
/**
 * @brief ^b`o[쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 */
void NetworkMailListView::CreateTouchbar( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system )
{
  m_touchbar_view = GFL_NEW(heap->GetSystemHeap()) TouchbarView( heap, m_graphicSystem, layout_system, this->GetLayoutWork(0), TouchbarView::MODE_NETWORK );
  m_touchbar_view->SetListener( this );
  this->AddSubView( m_touchbar_view );
}

/**
 * @brief XgI
 *
 * @param pos Iʒu
 */
void NetworkMailListView::SelectedList( u32 item_pos )
{
  if( m_listener )
  {
    m_listener->OnDecideMailList( item_pos );
  }
}

//-----------------------------------------------------------------------
// IListDataOwner
//-----------------------------------------------------------------------
/**
 * @brief VKtO擾 
 *
 * @param index XgCfbNX
 *
 * @return  VKtO
 */
bool NetworkMailListView::GetListDataNewFlag( u32 index )
{
  GFL_ASSERT( index < m_list_num );
  return m_list_table[ index ].is_new;
}
/**
 * @brief Xg\擾
 *
 * @param index XgCfbNX
 * @param strbuf  Xg\擾
 */
void NetworkMailListView::GetListDataString( u32 index, gfl::str::StrBuf * strbuf )
{
  GFL_ASSERT( index < m_list_num );
  strbuf->SetStr( *m_list_table[ index ].string );
}
/**
 * @brief Xg擾
 *
 * @return  Xg
 */
u32 NetworkMailListView::GetListDataMax( void ) const
{
  return m_list_num;
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
