//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_NetworkNetworkHologramView.cpp
 *	@brief  zO  lbg[N[h
 *	@author	Toru=Nagihashi
 *	@date		2012.07.25
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "arc/arc_def.h"
#include <arc/message.gaix>
#include <arc/hologram_mail_gra.gaix>
#include "app_hologrammail_NetworkHologramView.h"
#include "../app_hologrammail_BackGround.h"
#include "../app_hologrammail_PersonManager.h"
#include "../hologram_upper.h"
#include "../hologram_upper_pane.h"
#include <sound/sound.h>
#include <debug/debug_ui.h>
#include "app_hologrammail_CameraBackGround.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
static const PersonType NETWORK_PERSON  = PERSON_TYPE_SUPPORT;//@todo
  
//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param game_manager  Q[}l[W[
 */
NetworkHologramView::NetworkHologramView(app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, gamesystem::GameManager *game_manager ) :
  HologramView( heap, graphics_system, layout_system, game_manager ),
  m_camera_backgound( NULL ),
  m_sequence( &NetworkHologramView::Sequence_Idle ),
  m_sub_sequence(0)
{
  m_arc_file  = GFL_NEW(heap->GetSystemHeap()) gfl::fs::ArcFile( heap->GetSystemHeap(), ARCID_HOLOGRAM_MAIL_GRA, gfl::fs::ArcFile::OPEN );
  
  u32 pokecen_size = m_arc_file->GetDataSize( GARC_hologram_mail_gra_pokecen_JPG );
  u32 pgl_size = m_arc_file->GetDataSize( GARC_hologram_mail_gra_pgl_JPG );
  u32 buffer_size = gfl::math::Max( pokecen_size, pgl_size );
  m_preset_board_data = GflHeapAllocMemoryAlign( heap->GetDeviceHeap(), buffer_size, 4 );
}

/**
 * @brief fXgN^
 */
NetworkHologramView::~NetworkHologramView()
{
  GflHeapFreeMemory( m_preset_board_data );
  GFL_SAFE_DELETE( m_arc_file );
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void NetworkHologramView::Update(void)
{
  (this->*m_sequence)();
  this->HologramView::Update();
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief Jn  i[hAbn߂j
 *
 * @param param Jnf[^
 */
void NetworkHologramView::Start( const LoadDataParameters & param )
{
  m_parameters  = param;
  m_sequence  = &NetworkHologramView::Sequence_Loading;
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief RDwi쐬
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 */
void NetworkHologramView::CreateBackGround( app::util::Heap * heap, gamesystem::GameManager *game_manager )
{
  m_camera_backgound = GFL_NEW(heap->GetSystemHeap()) CameraBackGround( heap, game_manager, m_graphicSystem );
  m_background  = m_camera_backgound;
}
/**
 * @brief RDwij
 */
void NetworkHologramView::DeleteBackGround(void)
{
  GFL_SAFE_DELETE( m_camera_backgound );
  m_background = NULL;
}
/**
 * @brief V[PX  ҋ@
 */
void NetworkHologramView::Sequence_Idle( void )
{
  //Ȃ
}
/**
 * @brief V[PX  ǂݍ
 */
void NetworkHologramView::Sequence_Loading( void )
{
  switch( m_sub_sequence )
  {
  case 0:
    if( m_parameters.back_board_type == BACK_BOARD_TYPE_PRESET_PGL )
    {
      m_preset_board_size = m_arc_file->LoadData(GARC_hologram_mail_gra_pgl_JPG , m_preset_board_data );
      m_parameters.board_jpeg_data  = m_preset_board_data;
      m_parameters.board_jpeg_size  = m_preset_board_size;
    }
    else if( m_parameters.back_board_type == BACK_BOARD_TYPE_PRESET_DELIVERY )
    {
      m_preset_board_size = m_arc_file->LoadData(GARC_hologram_mail_gra_pokecen_JPG , m_preset_board_data );
      m_parameters.board_jpeg_data  = m_preset_board_data;
      m_parameters.board_jpeg_size  = m_preset_board_size;
    }
    ++m_sub_sequence;
    // fall
  case 1:
    //wiǂݍ݊Jn
    m_camera_backgound->SetLoadData( m_parameters.board_jpeg_data, m_parameters.board_jpeg_size );
    m_background->StartLoad();
    
    //lǂݍ݊Jn
    {
      PersonManager::Description desc;
      
      desc.type = NETWORK_PERSON;
      desc.position = gfl::math::VEC3( NETWORK_MODEL_POSITION_01_01_X, 0, NETWORK_MODEL_POSITION_01_01_Z );
      desc.rotate = gfl::math::VEC3( 0, NETWORK_MODEL_ROTATE_01_01_Y, 0 );
      m_person_manager->StartLoad( &desc, 1 );
    }
    ++m_sub_sequence;
    // fall
  case 2:
    if( m_background->IsFinishLoad()
      && m_person_manager->IsFinishLoad() )
    {
      m_listener->OnFinishLoadedBackGround();
      m_listener->OnFinishSetupScript();

      ++m_sub_sequence;
    }
    break;
  case 3:
    m_sub_sequence  = 0;
    m_sequence  = &NetworkHologramView::Sequence_MoveModel;
    break;
  }
}
/**
 * @brief V[PX  
 */
void NetworkHologramView::Sequence_MoveModel( void )
{
  switch( m_sub_sequence )
  {
  case 0:
    m_camera_backgound->StartAnimation( CameraBackGround::ANIME_ID_BOARD_IN );
    ++m_sub_sequence;
    //fall
  case 1:
    if( this->ScriptCommandEnter( NETWORK_PERSON, PERSON_TYPE_NONE, PERSON_TYPE_NONE, PERSON_TYPE_NONE ) )
    {
      ++m_sub_sequence;
    }
    break;
  case 2:
    if( this->ScriptCommandWait( 30 ) )
    {
      ++m_sub_sequence;
    }
    break;
  case 3:
    if( this->StartMessage( NETWORK_PERSON, m_parameters.message, COMMAND_PARAM_TALKDIR_FRONT ) )
    {
      ++m_sub_sequence;
    }
    break;
  case 4:
    if( this->ScriptCommandWaitMessage( NETWORK_PERSON ) )
    {
      ++m_sub_sequence;
    }
    break;
  case 5:
    if( this->ScriptCommandWait( 30 ) )
    {
      ++m_sub_sequence;
    }
    break;
  case 6:
    m_camera_backgound->StartAnimation( CameraBackGround::ANIME_ID_BOARD_OUT );
    ++m_sub_sequence;
    //fall
  case 7:
    if( this->ScriptCommandExit( NETWORK_PERSON, PERSON_TYPE_NONE, PERSON_TYPE_NONE, PERSON_TYPE_NONE ) )
    {
      ++m_sub_sequence;
    }
    break;
  default:
    GFL_ASSERT(0);
  case 8:
    m_sub_sequence  = 0;
    m_person_manager->Delete();
    m_listener->OnEndScript();
    m_sequence  = &NetworkHologramView::Sequence_Idle;
    break;
  }
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
