//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_CameraBackGround.cpp
 *	@brief  Jwi
 *	@author	Toru=Nagihashi
 *	@date		2012.07.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "app_hologrammail_CameraBackGround.h"
#include "../camera_background.h"
#include "../camera_background_pane.h"
#include <arc/hologram_mail_gra.gaix>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 * @param graphics_system OtBbNXVXe
 * @param g3dutil RDǗ
 */
CameraBackGround::CameraBackGround(app::util::Heap *heap, gamesystem::GameManager *game_manager, gfl::grp::GraphicsSystem* graphics_system ) :
  m_graphics_system(graphics_system),
  m_heap(heap),
  m_board_jpeg_data( NULL ),
  m_board_jpeg_size( 0 ),
  m_decode_thread(NULL),
  m_is_loading( false )
{
  this->InitializeCamera();
  this->Initialize2D();
  this->InitializeDecoder();
}
/**
 * @brief fXgN^
 */
CameraBackGround::~CameraBackGround()
{
  this->FinalizeDecoder();
  this->Finalize2D();
  this->FinalizeCamera();
}
//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void CameraBackGround::Update( void )
{
  if( m_is_loading )
  {
    if( m_decode_thread == NULL 
        || m_decode_thread->IsAlive() == false )
    {
      if( m_decode_thread )
      {
        GFL_PRINT( "fR[h\n" );
        GFL_PRINT( "result %d\n", m_decode_thread->GetResultSize() );
        GFL_PRINT( "error  %d\n", m_jpeg_decoder->GetLastError() );
      }
      GFL_SAFE_DELETE( m_decode_thread );
      m_is_loading  = false;
    }
  }

  m_LytWk->Update();

  gfl::std::MemCopy( m_cameraController->GetImage(), m_CaptureImage, m_CaptureImageSize );
}
/**
 * @brief `
 */
void CameraBackGround::Draw( void )
{
  this->DrawLyt();
}
//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief ǂݍ݊Jn
 */
void CameraBackGround::StartLoad( void )
{
  
  if( m_board_jpeg_data != NULL && m_board_jpeg_size != 0 )
  {
    gfl::grp::g2d::LytPane* pane = m_LytWk->GetPane( PANENAME_CAMERA_PANE_PICTURE );
    
    GFL_PRINT( "fR[hJn\n" );
    GFL_PRINT( "w %f\n", pane->GetSize().width );
    GFL_PRINT( "h %f\n", pane->GetSize().height );
    
    //m_jpeg_decoder->SetOption( nn::jpeg::CTR::JPEG_DECODER_OPTION_MATCH_WIDTH_HEIGHT );

    GFL_ASSERT( m_decode_thread == NULL );
    m_decode_thread = GFL_NEW( m_heap->GetSystemHeap()) JpegDecodeThread( m_heap->GetSystemHeap(), m_jpeg_decoder );

    m_decode_thread->SetDecoderParameters( m_BoardImage, m_BoardImageSize, reinterpret_cast<const u8*>(m_board_jpeg_data), m_board_jpeg_size, pane->GetSize().width, pane->GetSize().height, nn::jpeg::CTR::PIXEL_FORMAT_CTR_RGBA8_BLOCK8, false );
    
    m_decode_thread->Start( gfl::base::Thread::LowestPriority );
    
    m_is_loading  = true;
  }
}
/*r
 * @brief ǂݍݒǂ
 *
 * @return trueǂݍݏI falseǂݍݒ
 */
bool CameraBackGround::IsFinishLoad( void ) const
{
  
  return !m_is_loading;
}


/**
 * @brief ǂݍJPGݒ
 *
 * @param board_jpeg_data JPGf[^|C^
 * @param board_jpeg_size JPGTCY
 */
void CameraBackGround::SetLoadData( const void *board_jpeg_data, u32 board_jpeg_size )
{
  m_board_jpeg_data = board_jpeg_data;
  m_board_jpeg_size = board_jpeg_size;
}


/**
 * @brief AjJn
 *
 * @param anime_id  AjID
 */
void CameraBackGround::StartAnimation( AnimeID anime_id )
{
  u32 animation_index = anime_id;
  
  if( m_LytWk->IsBindAnime( animation_index ) ) {
    m_LytWk->UnBindAnime( animation_index );
  }
  
  if( m_LytWk->IsBindAnime( animation_index ) == false ) {
    m_LytWk->BindAnime( animation_index );
  }
  m_LytWk->SetAutoAnime( animation_index, true );
  m_LytWk->SetAnimeFrame( animation_index, 0 );
  
  gfl::grp::g2d::LytPane* pane = m_LytWk->GetPane( PANENAME_CAMERA_PANE_PICTURE );
  pane->SetVisible( true );
}

/**
 * @brief AjI҂
 *
 * @return  trueAj  falseAj
 */
bool CameraBackGround::IsEndAnimation( AnimeID anime_id ) const
{
  u32 animation_index = anime_id;
  return !(
      m_LytWk->IsAnime( animation_index ) &&
      m_LytWk->IsBindAnime( animation_index ) &&
      !m_LytWk->IsAnimeEnd( animation_index ) );
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief J̏
 */
void CameraBackGround::InitializeCamera( void )
{
  GFL_ASSERT( m_cameraSystem == NULL );
  
  // JVXẽZbgAbvp[^쐬
  gfl::device::camera::System::SetupParam setup_param; 
  setup_param = gfl::device::camera::DefaultSettings_Stereo; // ftHgp[^gp
  setup_param.pHeap = m_heap->GetSystemHeap();;
  setup_param.pDeviceHeap = m_heap->GetDeviceHeap();

  // JVXe𐶐 / JANZbT擾
  m_cameraSystem = GFL_NEW( m_heap->GetSystemHeap() ) gfl::device::camera::System( setup_param ); 
  m_cameraController = m_cameraSystem->GetCameraController( gfl::device::camera::CAMERA_1 );

  // JN / Lv`Jn
  m_cameraController->Activate();
  m_cameraController->StartCapture(); 
}

/**
 * @brief J̔j
 */
void CameraBackGround::FinalizeCamera( void )
{
  // JVXej
  GFL_DELETE m_cameraSystem; 
}

/**
 * @brief 2D ̏
 */
void CameraBackGround::Initialize2D( void )
{
  // CAEgVXe
  {
    static const gfl::grp::g2d::LytSysSetUp SetUp = {
      10, // lyt_resource_max
      1  // lyt_wk_max
    };

    m_LytSys = GFL_NEW(m_heap->GetSystemHeap()) gfl::grp::g2d::LytSys(&SetUp, m_heap->GetSystemAllocator(), m_heap->GetDeviceAllocator());

    // \[Xǂݍ
    gfl::fs::ArcFile* arc = GFL_NEW(m_heap->GetSystemHeap()) gfl::fs::ArcFile( m_heap->GetSystemHeap(), ARCID_HOLOGRAM_MAIL_GRA, gfl::fs::ArcFile::OPEN );
    m_ResID = m_LytSys->LoadLytResComp( m_heap->GetDeviceAllocator(), arc, GARC_hologram_mail_gra_camera_background_LYTDAT_LZ );
    GFL_DELETE arc;

    // VRAMɃeNX`]B
    m_LytSys->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

    // CAEg[N
    
    static const gfl::grp::g2d::LytWkSetUp s_LytWkSetUp[] = 
    {
      {
        gfl::math::VEC3(0,0,0),   // pos
        gfl::math::VEC2(1,1),     // scale
        gfl::math::VEC3(0,0,0),   // rotate
        1,                        // priority
      }, 
    };

    static const gfl::grp::g2d::LytArcIndex s_animeData[]  =
    {
      LYTRES_CAMERA_BACKGROUND_CAMERA_BOARD_IN_BCLAN,
      LYTRES_CAMERA_BACKGROUND_CAMERA_BOARD_OUT_BCLAN,
    };

    m_LytWk  = m_LytSys->CreateLytWk( m_ResID, LYTRES_CAMERA_BACKGROUND_CAMERA_BCLYT, s_animeData, GFL_NELEMS(s_animeData), GFL_NELEMS(s_animeData), s_LytWkSetUp ); // &gfl::grp::g2d::c_LytWkUpperDefaultSetUp );
  }

  m_LytWk->SetAutoDrawFlag( false );

  //wiJp
  {
    // Lv`摜̃obt@쐬
    m_CaptureImageSize = m_cameraController->GetImageSize();
    m_CaptureImage = GflHeapAllocMemoryAlign( m_heap->GetDeviceHeap(), m_CaptureImageSize, 64 ); 

    // eNX`̕AhXύX
    {
      gfl::grp::g2d::LytPaneIndex pane_idx =PANENAME_CAMERA_PANE_CAPTURE;
      gfl::grp::g2d::LytMaterial* material = m_LytWk->GetMaterial( pane_idx );
      if( material ) {
        const nw::lyt::TexMap& tex_map = material->GetTexMap(0);
        uptr addr = nngxGetPhysicalAddr( reinterpret_cast<uptr>(m_CaptureImage ) );
        const_cast<nw::lyt::TexMap*>(&tex_map)->SetPhysicalAddress( addr );
      }
    }

    gfl::std::MemFill( m_CaptureImage, m_CaptureImageSize, 0 );
#if 0
    u32 pos=0;
    for( u32 x=0; x<8; x++ ) {
      for( u32 y=0; y<8; y++ ) {
        u8* p = (u8*)( m_CaptureImage );
        p[pos++] = 0;
        p[pos++] = 0;
        p[pos++] = 0xff;
      }
    }
    for( u32 x=0; x<8; x++ ) {
      for( u32 y=0; y<8; y++ ) {
        u8* p = (u8*)( m_CaptureImage );
        p[pos++] = 0;
        p[pos++] = 0xff;
        p[pos++] = 0;
      }
    }
    for( u32 x=0; x<8; x++ ) {
      for( u32 y=0; y<8; y++ ) {
        u8* p = (u8*)( m_CaptureImage );
        p[pos++] = 0xff;
        p[pos++] = 0;
        p[pos++] = 0;
      }
    }

    pos = 8*8*3*64;
    for( u32 x=0; x<8; x++ ) {
      for( u32 y=0; y<8; y++ ) {
        u8* p = (u8*)( m_CaptureImage );
        p[pos++] = 0xff;
        p[pos++] = 0xff;
        p[pos++] = 0xff;
      }
    }
#endif
  }
  //ŔJpgp
  { 
    gfl::grp::g2d::LytPane* pane = m_LytWk->GetPane( PANENAME_CAMERA_PANE_PICTURE );
    m_BoardImageSize  = nn::jpeg::CTR::JpegMpDecoder::GetDstBufferSize( pane->GetSize().width, pane->GetSize().height, nn::jpeg::CTR::PIXEL_FORMAT_CTR_RGBA8_BLOCK8 );
    m_BoardImage  = GflHeapAllocMemoryAlign( m_heap->GetDeviceHeap(), m_BoardImageSize, 128 ); 

    
    pane->SetVisible( false );

    // eNX`̕AhXύX
    {
      gfl::grp::g2d::LytMaterial* material = m_LytWk->GetMaterial( PANENAME_CAMERA_PANE_PICTURE );
      if( material ) {
        const nw::lyt::TexMap& tex_map = material->GetTexMap(0);
        
        GFL_PRINT("eNX`TCYW%d\n",tex_map.GetWidth() );
        GFL_PRINT("eNX`TCYH%d\n",tex_map.GetHeight() );
        GFL_PRINT("eNX`TCYRW%d\n",tex_map.GetRealWidth() );
        GFL_PRINT("eNX`TCYRH%d\n",tex_map.GetRealHeight() );
        GFL_PRINT("tH[}bg%d\n",tex_map.GetFormat() );

        uptr addr = nngxGetPhysicalAddr( reinterpret_cast<uptr>(m_BoardImage ) );
        const_cast<nw::lyt::TexMap*>(&tex_map)->SetPhysicalAddress( addr );
      }
    }
    gfl::std::MemFill( m_BoardImage, m_BoardImageSize, 0 );
  }
}

/**
 * @brief 2D̔j
 */
void CameraBackGround::Finalize2D( void )
{
  m_LytSys->RemoveLytWk( m_LytWk );
  m_LytSys->ReleaseLytRes( m_ResID );

  GFL_DELETE m_LytSys; 

  GflHeapFreeMemory( m_CaptureImage );
    

  GflHeapFreeMemory( m_BoardImage );
}

/**
 * @brief CAEg`
 */
void CameraBackGround::DrawLyt( void )
{
  // _O^[Qbg̎擾
  gfl::grp::RenderTarget* upperFrameBuffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
  gfl::grp::RenderTarget* rightFrameBuffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
  gfl::grp::RenderTarget* lowerFrameBuffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);
  

  m_LytWk->Draw( m_graphics_system, gfl::grp::DISPLAY_UPPER, upperFrameBuffer );
  m_LytWk->Draw( m_graphics_system, gfl::grp::DISPLAY_UPPER_RIGHT, rightFrameBuffer ); 
}

/**
 * @brief GR[_[
 */
void CameraBackGround::InitializeDecoder( void )
{
  m_jpeg_decoder  = GFL_NEW(m_heap->GetSystemHeap()) nn::jpeg::CTR::JpegMpDecoder();
  size_t  work_buffer_size  = nn::jpeg::CTR::JpegMpDecoder::GetWorkBufferSize();
  m_decode_work_buffer  = GflHeapAllocMemoryAlign( m_heap->GetDeviceHeap(), work_buffer_size, 128 ); 

  m_jpeg_decoder->Initialize( m_decode_work_buffer, work_buffer_size );
  
}
/**
 * @brief GR[_[j
 */
void CameraBackGround::FinalizeDecoder( void )
{
  m_jpeg_decoder->Finalize();
  GflHeapFreeMemory(m_decode_work_buffer );
  GFL_SAFE_DELETE(m_jpeg_decoder);
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
