//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		debug_app_hologrammail_NetworkViewTestProc.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.08.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#if PM_DEBUG

#include <Gamesystem/GameProcManager.h>
#include <app/hologram_mail/DebugNetworkViewTestProc.h>
#include "app_hologrammail_NetworkParentView.h"
#include <app/util/app_util_Common.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *	@param  param 
 */
DebugNetworkViewTestProc::DebugNetworkViewTestProc( PARAM *param ) :
  gamesystem::GameProc(),
  app::util::Heap(),
  m_param( param ),
  m_parent_view( NULL ),
  m_sequence( SEQUENCE_START )
{
  //q[v쐬
  this->Create( HEAPID_HOLOGRAMMAIL_SYSTEM, SYSTEM_HEAP_SIZE, HEAPID_HOLOGRAMMAIL_DEVICE, DEVICE_HEAP_SIZE );

}

/**
 *	@brief  fXgN^
 */
DebugNetworkViewTestProc::~DebugNetworkViewTestProc()
{
  //q[vj
  this->Delete();
}


//-----------------------------------------------------------------------
// GameProcI[o[Cg
//-----------------------------------------------------------------------
/**
 *	@brief  PROC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result DebugNetworkViewTestProc::InitFunc(gfl::proc::Manager * )
{
 
  //쐬
  m_parent_view = GFL_NEW( this->GetSystemHeap() ) NetworkParentView( this, mpGameProcManager->GetGameManager() );
  
  //Xi̓o^
  m_parent_view->SetListener( this );
  
  //̂ɂāuLIVEv\肷H
  m_parent_view->SetVisibleLiveIcon( true );
  
  //ʃXg̃f[^
  this->CreateListData();

  //ʃXg̐ݒs
  m_parent_view->SetupList( 0, 0, m_list_data, m_list_data_num );
  
  //ʂɕ\镶쐬Ă
  m_talk_message  = GFL_NEW(this->GetSystemHeap()) gfl::str::StrBuf( L"̂悤Ɂ@Ђ傤܂\r", this->GetSystemHeap() );

  return gfl::proc::RES_FINISH;
}

/**
 *	@brief  PROCj
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result DebugNetworkViewTestProc::EndFunc(gfl::proc::Manager * )
{
  GFL_SAFE_DELETE( m_talk_message );

  this->DeleteListData();

  GFL_SAFE_DELETE( m_parent_view );
  return gfl::proc::RES_FINISH;
}

/**
 *	@brief  PROCC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result DebugNetworkViewTestProc::UpdateFunc(gfl::proc::Manager * )
{
  m_parent_view->UpdateTree();

  if( this->UpdateSequence() )
  {
    return gfl::proc::RES_FINISH;
  }
  return gfl::proc::RES_CONTINUE;
}

/**
 *	@brief  PROC`
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
void DebugNetworkViewTestProc::DrawFunc(gfl::proc::Manager * )
{
  m_parent_view->DrawTree();
}

//-----------------------------------------------------------------------
// ParentViewListener̎
//-----------------------------------------------------------------------
/**
 * @brief Xg莞ɌĂ΂
 *        Xg͒~[hɈڍsA
 *        NetworkParentView::RestartListĂ΂ȂƍĊJȂB
 *
 * @param list_index  Xg̃CfbNX
 */
void DebugNetworkViewTestProc::OnSelectedList( u16 list_index )
{
  //XgAʂɕ\be
  NetworkHologramView::LoadDataParameters param =
  {
    m_talk_message,//const gfl::str::StrBuf *message;  ///<be
    NetworkHologramView::BACK_BOARD_TYPE_PRESET_PGL,//BackBoardType back_board_type;    ///<wi̎
    NULL,//const void *board_jpeg_data;      ///<wiJPEGf[^iBACK_BOARD_TYPE_DATÂ݁j
    0,//u32 board_jpeg_size;              ///<wiJPEGTCYiBACK_BOARD_TYPE_DATÂ݁j
  };

  m_parent_view->StartTalkCharacter( param );
  
  //b̓Xg\
  m_parent_view->SetVisibleList( false );
  
  //b̓^b`o[\
  m_parent_view->SetVisibleTouchbar( false );
}
/**
 * @brief ʂ̘bA̗ꂪIɌĂ΂
 *        bA̗NetworkParentView::StartTalkCharacterԂƂŊJn
 */
void DebugNetworkViewTestProc::OnEndTalkCharacter( void )
{
  //XgăX^[g
  m_parent_view->ReStartList();
  
  //\ɂĂ̂Ƃɖ߂
  m_parent_view->SetVisibleList( true );
  m_parent_view->SetVisibleTouchbar( true );
}

/**
 * @brief Exit{^ꂽɌĂ΂
 */
void DebugNetworkViewTestProc::OnSelectedExitButton( void )
{
  m_sequence  = SEQUENCE_FADEOUT_START;
}
/**
 * @brief Return{^ꂽɌĂ΂
 */
void DebugNetworkViewTestProc::OnSelectedReturnButton( void )
{
  m_sequence  = SEQUENCE_FADEOUT_START;
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief V[PXXV
 */
bool DebugNetworkViewTestProc::UpdateSequence( void )
{
  switch( m_sequence )
  {
  case SEQUENCE_START:
    // fall
  
  case SEQUENCE_LOAD:
    m_sequence = SEQUENCE_FADEIN_START;
    break;
  case SEQUENCE_FADEIN_START:
    {
      gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
      gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
      gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, app::util::DEFAULT_FADE_SYNC );
      
      m_sequence = SEQUENCE_FADEIN_WAIT;
    }
    break;
  case SEQUENCE_FADEIN_WAIT:
    if( gfl::grp::Fade_IsEnd() )
    {
      m_sequence  = SEQUENCE_MAIN;
    }
    break;
  case SEQUENCE_MAIN:
    
    //Xi[ɂďԑJڂ
    break;
  case SEQUENCE_FADEOUT_START:
    gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, app::util::DEFAULT_FADE_SYNC );
    m_sequence  = SEQUENCE_FADEOUT_WAIT;
    break;
  case SEQUENCE_FADEOUT_WAIT:
    if( gfl::grp::Fade_IsEnd() )
    {
      m_sequence  = SEQUENCE_END;
    }
    break;
  case SEQUENCE_END:
    return true;
  default:
    GFL_ASSERT(0);
  }
  
  return false;
}


/**
 * @brief Xgf[^
 */
void DebugNetworkViewTestProc::CreateListData( void )
{
  m_list_data_num = 10;
  m_list_data = GFL_NEW_ARRAY( this->GetSystemHeap() ) NetworkMailListView::ListData[m_list_data_num];
  

  //ȉʃXgɕ\̂̐
  //͍̑sVłcB
  for( int i=0; i<m_list_data_num; ++i )
  {
    m_list_data[i].is_new = i%2; // XǵɁuNEWvƕ\邩ǂ
    
    gfl::str::STRCODE name[128];
    nn::nstd::TSPrintf( name, L"[%d", i );
    m_list_data[i].string = GFL_NEW(this->GetSystemHeap()) gfl::str::StrBuf( name, this->GetSystemHeap() ); // Xgɕ\镶
  }
}
/**
 * @brief Xgf[^j
 */
void DebugNetworkViewTestProc::DeleteListData( void )
{
  for( int i=0; i<m_list_data_num;++i )
  {
    GFL_SAFE_DELETE( m_list_data[i].string );
  }

  GFL_DELETE_ARRAY m_list_data;
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

#endif //PM_DEBUG
