//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_Proc.cpp
 *	@brief  zO[vZX
 *	@author	Toru=Nagihashi
 *	@date		2012.05.22
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <gamesystem/GameProcManager.h>
#include <app/hologram_mail/app_hologrammail_Proc.h>
#include "app_hologrammail_ParentView.h"
#include "../app_hologrammail_MailManager.h"
#include <app/util/app_util_Common.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
/**
 * 
 *  @note [hʏ
 *  
 *  MODE_PLAY_MAIL
 *      PDtF[hBG̓ǂݍ݂ƃXNvgilj̓ǂݍݗ
 *      QDXNvg̊Jn̓tF[hI㎩Jn
 *      RDI̓XNvgNA莞ԑ҂ƎI
 *
 *
 *
 *  MODE_USE_ITEM
 *      PDtF[hBG̓ǂݍ݂܂
 *      QDXNvg̊Jn̓[U[Xg^b`
 *      RDÍ~߂Ƃ̎蓮I
 *
 *
 *
 */

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *	@param  param 
 */
Proc::Proc( PARAM *param ) :
  gamesystem::GameProc(),
  app::util::Heap(),
  m_param( param ),
  m_parent_view( NULL ),
  m_mail_manager( NULL ),
  m_sequence( SEQUENCE_START ),
  m_is_finish_bg_load( false ),
  m_is_finish_script_load( false ),
  m_counter( 0 )
{
  //q[v쐬
  this->Create( HEAPID_HOLOGRAMMAIL_SYSTEM, SYSTEM_HEAP_SIZE, HEAPID_HOLOGRAMMAIL_DEVICE, DEVICE_HEAP_SIZE );

}

/**
 *	@brief  fXgN^
 */
Proc::~Proc()
{
  //q[vj
  this->Delete();
}


//-----------------------------------------------------------------------
// GameProcI[o[Cg
//-----------------------------------------------------------------------
/**
 *	@brief  PROC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::InitFunc(gfl::proc::Manager * )
{
  LocalMail::Boot( this->GetSystemHeap() );

  //[}l[W[ //@todolbg[N[h
  savedata::HologramMailData* save  = mpGameProcManager->GetGameManager()->GetGameData()->GetHologramMailData();
  m_mail_manager  = GFL_NEW( this->GetSystemHeap() ) MailManager( MailManager::MODE_SENARIO, save, this->GetSystemHeap() );
  
  //r[쐬
  ParentView::Mode mode;
  if( m_param->mode == MODE_PLAY_MAIL )
  {
    mode = ParentView::MODE_NONE;
  }
  else
  {
    mode = ParentView::MODE_MAIL_LIST;
  }
  m_parent_view = GFL_NEW( this->GetSystemHeap() ) ParentView( mode, this, mpGameProcManager->GetGameManager(), m_mail_manager );
  m_parent_view->SetListener( this );
  if( m_param->mode == MODE_PLAY_MAIL )
  {
    //[擾
    LocalMail local_mail( m_param->mail_no );
    m_parent_view->LoadScript( local_mail.GetScriptId() );
  }

  return gfl::proc::RES_FINISH;
}

/**
 *	@brief  PROCj
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::EndFunc(gfl::proc::Manager * )
{
  GFL_SAFE_DELETE( m_parent_view );

  GFL_SAFE_DELETE( m_mail_manager );

  LocalMail::Terminate();
  return gfl::proc::RES_FINISH;
}

/**
 *	@brief  PROCC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::UpdateFunc(gfl::proc::Manager * )
{
  m_parent_view->UpdateTree();

  if( this->UpdateSequence() )
  {
    return gfl::proc::RES_FINISH;
  }
  return gfl::proc::RES_CONTINUE;
}

/**
 *	@brief  PROC`
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
void Proc::DrawFunc(gfl::proc::Manager * )
{
  m_parent_view->DrawTree();
}

//-----------------------------------------------------------------------
// ParentViewListener̎
//-----------------------------------------------------------------------
void Proc::OnFinishLoadedBackGround( void )
{
  GFL_PRINT( "OnFinishLoadedBackGround\n" );
  m_is_finish_bg_load  = true;
}
void Proc::OnFinishSetupScript( void )
{
  GFL_PRINT( "OnFinishSetupScript\n" );
  m_is_finish_script_load = true;
  
  if( m_param->mode == MODE_USE_ITEM )
  {
    m_parent_view->StartScript();
  }
}
void Proc::OnSelectedExitButton( void )
{
  m_sequence  = SEQUENCE_FADEOUT_START;
  m_param->result = RESULT_EXIT;
}
void Proc::OnSelectedReturnButton( void )
{
  m_sequence  = SEQUENCE_FADEOUT_START;
  m_param->result = RESULT_RETURN;
}
void Proc::OnEndScript( void )
{
  GFL_PRINT( "OnEndScript\n" );
  
  if( m_param->mode == MODE_PLAY_MAIL )
  {
    m_sequence  = SEQUENCE_WAIT;

    //[ɒǉ
    savedata::HologramMailData* save  = mpGameProcManager->GetGameManager()->GetGameData()->GetHologramMailData();
    save->AddLocalMailData( m_param->mail_no );
    
  }
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief V[PXXV
 */
bool Proc::UpdateSequence( void )
{
  switch( m_sequence )
  {
  case SEQUENCE_START:
    // fall
  
  case SEQUENCE_LOAD:
    {
      bool is_finish_load;
      
      if( m_param->mode == MODE_PLAY_MAIL )
      {
        is_finish_load  = m_is_finish_bg_load && m_is_finish_script_load;
      }
      else
      {
        is_finish_load  = m_is_finish_bg_load;
      }
      if( is_finish_load )
      {
        m_sequence = SEQUENCE_FADEIN_START;
      }
    } 
    break;
  case SEQUENCE_FADEIN_START:
    {
      gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
      gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
      gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, app::util::DEFAULT_FADE_SYNC );
      m_sequence = SEQUENCE_FADEIN_WAIT;
    }
    break;
  case SEQUENCE_FADEIN_WAIT:
    if( gfl::grp::Fade_IsEnd() )
    {
      m_sequence  = SEQUENCE_MAIN;
      
      if( m_param->mode == MODE_PLAY_MAIL )
      {
        m_parent_view->StartScript();
      }
    }
    break;
  case SEQUENCE_MAIN:
    
    //Xi[ɂďԑJڂ


    break;
    
  case SEQUENCE_WAIT:
    if( m_counter++ > 30 )
    {
      m_counter = 0;
      m_sequence  = SEQUENCE_FADEOUT_START;
    }
    break;

  case SEQUENCE_FADEOUT_START:
    gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, app::util::DEFAULT_FADE_SYNC );
    m_sequence  = SEQUENCE_FADEOUT_WAIT;
    break;
  case SEQUENCE_FADEOUT_WAIT:
    if( gfl::grp::Fade_IsEnd() )
    {
      m_sequence  = SEQUENCE_END;
    }
    break;
  case SEQUENCE_END:
    return true;
  default:
    GFL_ASSERT(0);
  }
  
  return false;
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
