//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_ParentView.cpp
 *	@brief  [J[hŐeView
 *	@author	Toru=Nagihashi
 *	@date		2012.06.11
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_ParentView.h"
#include "../app_hologrammail_MailListView.h"
#include "app_hologrammail_LocalHologramView.h"
#include "app_hologrammail_LocalMailListView.h"
#include "app_hologrammail_NoneMailListView.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param mode  ʃ[h
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 * @param MailManager [}l[W[
 */
ParentView::ParentView( Mode mode, app::util::Heap * heap, gamesystem::GameManager *game_manager, MailManager * mail_manager ) :
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_mail_manager( mail_manager ),
  m_mail_list_view( NULL ),
  m_hologram_view( NULL ),
  m_listener( NULL ),
  m_start_mail( false )
{
  //OtBbNXVXe쐬
  this->CreateGraphicsSystem( heap );
  
  //Cxg[Nێ
  m_event_work  = game_manager->GetGameData()->GetEventWork();
  
  //CAEgVXe쐬
  m_g2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );
  m_g2dUtil->CreateLayoutSystem( heap );
  
  //[r[
  if( mode == MODE_NONE )
  {
    m_mail_list_view  = GFL_NEW( heap->GetSystemHeap() ) NoneMailListView( heap, m_graphicSystem, this->GetLayoutSystem(), game_manager->GetGameData() );
  }
  else
  {
    m_mail_list_view  = GFL_NEW( heap->GetSystemHeap() ) LocalMailListView( heap, m_graphicSystem, this->GetLayoutSystem(), mail_manager, game_manager->GetGameData() );
  }
  m_mail_list_view->Initialize();
  m_mail_list_view->SetListener( this );
  this->AddSubView( m_mail_list_view );
  
  //zOr[
  m_hologram_view = GFL_NEW( heap->GetSystemHeap() ) LocalHologramView( heap, m_graphicSystem, this->GetLayoutSystem(), game_manager );
  m_hologram_view->SetListener( this );
  m_hologram_view->Initialize();
  this->AddSubView( m_hologram_view );
  
  if( mode == MODE_NONE )
  {
    m_hologram_view->SetVisibleLiveIcon( true );
  }
  else
  {
    m_hologram_view->SetVisibleLiveIcon( false );
  }

}
/**
 * @brief fXgN^
 */
ParentView::~ParentView()
{
  m_hologram_view->RemoveFromSuperView();
  
  m_hologram_view->Finalize();
  GFL_SAFE_DELETE( m_hologram_view );

  m_mail_list_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_mail_list_view );

  m_g2dUtil->DeleteLayoutSystem();
  GFL_SAFE_DELETE( m_g2dUtil );

  GFL_SAFE_DELETE( m_mail_list_view );
  this->DeleteGraphicsSystem();
}
//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief `
 */
void ParentView::Draw( void )
{
}

/**
 * @brief Xi[o^
 *
 * @param listener  Xi[
 */
void ParentView::SetListener( ParentViewListener *listener )
{
  m_listener  = listener;
}
/**
 * @brief XNvgJn
 *
 * @param script_id XNvgԍ
 */
void ParentView::LoadScript( u32 script_id )
{
  m_hologram_view->LoadScript( script_id );
}
/**
 * @brief XNvgJn
 */
void ParentView::StartScript( void )
{
  m_hologram_view->StartScript();
}

//-----------------------------------------------------------------------
// HologramViewListener̎
//-----------------------------------------------------------------------
void ParentView::OnFinishLoadedBackGround(void)
{
  if(m_listener)
  {
    m_listener->OnFinishLoadedBackGround();
  }
}
void ParentView::OnFinishSetupScript(void)
{
  if(m_listener)
  {
    m_listener->OnFinishSetupScript();
  }
}
void ParentView::OnEndScript(void)
{
  if(m_listener)
  {
    m_listener->OnEndScript();
  }
  
  if( m_start_mail )
  {
    m_mail_list_view->ReturnMailList();
    m_start_mail  = false;
  }
}
//-----------------------------------------------------------------------
// MailListViewListener̎
//-----------------------------------------------------------------------
void ParentView::OnDecideMailList( u16 mail_index )
{
  LocalMail * mail = m_mail_manager->GetLocalMail( mail_index );
  mail->SetRead();
  mail->SetEventWork( m_event_work );
  this->LoadScript( mail->GetScriptId() );
  m_start_mail  = true;
}
void ParentView::OnSelectedReturnButton( void )
{
#if PM_DEBUG
  if( m_hologram_view->IsDebugMode() )
  {
    return;
  }
#endif
  if( m_listener )
  {
    m_listener->OnSelectedReturnButton();
  }
}

void ParentView::OnSelectedExitButton( void )
{
#if PM_DEBUG
  if( m_hologram_view->IsDebugMode() )
  {
    return;
  }
#endif
  if( m_listener )
  {
    m_listener->OnSelectedExitButton();
  }
}
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
