//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_LocalMailListView.h
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.07.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __APP_HOLOGRAMMAIL_LOCALMAILLISTVIEW_H__)
#define __APP_HOLOGRAMMAIL_LOCALMAILLISTVIEW_H__

#include <gflib.h>
#include <app/ui/UIView.h>
#include <app/tool/app_tool_panelist.h>
#include <app/util/app_util_ScrollBar.h>
#include "../app_hologrammail_MailListViewListener.h"
#include "../app_hologrammail_TouchbarView.h"
#include <app/tool/app_tool_MenuCursor.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

class MailManager;

class LocalMailListView : public MailListView
{
  GFL_FORBID_COPY_AND_ASSIGN(LocalMailListView);
public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param heap  q[v
   * @param graphics_system OtBbNXVXe
   * @param layout_system CAEgVXe
   * @param mail_manager  [}l[W[
   * @param game_data Q[f[^
   */
  LocalMailListView( app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, MailManager *mail_manager, const gamesystem::GameData *game_data );
  /**
   * @brief fXgN^
   */
  virtual ~LocalMailListView();
  /**
   * @brief 
   */
  virtual void Initialize( void );
  
  //-----------------------------------------------------------------------
  // VXe
  //-----------------------------------------------------------------------
  /**
   * @brief [̕A
   */
  void ReturnMailList( void );
public:
  //-----------------------------------------------------------------------
  // app::tool::PaneList::CallBack̎
  //-----------------------------------------------------------------------
  // Xg̍ڂ`悷R[obN֐
  virtual void CallBack_ListWrite( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos );
  //-----------------------------------------------------------------------
  // app::ui::UITouchBarListener̎
  //-----------------------------------------------------------------------
  /**
   * @brief {^ꂽƂʒm
   * @param buttonID
   * @retval t[ő̓CxgȂtrue
   * @retval ̃CxgrȂfalse
   */
  virtual bool OnSelectedButton( u32 buttonID );
protected:
  //-----------------------------------------------------------------------
  // MailListView̎
  //-----------------------------------------------------------------------
  virtual void CreateTouchbar( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system );
  virtual void SelectedList( u32 item_pos );
  
  virtual bool GetListDataNewFlag( u32 index );
  virtual void GetListDataString( u32 index, gfl::str::StrBuf * strbuf );
  virtual u32 GetListDataMax( void ) const;

public:
  enum ListMode
  {
    LIST_MODE_LIST,
    LIST_MODE_PERSON,
    LIST_MODE_TAG,
    
    LIST_MODE_MAX
  };
  
  enum ListPage
  {
    LIST_PAGE_TOP,
    LIST_PAGE_01,
    LIST_PAGE_MAX
  };
  
  enum ListDraw
  {
    LIST_DRAW_MAIL,
    LIST_DRAW_PERSON,
    LIST_DRAW_TAG,
  };
  
private:
  void ChangeListMode( ListMode mode );
  void PrevPaneList( void );
  void ReLoadPaneListByMode( ListMode mode, u16 cursor_pos, u16 list_pos );
  
private:
  class ListTree
  {
    GFL_FORBID_COPY_AND_ASSIGN(ListTree);
    public:
    ListTree() : m_list_mode(LIST_MODE_LIST), m_list_page(LIST_PAGE_TOP),
      m_cursor_pos(), m_list_pos() {}
    virtual ~ListTree(){}
    
    void ChangeMode( ListMode mode, u16 cursor_pos, u16 list_pos );
    void NextPage(u16 cursor_pos, u16 list_pos );
    void PrevPage( void );
    void GetCursorPos( u16 *cursor_pos, u16 *list_pos );
    
    ListDraw GetDraw(void) const;
    ListMode GetMode(void) const;
    ListPage GetPage(void) const;
    private:
    ListMode m_list_mode;
    ListPage m_list_page;
    
    u16 m_cursor_pos[LIST_MODE_MAX][ LIST_PAGE_MAX ];
    u16 m_list_pos[LIST_MODE_MAX][ LIST_PAGE_MAX ];
  };

private:
  MailManager *m_mail_manager;
  ListTree  m_tree;
};

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

#endif		// __APP_HOLOGRAMMAIL_LOCALMAILLISTVIEW_H__
