//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_LocalMailListView.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.07.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_LocalMailListView.h"
#include <arc/arc_def.h>
#include <arc/message.gaix>
#include <arc/hologram_mail_gra.gaix>
#include "../hologram_lower.h"
#include "../hologram_lower_pane.h"
#include "../app_hologrammail_common_define.h"
#include <message/msg_hologram_mail.h>
#include <common_res/msg_window_res.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param mail_manager  [}l[W[
 */
LocalMailListView::LocalMailListView( app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, MailManager *mail_manager, const gamesystem::GameData *game_data ):
  MailListView( heap, graphics_system, layout_system, game_data ),
  m_mail_manager( mail_manager ),
  m_tree()
{
}

/**
 * @brief fXgN^
 */
LocalMailListView::~LocalMailListView()
{
}


/**
 * @brief 
 */
void LocalMailListView::Initialize( void )
{
  this->MailListView::Initialize();
  
  LocalMail::SetMsgData( m_g2dUtil->GetMessageData() );
  
  m_g2dUtil->GetWordSet()->RegisterPlayerName( 0, m_game_data->GetPlayerStatus() );
  m_g2dUtil->GetWordSet()->RegisterPlayerNickName( 1, m_game_data->GetPlayerStatus() );
  m_g2dUtil->GetWordSet()->RegisterRivalName( 2, m_game_data->GetMisc() );
  
  //ACeȂ炠܂o
  if( this->GetListDataMax() == 0 )
  {
    this->SetVisibleWindow( true );
    this->SetVisibleList( false );
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_SWITCH_VANISH );
  }
  else
  {
    this->CreatePaneList( m_heap, 0,0,this->GetListDataMax() );
  }
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief [̕A
 */
void LocalMailListView::ReturnMailList( void )
{
  
  u32 cursor_pos;
  f32 list_pos;
  m_pane_list->GetCursorData( &cursor_pos, &list_pos );
  //m_tree.GetCursorPos( &cursor_pos, &list_pos );
  this->ReLoadPaneList( cursor_pos, list_pos, m_list_max );
  
  if( m_tree.GetPage() == LIST_PAGE_TOP )
  {
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_NORMAL );
  }
  else
  {  
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_RETURN_ONLY );
  }
  
  this->MailListView::ReturnMailList();
}

//-----------------------------------------------------------------------
// app::tool::PaneList::CallBack̎
//-----------------------------------------------------------------------
// Xg̍ڂ`悷R[obN֐
void LocalMailListView::CallBack_ListWrite( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
	if( pane_index != app::tool::PaneList::CALLBACK_PANE_NONE )
  {
    switch( m_tree.GetDraw() )
    {
    case LIST_DRAW_MAIL:
      {
        IMail *mail = m_mail_manager->GetMail( pos );
        gfl::str::StrBuf *src = m_g2dUtil->GetTmepStrBuf(0);
        gfl::str::StrBuf *dst = m_g2dUtil->GetTmepStrBuf(1);
        mail->GetTitle( src, m_heap->GetSystemHeap() );
        m_g2dUtil->GetWordSet()->Expand( dst, src );
        
        //
        this->SetTextboxPaneString( 0, pane[pane_index].text, dst );
        //New
        this->SetListNew( pane_index,  !mail->IsRead() );
      }
      break;
    case LIST_DRAW_PERSON:
      {
        NAGI_PRINT( "Local\n" );
        u32 cnt = 0;
        int i;
        for( i= static_cast<int>(PERSON_TYPE_DOCTOR); i < PERSON_TYPE_MAX; ++i )
        {
          if( m_mail_manager->ExistPerson( static_cast<PersonType>(i) ) )
          {
            if( cnt++ == pos )
            {
              break;
            }
          }
        }
        this->SetTextboxPaneMessage( 0, pane[pane_index].text, msg_holo_person_00+i-1 );
      }
      this->SetListNew( pane_index, false );
      break;
    case LIST_DRAW_TAG:
      {
        int cnt = 0;
        int i;
        for( i= 0; i < MAIL_TAG_MAX; ++i )
        {
          if( m_mail_manager->ExistTag( static_cast<MailTag>(i) ) )
          {
            if( cnt++ == pos )
            {
              break;
            }
          }
        }
        this->SetTextboxPaneMessage( 0, pane[pane_index].text,msg_holo_tag_00+i );
      }
      this->SetListNew( pane_index, false );
      break;
    }
  }
}

//-----------------------------------------------------------------------
// app::ui::UITouchBarListener̎
//-----------------------------------------------------------------------
/**
 * @brief {^ꂽƂʒm
 * @param buttonID
 * @retval t[ő̓CxgȂtrue
 * @retval ̃CxgrȂfalse
 */
bool LocalMailListView::OnSelectedButton( u32 buttonID )
{
  switch( buttonID )
  {
  case app::ui::UITouchBarView::BUTTON_ID_EXIT:   ///<~{^
    if( m_listener )
    {
      m_listener->OnSelectedExitButton();
    }
    break;
  case app::ui::UITouchBarView::BUTTON_ID_RETURN: ///<߂{^
    {
      if( m_tree.GetPage() == LIST_PAGE_TOP )
      {
        if( m_listener )
        {
          m_listener->OnSelectedReturnButton();
        }
      }
      else
      {
        this->SetVisibleList( true );
        this->PrevPaneList();
        m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_NORMAL );
      }
    }
    break;
  case app::ui::UITouchBarView::BUTTON_ID_LIST:
    this->ChangeListMode( LIST_MODE_LIST );
    break;
  case app::ui::UITouchBarView::BUTTON_ID_PERSON:
    this->ChangeListMode( LIST_MODE_PERSON );
    break;
  case app::ui::UITouchBarView::BUTTON_ID_TAG:
    this->ChangeListMode( LIST_MODE_TAG );
    break;
  }
    

  return false;
}


//-----------------------------------------------------------------------
// MailListView̎
//-----------------------------------------------------------------------
/**
 * @brief ^b`o[쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 */
void LocalMailListView::CreateTouchbar( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system )
{
  TouchbarView::Mode touchbar_mode  = TouchbarView::MODE_LIST;
  
  m_touchbar_view = GFL_NEW(heap->GetSystemHeap()) TouchbarView( heap, m_graphicSystem, layout_system, this->GetLayoutWork(0), touchbar_mode );
  m_touchbar_view->SetListener( this );
  this->AddSubView( m_touchbar_view );
}

/**
 * @brief XgI
 *
 * @param pos Iʒu
 */
void LocalMailListView::SelectedList( u32 item_pos )
{
  switch( m_tree.GetDraw() )
  {
  case LIST_DRAW_MAIL:
    this->SetVisibleList( false );
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_ALL_VANISH );

    if( m_listener )
    {
      m_listener->OnDecideMailList( item_pos );
    }
    
    break;
  case LIST_DRAW_PERSON:

    {
      u32 pos;
      f32 scroll;
      m_pane_list->GetCursorData( &pos, &scroll );
      m_tree.NextPage(pos,scroll);
    }
    //l͂PIW
    m_mail_manager->SortPerson( static_cast<PersonType>(item_pos +1) );
    if( m_mail_manager->GetMailMax() == 0 )
    {
      this->SetVisibleWindow( true );
      this->SetVisibleList( false );
    }
    else
    {
      this->ReLoadPaneList( 0, 0, m_mail_manager->GetMailMax() );
    }
    
    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_RETURN_ONLY );
    break;
  case LIST_DRAW_TAG:

    {
      u32 pos;
      f32 scroll;
      m_pane_list->GetCursorData( &pos, &scroll );
      m_tree.NextPage(pos,scroll);
    }
    m_mail_manager->SortTag( static_cast<MailTag>(item_pos) );

    if( m_mail_manager->GetMailMax() == 0 )
    {
      this->SetVisibleWindow( true );
      this->SetVisibleList( false );
    }
    else
    {
      this->ReLoadPaneList( 0, 0, m_mail_manager->GetMailMax() );
    }

    m_touchbar_view->SetVisibleMode( TouchbarView::VISIBLE_MODE_RETURN_ONLY );
    break;
  }
}

//-----------------------------------------------------------------------
// IListDataOwner
//-----------------------------------------------------------------------
/**
 * @brief VKtO擾 
 *
 * @param index XgCfbNX
 *
 * @return  VKtO
 */
bool LocalMailListView::GetListDataNewFlag( u32 index )
{
  return m_mail_manager->GetMail( index )->IsRead();
}
/**
 * @brief Xg\擾
 *
 * @param index XgCfbNX
 * @param strbuf  Xg\擾
 */
void LocalMailListView::GetListDataString( u32 index, gfl::str::StrBuf * strbuf )
{
  IMail *mail = m_mail_manager->GetMail( index );
  mail->GetTitle( strbuf, m_heap->GetSystemHeap()->GetLowerHandle() );
}
/**
 * @brief Xg擾
 *
 * @return  Xg
 */
u32 LocalMailListView::GetListDataMax( void ) const
{
  return m_mail_manager->GetMailMax();
}

//-----------------------------------------------------------------------
// Private
//-----------------------------------------------------------------------

/**
 * @brief Xg[hύX
 *
 * @param mode  [hύX
 */
void LocalMailListView::ChangeListMode( ListMode mode )
{
  //݂̃[h̃J[\o^[hύX
  u32 now_pos;
  f32 now_list;
  m_pane_list->GetCursorData( &now_pos, &now_list );
  m_tree.ChangeMode( mode, now_pos, now_list );
  
  //ύX̃J[\擾čĐ
  u16 cursor_pos;
  u16 list_pos;
  m_tree.GetCursorPos( &cursor_pos, &list_pos );
  this->ReLoadPaneListByMode( mode, cursor_pos, list_pos );

}

/**
 * @brief PÕy[WɃyCXg߂
 */
void LocalMailListView::PrevPaneList( void )
{
  m_tree.PrevPage();
  u16 cursor_pos;
  u16 list_pos;
  m_tree.GetCursorPos( &cursor_pos, &list_pos );
  this->ReLoadPaneListByMode( m_tree.GetMode(), cursor_pos, list_pos);
}

/**
 * @brief panelistĐ 
 *
 * @param mode  Đ̃[h
 * @param cursor_pos  J[\
 * @param list_pos  Xg
 */
void LocalMailListView::ReLoadPaneListByMode( ListMode mode, u16 cursor_pos, u16 list_pos )
{
  u32 list_max  = 0;
  switch( mode )
  {
  case LIST_MODE_LIST:
    //^CC[h
    list_max  = m_mail_manager->GetMailMax();
    break;
  case LIST_MODE_PERSON:
    //l[h
    for( int i= static_cast<int>(PERSON_TYPE_DOCTOR); i < PERSON_TYPE_MAX; ++i )
    {
      if( m_mail_manager->ExistPerson( static_cast<PersonType>(i) ) )
      {
        ++list_max;
      }
    }
    break;
  case LIST_MODE_TAG:
    //^O[h
    
    for( int i= 0; i < MAIL_TAG_MAX; ++i )
    {
      if( m_mail_manager->ExistTag( static_cast<MailTag>(i) ) )
      {
        ++list_max;
      }
    }
    break;
  }
  
  m_mail_manager->SortOrder();
  this->ReLoadPaneList( cursor_pos, list_pos, list_max );
}

//==================================================================================
//
//  Xgc[
//
//==================================================================================
/**
 * @brief Xg̃y[W
 */
static const struct
{
  LocalMailListView::ListMode mode; 
  LocalMailListView::ListDraw page_draw[ LocalMailListView::LIST_PAGE_MAX ];
  u32 page_max;
} list_page_data[]  =
{
  {
    LocalMailListView::LIST_MODE_LIST,
    { LocalMailListView::LIST_DRAW_MAIL },
    1,
  },
  {
    LocalMailListView::LIST_MODE_PERSON,
    { LocalMailListView::LIST_DRAW_PERSON, LocalMailListView::LIST_DRAW_MAIL },
    2,
  },
  {
    LocalMailListView::LIST_MODE_TAG,
    { LocalMailListView::LIST_DRAW_TAG, LocalMailListView::LIST_DRAW_MAIL },
    2,
  },
};


/**
 * @brief [hؑ
 *
 * @param mode  [h
 * @param ݂̃J[\ʒu
 * @param ݂̃Xgʒu
 */
void LocalMailListView::ListTree::ChangeMode( ListMode mode, u16 cursor_pos, u16 list_pos )
{
  m_cursor_pos[ m_list_mode ][ m_list_page ] = cursor_pos;
  m_list_pos[ m_list_mode ][ m_list_page ]   = list_pos;
  
  m_list_mode = mode;
}
/**
 * @brief ̃y[W
 * 
 * @param ݂̃J[\ʒu
 * @param ݂̃Xgʒu
 */
void LocalMailListView::ListTree::NextPage(u16 cursor_pos, u16 list_pos)
{
  if( m_list_page < list_page_data[ m_list_mode ].page_max )
  {
    m_cursor_pos[ m_list_mode ][ m_list_page ] = cursor_pos;
    m_list_pos[ m_list_mode ][ m_list_page ]   = list_pos;
    m_list_page = static_cast<ListPage>( m_list_page + 1 );
  }
}
/**
 * @brief Õy[W
 * 
 */
void LocalMailListView::ListTree::PrevPage(void)
{
  if( m_list_page > 0 )
  {
    m_cursor_pos[ m_list_mode ][ m_list_page ] = 0;
    m_list_pos[ m_list_mode ][ m_list_page ]   = 0;
    m_list_page = static_cast<ListPage>( m_list_page - 1 );
  }
}

/**
 * @brief J[\ʒu擾
 *
 * @param cursor_pos  J[\ʒu
 * @param list_pos    Xgʒu
 */
void LocalMailListView::ListTree::GetCursorPos( u16 *cursor_pos, u16 *list_pos )
{
  *cursor_pos = m_cursor_pos[ m_list_mode ][ m_list_page ];
  *list_pos  = m_list_pos[ m_list_mode ][ m_list_page ];
}
/**
 * @brief `悷̎擾
 *
 * @return  `
 */
LocalMailListView::ListDraw LocalMailListView::ListTree::GetDraw(void) const
{
  return list_page_data[ m_list_mode ].page_draw[ m_list_page ];
}
/**
 * @brief [h擾
 *
 * @return [h
 */
LocalMailListView::ListMode LocalMailListView::ListTree::GetMode(void) const
{
  return m_list_mode;
}

/**
 * @brief y[W擾
 *
 * @return y[W
 */
LocalMailListView::ListPage LocalMailListView::ListTree::GetPage(void) const
{
  return m_list_page;
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
