//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_LocalLocalHologramView.cpp
 *	@brief  zO  [J[h
 *	@author	Toru=Nagihashi
 *	@date		2012.07.25
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <arc/arc_def.h>
#include <arc/message.gaix>
#include <arc/hologram_mail_gra.gaix>
#include "app_hologrammail_LocalHologramView.h"
#include "../app_hologrammail_BackGround.h"
#include "../app_hologrammail_PersonManager.h"
#include "../hologram_upper.h"
#include "../hologram_upper_pane.h"
#include <sound/sound.h>
#include <debug/debug_ui.h>
#include "app_hologrammail_BattleBackGround.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param game_manager  Q[}l[W[
 */
LocalHologramView::LocalHologramView(app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, gamesystem::GameManager *game_manager ) :
  HologramView( heap, graphics_system, layout_system, game_manager ),
  m_script( NULL ),
  m_is_load_script( false ),
  m_is_start_script( false ),
  m_is_get_angle( true ),
  m_gyro_seq( 0 ),
  m_gyro_non_counter( 0 )
{
  this->InitializeGyroscope();
  m_script = GFL_NEW(heap->GetSystemHeap()) Script(heap, this );
  m_trans_vec = GFL_NEW(heap->GetSystemHeap()) gfl::math::TransVecLiner; 
}

/**
 * @brief fXgN^
 */
LocalHologramView::~LocalHologramView()
{
  GFL_SAFE_DELETE( m_trans_vec );
  GFL_SAFE_DELETE( m_script );
  this->FinalizeGyroscope();
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void LocalHologramView::Update(void)
{

  if( m_is_load_script )
  {
    if( m_person_manager->IsFinishLoad() )
    {
      
      GFL_PRINT( "[>Script LoadFinish\n" );
      if( m_listener )
      {
        m_listener->OnFinishSetupScript();     
      }
      m_is_load_script  = false;
    }
  }
  
  if( m_is_start_script )
  {
    if( m_script->IsEnd() )
    {
      
      GFL_PRINT( "[>Script End\n" );
      if(m_listener)
      {
        m_listener->OnEndScript();
      }
      
      m_person_manager->Delete();

      m_is_start_script = false;
    }
  }

  
  if( m_is_get_angle )
  {
    m_init_angle  = m_gyroscope->GetAngle();
    m_is_get_angle = false;
  }

#if PM_DEBUG
  if( !this->IsDebugMode()  )
#endif
  this->UpdateGyroCamera();
  m_script->Update();
  
  this->HologramView::Update();
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief XNvgǂݍ
 *
 * @param script_id JnXNvgԍ
 */
void LocalHologramView::LoadScript( u32 script_id )
{
  GFL_PRINT( "[>Script load\n" );
  m_script->Load( script_id );
  
  this->StartLoadPerson( script_id );
}
/**
 * @brief XNvgJn
 */
void LocalHologramView::StartScript( void )
{
  GFL_PRINT( "[>Script Start\n" );
  m_script->Start();
  m_is_start_script = true;
}
/**
 * @brief XNvgs
 *
 * @return trueŎs falseŎsĂȂ
 */
bool LocalHologramView::IsUpdateScript( void ) const
{
  return !m_script->IsEnd();
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief RDwi쐬
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 */
void LocalHologramView::CreateBackGround( app::util::Heap * heap, gamesystem::GameManager *game_manager )
{
  m_background = GFL_NEW(heap->GetSystemHeap()) BattleBackGround( heap, game_manager, m_graphicSystem, m_g3dutil );
  m_background->StartLoad();
  m_is_load_background  = true;
}
/**
 * @brief RDwij
 */
void LocalHologramView::DeleteBackGround(void)
{
  GFL_SAFE_DELETE( m_background );
}


/**
 * @brief XNvgID
 *
 * @param script_id XNvg
 */
void LocalHologramView::StartLoadPerson( u32 script_id )
{
  u32 max = m_script->GetEnterPersonMax();
  PersonManager::Description desc[4] = {};
  for( int i=0; i < max; ++ i)
  {
    desc[i].type = m_script->GetEnterPerson( i );
    desc[i].position  = person_position[max-1][i];
    desc[i].rotate    = person_rotate[max-1][i];
  }
  m_person_manager->StartLoad( desc, max );
  m_is_load_script  = true;
}

/**
 * @brief WC
 */
void LocalHologramView::InitializeGyroscope( void )
{
	// WC
	m_uiDeviceManager->BootGyroscope( m_heap->GetSystemHeap(), gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	m_gyroscope  = m_uiDeviceManager->GetGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	//m_gyroscope->SetZeroDriftMode( gfl::ui::Gyroscope::ZERO_DRIFT_MODE_TIGHT );
	//m_gyroscope->DisableRevisionByAcceleration();
	//m_gyroscope->DisableZeroDrift();
  

  //pxvZ{
  //gfl::math::VEC3 ratio( 0.2, 0.2, 0.2 );
  //m_gyroscope->SetAngleMagnification( ratio );
  
  //xɂRpD̗L͈ 0.4Ȃ0.6G~1.4G
  m_gyroscope->SetRevisionRangeByAcceleration( 0.2f );
}

/**
 * @brief WCj
 */
void LocalHologramView::FinalizeGyroscope( void )
{
  m_uiDeviceManager->StopGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
}

/**
 * @brief WCŃJ
 */
void LocalHologramView::UpdateGyroCamera( void )
{
  enum
  {
    SEQ_GYRO_ON,
    SEQ_WAIT_DEFAULT,
  };

  switch( m_gyro_seq )
  {
  case SEQ_GYRO_ON:
    {
      gfl::math::VEC3  angle;
      this->GetGyroAngle( &angle );

      gfl::math::VEC3 camera_pos;
      gfl::math::VEC3 target_pos;
      gfl::math::VEC3 camera_up;
      this->CalcGyroCameraPos( angle, &camera_pos, &target_pos, &camera_up );
      if( camera_pos != target_pos )
      {
        gfl::grp::g3d::Camera *camera = m_g3dutil->GetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER);
        camera->SetCameraPosition( camera_pos );
        camera->SetTargetPosition( target_pos );
        camera->SetUpVector( camera_up );
      }
      
      //WĈȂ
      gfl::math::VEC3 diff = angle; 
      //GFL_PRINT( "lengh %f\n", diff.Length() );
      //if( diff.Length()  && m_gyro_non_counter++ > 5*60 )
      if( m_button->IsTrigger(gfl::ui::BUTTON_START) 
          || m_is_enter_start )
      {
        m_trans_vec->Restart( target_pos, HologramView::default_target_pos, 40, m_heap->GetSystemHeap() );
        m_is_enter_start  = false;
        m_gyro_seq  = SEQ_WAIT_DEFAULT;
      }
    }
    break;
    
  case SEQ_WAIT_DEFAULT:
    {
      gfl::math::VEC3 target_pos = m_trans_vec->Update();
      gfl::grp::g3d::Camera *camera = m_g3dutil->GetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER);
      camera->SetTargetPosition( target_pos );
      GFL_PRINT( "cam pos %f %f %f\n", target_pos.x, target_pos.y, target_pos.z );
      if( m_trans_vec->IsEnd() )
      { 
        m_init_angle  = m_gyroscope->GetAngle();
        m_gyro_seq  = SEQ_GYRO_ON;
      }
    }
    break;
  default:
    GFL_ASSERT(0);
  }
}

/**
 * @brief WCpx擾()
 *
 * @param matrix  󂯎
 */
void LocalHologramView::GetGyroAngle( gfl::math::VEC3 * angle )
{
  static const gfl::math::VEC3 limit( 0.03f, 0.06f, 0.10f );

  *angle  = m_gyroscope->GetAngle();
  
  *angle -= m_init_angle;
  
  //ړől␳
  if( angle->x > limit.x )
  {
    angle->x = limit.x;
  }
  else if( angle->x < -limit.x)
  {
    angle->x = -limit.x;
  }
  if( angle->y > limit.y )
  {
    angle->y = limit.y;
  }
  else if( angle->y < -limit.y)
  {
    angle->y = -limit.y;
  }
  if( angle->z > limit.z )
  {
    angle->z = limit.z;
  }
  else if( angle->z < -limit.z)
  {
    angle->z = -limit.z;
  }
}

/**
 * @brief svZ
 */
void LocalHologramView::CalcGyroCameraPos(
    const gfl::math::VEC3& now_angle,
    gfl::math::VEC3* cameraPos,
    gfl::math::VEC3* targetPos,
    gfl::math::VEC3* upVec )
{
  //ړpx쐬
  gfl::math::VEC3 angle = now_angle; 
  
  gfl::math::VEC3 vec = HologramView::default_target_pos - HologramView::default_camera_pos;
  angle.y = angle.z;

  //]
  gfl::math::MTX34 rotate;
  rotate.SetupRotateXyz( angle );
  gfl::math::VEC3Transform( &vec, &rotate, &vec );
  
  //Jʒuɂ
  *cameraPos  = HologramView::default_camera_pos;
  *targetPos  = vec + HologramView::default_camera_pos;
  *upVec      = HologramView::default_camera_up;
}
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
