#! ruby -Ku
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		zkn_comment_kujira.rb
#	@brief  図鑑コメントコンバータ
#	@author	Toru=Nagihashi
#	@data		2012.07.31
#	
#	kujiraの図鑑コメントは、filemakerではなく、エクセルから出力されます。
#	エクセルは、過去のバージョンのコメントから選択できるように作成されており、
#	選択したものを吐き出すようにしております
#	
#	utf8でgmmを吐き出すため、utf8で記述しています
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
require "conv_tool.rb"
require 'kconv'
#-------------------------------------
# 引数
#=====================================
BODYCSVNAME   = ARGV[0]

HEADER_FILE_NAME  = "header.file"
FOOTER_FILE_NAME  = "footer.file"

COMMENT_X_ROW_ID  = "ZKN_COMMENT_00_"
COMMENT_Y_ROW_ID  = "ZKN_COMMENT_01_"

COMMENT_X_FILE_NAME = "zkn_comment_00.gmm"
COMMENT_Y_FILE_NAME = "zkn_comment_01.gmm"

#=============================================================================
#
#   モジュール
#
#=============================================================================
#-------------------------------------
# Bodyコンバート
#=====================================
BODY_ROW_START          = 2     #行開始位置
BODY_COL_NUMBER         = 0     #列:全国図鑑番号
BODY_COL_POKEMON        = 1     #列:ポケモン名
BODY_COL_X_VERSION      = 2     #列:Xのテキストバージョン
BODY_COL_Y_VERSION      = 3     #列:Yのテキストバージョン
BODY_COL_X_HIRAGANA     = 4     #列:Xひらがな
BODY_COL_X_KANJI        = 5     #列:X漢字
BODY_COL_X_CALC         = 6     #列:計算用１
BODY_COL_Y_HIRAGANA     = 7     #列:Yひらがな
BODY_COL_Y_KANJI        = 8     #列:Y漢字
BODY_COL_Y_CALC         = 9     #列:計算用２
def convertBody( csv, gmm, id, row_hiragana, row_kanji )
  
  header_text = open( HEADER_FILE_NAME )
  gmm.write( header_text.read )
  header_text.close
  
  #0番を入れる
  addGmmTags( gmm, "#{id}000", "", "" )

  for row in BODY_ROW_START...csv.row_length-1

    number    = csv.get( row, BODY_COL_NUMBER )
    hiragana  = csv.get( row, row_hiragana    )
    kanji     = csv.get( row, row_kanji       )

    addGmmTags( gmm, "#{id}#{number}", hiragana.toutf8, kanji.toutf8 )

  end

  footer_text = open( FOOTER_FILE_NAME )
  gmm.write( footer_text.read )
  footer_text.close

end

#-------------------------------------
# gmmへのタグ追加
#=====================================
def addGmmTags( gmm, tag, hiragana, kanji )

  gmm.write( "\t<row id=\"#{tag}\">\r\n" )
  gmm.write( "\t\t<language name=\"JPN\">")
  gmm.write( "#{hiragana}")
  gmm.write( "</language>\r\n")
  gmm.write( "\t\t<language name=\"JPN_KANJI\">")
  gmm.write( "#{kanji}")
  gmm.write( "</language>\r\n")
  gmm.write( "\t</row>\r\n")
  gmm.write( "\r\n")

end

#=============================================================================
#
#   メイン処理
#
#=============================================================================
begin

  #csv読込み
  bodyCsv = CsvLoader.new
  bodyCsv.setPrefix( '#start' )
  bodyCsv.setSuffix( '#end' )
  bodyCsv.load( BODYCSVNAME )
  
  #gmm作成
  x_gmm    = TextBuilder.new
  y_gmm    = TextBuilder.new

  #コンバート
  convertBody( bodyCsv, x_gmm, COMMENT_X_ROW_ID, BODY_COL_X_HIRAGANA, BODY_COL_X_KANJI )
  convertBody( bodyCsv, y_gmm, COMMENT_Y_ROW_ID, BODY_COL_Y_HIRAGANA, BODY_COL_Y_KANJI )

  #gmm書き込み
  x_gmm.genelate( COMMENT_X_FILE_NAME )
  y_gmm.genelate( COMMENT_Y_FILE_NAME )

end
