=begin
 * @file    tab_out_direct_sheet.rb
 * @brief   GNZ^u؂t@Co͂GNZ(V[gwIvVǉŁj
 * @author  ariizumi / hosaka genya
 * @data    09/09/22

  tab_out.rbł͌vZZɓ͂ĂꍇA̎o͂Ă܂ߍ쐬B
  Ruby1.8WłĂwin32oleƌCugāAGNZɒڃANZXA
@t@C̏o͂sĂB

@gĂ͈͂ŏo͂Ă̂ŁAA1sڂsƁABs2ڂo͂̂ŒӁB

  zukan_data悤ɕς̂zukan_dataɂ܂B
  ύX_́uZ̒ŉsƂɁARo[gƔf悤ɂv
  ؋@12/08/01
@
@tab_out_direct_sheet.rb <t@C> IvV

  IvV (ftHgTAB؂j
  -c
    J}؂
  -s
    J}؂{󔒂o

  -n x
    xԍ̃V[go(0)
=end


require 'win32ole'


module Worksheet
  def [] y,x
    self.Cells.Item(y,x).Value
  end
end

def getAbsolutePath filename
  fso = WIN32OLE.new('Scripting.FileSystemObject')
  return fso.GetAbsolutePathName(filename)
end

def PrintSheet( xl, sheetNo, sep, isOutSpace )
  sheet = xl.Worksheets.Item(sheetNo)
  sheet.extend Worksheet
  useRange = sheet.UsedRange
  colNum = useRange.Columns.Count
  rowNum = useRange.Rows.Count
#    print "#{colNum}F#{rowNum}s\n"
#    print "#{useRange.Column}F#{useRange.Row}s\n"
  
  1.upto(rowNum) do |rowNo|
    1.upto(colNum) do |colNo|
      if useRange.Cells(rowNo,colNo).Value != nil
        
        value = useRange.Cells(rowNo,colNo).Value
        
        if value.kind_of?(String)
          if value.include?("\n")
            value = "\"#{value}\""
          end
        end

        print value
        print sep
      else
        if isOutSpace == TRUE
        print sep
        end
      end
    end
    print "\n"
  end
#    print "s#{useRange.Columns.Count}\n"
#    print "s#{useRange.Rows.Count}s\n"
end

sep = "\t"
isOutSpace = FALSE
sheetno = -1
noget = false 
filename = ""

#IvV̉ߏ
ARGV.each{ |command|
  if noget
    sheetno = command.to_i
    noget = false
  else
    case command
    when "-c"	then
      sep = ','
    when "-s"	then 
      sep = ','
      isOutSpace = TRUE
    when "-n" then
      noget = true
    else
      filename = getAbsolutePath(command)
      ##when /\-.+/		then raise CommnandLineArgumentError, "ȃIvVł"
    end
  end
}


xl = WIN32OLE.new('Excel.Application')

begin
  xl.Workbooks.Open(filename)

  if sheetno == -1 then
    sheetNum = xl.Worksheets.Count
#   print "V[g#{sheetNum}\n"
    1.upto(sheetNum) do |sheetNo|
      PrintSheet( xl, sheetNo, sep, isOutSpace )
    end
  else
    PrintSheet( xl, sheetno+1, sep, isOutSpace )
  end
  
ensure
  xl.Workbooks.Close
  xl.Quit
end
