//==============================================================================
/**
 * @file	dialog_common_view.h
 * @brief	_CAOʉʁ@OtBbN
 * @author	ichiraku_katsuhiko
 * @data	2012/08/07, 11:46
 */
// =============================================================================

#if !defined( __DIALOG_COMMON_VIEW_H__ )
#define	__DIALOG_COMMON_VIEW_H__

#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>

#include "dialog_commonUIListener.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(dialog)

/**
 *	r[
 */
class ViewWork : public app::ui::UIView, public app::ui::UIInputListener
{
	GFL_FORBID_COPY_AND_ASSIGN(ViewWork);
public:

	//-------------------------------------
  ///	{^`
  //=====================================
	enum{
		BUTTON_1,	///< {^1
		BUTTON_2,	///< {^2
		BUTTON_3,	///< {^3
	};

private:
	typedef enum{
		LAYOUT_ID_UPPER,
		LAYOUT_ID_LOWER,
		LAYOUT_ID_MAX,
	}LAYOUT_ID;


	// LAj[V
	static const u32 SHARE_BUTTON_NUM = 3;
	enum AnimationDataId {
		ANIMATION_DATA_SELECT_2,			// {^2
		ANIMATION_DATA_SELECT_3,			// {^3
		ANIMATION_DATA_BUTTON_ON_TOUCH_DUMMY,
		ANIMATION_DATA_BUTTON_ON_CANCEL_DUMMY,
		ANIMATION_DATA_BUTTON_ON_RELEASE_DUMMY,
		ANIMATION_DATA_BUTTON_ON_ACTIVE_DUMMY,
		ANIMATION_DATA_BUTTON_ON_PASSIVE_DUMMY,
		ANIMATION_DATA_NUM,
	};
	enum AnimetionId {
		// ȉALAj[V
		ANIMATION_BUTTON_01_ON_TOUCH		= ANIMATION_DATA_NUM,
		ANIMATION_BUTTON_01_ON_CANCEL		= ANIMATION_BUTTON_01_ON_TOUCH	+ SHARE_BUTTON_NUM,
		ANIMATION_BUTTON_01_ON_RELEASE	= ANIMATION_BUTTON_01_ON_CANCEL	+ SHARE_BUTTON_NUM,
		ANIMATION_BUTTON_01_ON_ACTIVE		= ANIMATION_BUTTON_01_ON_RELEASE+ SHARE_BUTTON_NUM,
		ANIMATION_BUTTON_01_ON_PASSIVE	= ANIMATION_BUTTON_01_ON_ACTIVE	+ SHARE_BUTTON_NUM,
		ANIMATION_NUM										= ANIMATION_BUTTON_01_ON_PASSIVE+ SHARE_BUTTON_NUM,
	};
	
public:
  // RXgN^
  ViewWork( app::util::Heap * heap );

  // fXgN^
  virtual ~ViewWork( void );

public:
	void SetDialogCommonUIListener( DialogCommonUIListener *listener );

public:
	virtual void Update( void );
	virtual void Draw( void );

	// eLXg
	void InitTextPane( void );

public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);

private:
	void Initialize2D( app::util::Heap *heap );
	void CreateShareAnime( void );

private:
	static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[7];	///< Aj[Ve[u
	static const app::ui::ButtonInfo ButtonInfoList1[2];		///< {^j[INFO
	static const app::ui::ButtonInfo ButtonInfoList2[3];		///< {^j[INFO

	DialogCommonUIListener*		m_uiListener;		///< UICxgXi
};


GFL_NAMESPACE_END(dialog)
GFL_NAMESPACE_END(app)


#endif	/* __DIALOG_COMMON_VIEW_H__ */

