//==============================================================================
/**
 * @file	dialog_common_view.cpp
 * @brief	_CAOʉʁ@OtBbN
 * @author	ichiraku_katsuhiko
 * @data	2012/08/07, 11:45
 */
// =============================================================================

#include "dialog_common_main.h"
#include "dialog_common_res.h"
#include "dialog_common_res_pane.h"

#include <arc/arc_def.h>
#include <arc/dialog_common_res.gaix>
#include <message/message.gaix>
#include <message/msg_dialog_common.h>

#include "common_res/msg_window_res.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(dialog)


// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex ViewWork::LowerAnmIndex[ ViewWork::ANIMATION_DATA_NUM ] = {
	// wb_[̏ԂƓɂ
	LYTRES_DIALOG_COMMON_RES_DAILOG_LOWER_SELECT_2_BCLAN,
	LYTRES_DIALOG_COMMON_RES_DAILOG_LOWER_SELECT_3_BCLAN,
	// LAj
  //LYTRES_LAYOUT_ASSIST_POWER_LOWER_ACTIVE_BCLAN,
  //LYTRES_LAYOUT_ASSIST_POWER_LOWER_CANSEL_BCLAN,
  //LYTRES_LAYOUT_ASSIST_POWER_LOWER_PASSIVE_BCLAN,
  //LYTRES_LAYOUT_ASSIST_POWER_LOWER_RELEASE_BCLAN,
  //LYTRES_LAYOUT_ASSIST_POWER_LOWER_TOUCH_BCLAN,
};

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *    ButtonManagerpBoundbox Xg`
 */
//-----------------------------------------------------------------------------
const app::ui::ButtonInfo ViewWork::ButtonInfoList1[] ={
  ///< {^P
  {
    PANENAME_DAILOG_LOWER_PANE_BOUND2_1,	// picture_pane
    PANENAME_DAILOG_LOWER_PANE_BOUND2_1,	// bound_pane
    ANIMATION_BUTTON_01_ON_TOUCH+0,				// hold_anime_index
    ANIMATION_BUTTON_01_ON_CANCEL+0,			// release_anime_index
    ANIMATION_BUTTON_01_ON_RELEASE+0,			// select_anime_index
    ANIMATION_BUTTON_01_ON_ACTIVE+0,			// active_anime_index
    ANIMATION_BUTTON_01_ON_PASSIVE+0,			// passive_anime_index
  },
  ///< {^Q
  {
    PANENAME_DAILOG_LOWER_PANE_BOUND2_2,	// picture_pane
    PANENAME_DAILOG_LOWER_PANE_BOUND2_2,	// bound_pane
    ANIMATION_BUTTON_01_ON_TOUCH+1,				// hold_anime_index
    ANIMATION_BUTTON_01_ON_CANCEL+1,			// release_anime_index
    ANIMATION_BUTTON_01_ON_RELEASE+1,			// select_anime_index
    ANIMATION_BUTTON_01_ON_ACTIVE+1,			// active_anime_index
    ANIMATION_BUTTON_01_ON_PASSIVE+1,			// passive_anime_index
  },
};
const app::ui::ButtonInfo ViewWork::ButtonInfoList2[] ={
  ///< {^P
  {
    PANENAME_DAILOG_LOWER_PANE_BOUND_3_1,	// picture_pane
    PANENAME_DAILOG_LOWER_PANE_BOUND_3_1,	// bound_pane
    ANIMATION_BUTTON_01_ON_TOUCH+0,				// hold_anime_index
    ANIMATION_BUTTON_01_ON_CANCEL+0,			// release_anime_index
    ANIMATION_BUTTON_01_ON_RELEASE+0,			// select_anime_index
    ANIMATION_BUTTON_01_ON_ACTIVE+0,			// active_anime_index
    ANIMATION_BUTTON_01_ON_PASSIVE+0,			// passive_anime_index
  },
  ///< {^Q
  {
    PANENAME_DAILOG_LOWER_PANE_BOUND_3_2,	// picture_pane
    PANENAME_DAILOG_LOWER_PANE_BOUND_3_2,	// bound_pane
    ANIMATION_BUTTON_01_ON_TOUCH+1,				// hold_anime_index
    ANIMATION_BUTTON_01_ON_CANCEL+1,			// release_anime_index
    ANIMATION_BUTTON_01_ON_RELEASE+1,			// select_anime_index
    ANIMATION_BUTTON_01_ON_ACTIVE+1,			// active_anime_index
    ANIMATION_BUTTON_01_ON_PASSIVE+1,			// passive_anime_index
  },
  ///< {^R
  {
    PANENAME_DAILOG_LOWER_PANE_BOUND_3_3,	// picture_pane
    PANENAME_DAILOG_LOWER_PANE_BOUND_3_3,	// bound_pane
    ANIMATION_BUTTON_01_ON_TOUCH+2,				// hold_anime_index
    ANIMATION_BUTTON_01_ON_CANCEL+2,			// release_anime_index
    ANIMATION_BUTTON_01_ON_RELEASE+2,			// select_anime_index
    ANIMATION_BUTTON_01_ON_ACTIVE+2,			// active_anime_index
    ANIMATION_BUTTON_01_ON_PASSIVE+2,			// passive_anime_index
  },
};
				

// RXgN^
ViewWork::ViewWork( app::util::Heap * heap ) :
										app::ui::UIView( heap, heap->pDevHeapAllocator, heap->pDevHeapAllocator )
{
	m_uiListener = NULL;

	CreateGraphicsSystem( heap );
	Initialize2D( heap );

	// LAj[V쐬
	//CreateShareAnime();

	// {^}l[W
	u32 paneNum = sizeof(ButtonInfoList1) / sizeof(app::ui::ButtonInfo);
	CreateButtonManager( heap, GetLayoutWork(LAYOUT_ID_LOWER),
										 ButtonInfoList1, paneNum );

	SetInputListener( this );
}

// fXgN^
ViewWork::~ViewWork( void )
{
	Delete2D();
	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------
/**
 * @brief		UICxgpXi̓o^
 */
//--------------------------------------------------------------------------
void ViewWork::SetDialogCommonUIListener( DialogCommonUIListener *listener )
{
	m_uiListener = listener;
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 */
//--------------------------------------------------------------------------
void ViewWork::Update(void)
{
  app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 * @brief		`
 */
//--------------------------------------------------------------------------
void ViewWork::Draw(void)
{
  m_g2dUtil->Draw2D( m_graphicSystem, LAYOUT_ID_UPPER );
  m_g2dUtil->Draw2D( m_graphicSystem, LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief		eLXg
 * @param		u8*		p[ID̃Xg
 * @param		u8		p[̌
 */
//--------------------------------------------------------------------------
void ViewWork::InitTextPane( void )
{

}

//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool ViewWork::OnLayoutPaneEvent( const u32 painId )
{
	if( m_uiListener == NULL ){
		return true;
	}

  switch( painId ){
		case PANENAME_DAILOG_LOWER_PANE_BOUND2_1:	// {^P
			m_uiListener->OnSelectButton( 0 );
			return false;
		case PANENAME_DAILOG_LOWER_PANE_BOUND2_2:	// {^Q
			m_uiListener->OnSelectButton( 1 );
			return false;
    case PANENAME_DAILOG_LOWER_PANE_BOUND_3_1:	// {^P
			m_uiListener->OnSelectButton( 0 );
			return false;
    case PANENAME_DAILOG_LOWER_PANE_BOUND_3_2:	// {^Q
			m_uiListener->OnSelectButton( 1 );
			return false;
    case PANENAME_DAILOG_LOWER_PANE_BOUND_3_3:	// {^R
			m_uiListener->OnSelectButton( 2 );
			return false;
  }

  return true;
}


//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool ViewWork::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  return true;
}

//==========================================================================
/**
 *				private֐					
 */
//==========================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ViewWork::Initialize2D( app::util::Heap * heap )
{
	static const u32 DIALOG_COMMON_RES_ADD_MAX = LYTRES_MSG_WINDOW_RES_END;

	// A[JCuIDe[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[]={
		{ ARCID_DIALOG_COMMON,		0, DIALOG_COMMON_RES_ADD_MAX, app::util::G2DUtil::ATTACH_ROOT     },
		{ ARCID_COMMON_MSGWINDOW, 0,												 0, app::util::G2DUtil::ATTACH_RESOURCE }, // 01: ʃ\[X: bZ[WEBhE
		
	};

	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
		{	// 
			0,
			LYTRES_DIALOG_COMMON_RES_DAILOG_UPPER_BCLYT,			// resID̃CAEgf[^ID
			NULL,																				// Aj[Vf[^IDe[u	AĵȂꍇNULL
			0,																					// Aj[Vf[^IDe[u AĵȂꍇ0
			0,																					// o^Aj[Vő吔
			false,																			// \yCɍsvZs
			app::util::G2DUtil::SETUP_UPPER,						// fBXvC
			true,																				// \ݒ
		},
		{	// 
			0,
			LYTRES_DIALOG_COMMON_RES_DAILOG_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
			ANIMATION_NUM + ANIMATION_DATA_NUM,
			false,
			app::util::G2DUtil::SETUP_LOWER,
			true,
		},
	};

	Create2D( heap, NULL, LAYOUT_ID_MAX,
						resTbl, GFL_NELEMS(resTbl),
						layoutData, GFL_NELEMS(layoutData),
						GARC_message_dialog_common_DAT );
}

//--------------------------------------------------------------------------
/**
 * @brief		LAj[V쐬
 */
//--------------------------------------------------------------------------
void ViewWork::CreateShareAnime( void )
{
#if 0
	gfl::grp::g2d::LytWk* pLytWk = GetLayoutWork( LAYOUT_ID_LOWER );

  u32 activeAnimeNum  = 0;
  u32 cancelAnimeNum  = 0;
  u32 passiveAnimeNum = 0;
  u32 releaseAnimeNum = 0;
  u32 touchAnimeNum   = 0;
	
  touchAnimeNum += pLytWk->CreateShareAnime( ANIMATION_BUTTON_01_ON_TOUCH,
																								 LYTRES_LAYOUT_ASSIST_POWER_LOWER_TOUCH_BCLAN,
																								 SHARE_BUTTON_NUM, PANENAME_ASSIST_POWER_LOWER_GROUP_BUTTON_ANM );

  cancelAnimeNum += pLytWk->CreateShareAnime( ANIMATION_BUTTON_01_ON_CANCEL,
																								 LYTRES_LAYOUT_ASSIST_POWER_LOWER_CANSEL_BCLAN,
																								 SHARE_BUTTON_NUM, PANENAME_ASSIST_POWER_LOWER_GROUP_BUTTON_ANM );

  releaseAnimeNum += pLytWk->CreateShareAnime( ANIMATION_BUTTON_01_ON_RELEASE,
																								 LYTRES_LAYOUT_ASSIST_POWER_LOWER_RELEASE_BCLAN,
																								 SHARE_BUTTON_NUM, PANENAME_ASSIST_POWER_LOWER_GROUP_BUTTON_ANM );

  activeAnimeNum += pLytWk->CreateShareAnime( ANIMATION_BUTTON_01_ON_ACTIVE,
																								 LYTRES_LAYOUT_ASSIST_POWER_LOWER_ACTIVE_BCLAN,
																								 SHARE_BUTTON_NUM, PANENAME_ASSIST_POWER_LOWER_GROUP_BUTTON_ANM );

  passiveAnimeNum += pLytWk->CreateShareAnime( ANIMATION_BUTTON_01_ON_PASSIVE,
																								 LYTRES_LAYOUT_ASSIST_POWER_LOWER_PASSIVE_BCLAN,
																								 SHARE_BUTTON_NUM, PANENAME_ASSIST_POWER_LOWER_GROUP_BUTTON_ANM );
		

  GFL_ASSERT( (releaseAnimeNum==SHARE_BUTTON_NUM) && (cancelAnimeNum==SHARE_BUTTON_NUM) && \
              (touchAnimeNum==SHARE_BUTTON_NUM) && (activeAnimeNum==SHARE_BUTTON_NUM) && (passiveAnimeNum==SHARE_BUTTON_NUM) );
#endif

}

GFL_NAMESPACE_END(dialog)
GFL_NAMESPACE_END(app)
