//==============================================================================
/**
 * @file	dialog_common_main.h
 * @brief	_CAOʁ@C
 * @author	ichiraku_katsuhiko
 * @data	2012/08/07, 11:44
 */
// =============================================================================

#if !defined( __DIALOG_COMMON_MAIN_H__ )
#define	__DIALOG_COMMON_MAIN_H__

#include <app/dialog_common/dialog_common.h>

#include "dialog_common_view.h"
#include "dialog_commonUIListener.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(dialog)

class MainSystem : public DialogCommonUIListener
{
private:
	//-------------------------------------
	/// CV[PX`
  //=====================================
	typedef enum {
		MAINSEQ_INIT = 0,
		MAINSEQ_MAIN,
		MAINSEQ_FADE_OUT,
		MAINSEQ_RELEASE,
		MAINSEQ_END,
	}ENUM_MAIN_SEQ;

public:
  // RXgN^
  MainSystem( APP_PARAM *prm );
  // fXgN^
  virtual ~MainSystem( void );

public:
	bool Update( void );
	void Draw( void );

	//--------------------------------------------------------------
	// UIXi[
	virtual void OnSelectButton( int button_no );

private:
	void CreateSubWork( void );
	void DeleteSubWork( void );

	void SetFadeIn( void );
	void SetFadeOut( void );
	void SetFinish( ENUM_END_MODE retCode );	// Iݒ
	void SetMainSeq( ENUM_MAIN_SEQ seq );
	
	bool DoSeqProcess( void );

private:
	// CV[PX
	void MainSeq_Init( void );
	bool MainSeq_Release( void );
	void MainSeq_Fade( ENUM_MAIN_SEQ seq );
	void MainSeq_Main( void );

private:
  static const u32 APP_HEAP_SIZE    = 0x12000;   // Avp[Jq[vTCY
  static const u32 DEVICE_HEAP_SIZE = 0xD8000;   // Avp[JfoCXq[vTCY

private:
	ViewWork*								m_view;						///< `Ǘ
  app::util::Heap         m_heap;           ///< q[vǗ
  APP_PARAM*              m_appParam;       ///< Np[^
  ENUM_MAIN_SEQ 					m_seq;						///< JgV[PX
  bool                    m_isFinish;       ///< fItO

};


GFL_NAMESPACE_END(dialog)
GFL_NAMESPACE_END(app)


#endif	/* __DIALOG_COMMON_MAIN_H__ */

