//==============================================================================
/**
 * @file		dialog_common.cpp
 * @brief		_CAOʉ
 * @author	ichiraku_katsuhiko
 * @data	2012/08/07, 11:36
 */
// =============================================================================

#include <app/dialog_common/dialog_common.h>
#include "dialog_common_main.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(dialog)

// RXgN^
Proc::Proc( APP_PARAM *prm )
{
	m_appParam  = prm;
  CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

// fXgN^

Proc::~Proc( void )
{
	DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	GFL_DELETE	pMain;
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	if( pMain->Update() )
	{
	  return gfl::proc::RES_CONTINUE;
	}
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	pHeap = GFL_CREATE_HEAP( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
                           HEAPID_DIALOG_COMMON_SYS, SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}

GFL_NAMESPACE_END(dialog)
GFL_NAMESPACE_END(app)
