//==============================================================================
/**
 * @file		dialog_common.h
 * @brief		_CAOʉ
 * @author	ichiraku_katsuhiko
 * @data	2012/08/07, 11:32
 */
// =============================================================================

#if !defined( __DIALOG_COMMON_H__ )
#define	__DIALOG_COMMON_H__

#include <gflib.h>
#include <gfl_Device.h>
#include "gamesystem/GameProc.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(dialog)


// NXO錾
class MainSystem;

//-------------------------------------
///	I[h
//=====================================
typedef enum {
	END_MODE_BUTTON1 = 0,
	END_MODE_BUTTON2,
} ENUM_END_MODE;


//-------------------------------------
///	Oݒp[^
//=====================================
typedef struct {
	u16								msg_id;						///< [in] \郁bZ[WID
  ENUM_END_MODE			m_endMode;        ///< [out]I[h(ENUM_END_MODE)
}APP_PARAM;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class Proc : public gamesystem::GameProc
{
public:
  // RXgN^
  Proc( APP_PARAM *prm );
  // fXgN^
  virtual ~Proc( void );

public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result InitFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcI
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result EndFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcAbvf[g
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc`揈
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void DrawFunc( gfl::proc::Manager * proc_manager );


private:

	private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateHeap(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteHeap(void);

private:
  gfl::heap::HeapBase*                 pHeap;        // VXeq[v
  MainSystem*                          pMain;        // fNX
  APP_PARAM*                           m_appParam;   // Np[^

  static const u32      SYS_HEAP_SIZE = 0x800;      // VXeq[vTCY
};

GFL_NAMESPACE_END(dialog)
GFL_NAMESPACE_END(app)

#endif	/* __DIALOG_COMMON_H__ */

