//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		debug_pokemon_memory.cpp
 *	@brief  |P̋LfobO
 *	@author	Toru=Nagihashi
 *	@date		2012.08.06
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#if PM_DEBUG

#include <debug/debug_ui.h>
#include <poke_tool/poke_tool_PokeMemory.h>
#include <debug\debug_pokemon_memory.h>

GFL_NAMESPACE_BEGIN(xy_debug)


int PokemonMemory::m_code = 0;
int PokemonMemory::m_pos  = 0;
int PokemonMemory::m_data = 0;

void PokemonMemory::Initialize( void )
{
  m_code = 0;
  m_pos  = 0;
  m_data = 0;
}

void PokemonMemory::Finalize( void )
{
}

//LR[hZbg
void PokemonMemory::Update_Code( void* userWork, gfl::debug::DebugWinItem* item )
{
  static const int max  = poke_tool::PokeMemory::EVENT_MAX + 1; ///+1͔͈͊O`FbN̂

  if( DebugButton::IsTrigger( gfl::ui::BUTTON_LEFT ) )
  {
    m_code--;
    if( m_code < 0 )
    {
      m_code  = max-1;
    }
  }
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_RIGHT ) )
  {
    m_code++;
    m_code  %= max;
  }
}
wchar_t* PokemonMemory::Draw_Code( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = gfl::debug::DebugWin_GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls[%d]",item->GetName(), m_code );
  return workStr;
}

//Lf[^Zbg
void PokemonMemory::Update_Data( void* userWork, gfl::debug::DebugWinItem* item )
{
  static const int max  = 1000;

  if( DebugButton::IsTrigger( gfl::ui::BUTTON_LEFT ) )
  {
    m_data--;
    if( m_data < 0 )
    {
      m_data  = max-1;
    }
  }
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_RIGHT ) )
  {
    m_data++;
    m_data  %= max;
  }
}
wchar_t* PokemonMemory::Draw_Data( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = gfl::debug::DebugWin_GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls[%d]",item->GetName(), m_data );
  return workStr;
}

//莝ԍ
void PokemonMemory::Update_PartyIndex( void* userWork, gfl::debug::DebugWinItem* item )
{
  gamesystem::GameManager * game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
  gamesystem::GameData  * game_data = game_manager->GetGameData();

  pml::PokeParty  *party  = game_data->GetPlayerParty();
  const int max  = party->GetMemberCount();

  if( DebugButton::IsTrigger( gfl::ui::BUTTON_LEFT ) )
  {
    m_pos--;
    if( m_pos < 0 )
    {
      m_pos  = max-1;
    }
  }
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_RIGHT ) )
  {
    m_pos++;
    m_pos  %= max;
  }
}
wchar_t* PokemonMemory::Draw_PartyIndex( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = gfl::debug::DebugWin_GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls[%d]",item->GetName(), m_pos );
  return workStr;
}

//LZbg
void PokemonMemory::Update_Set( void* userWork, gfl::debug::DebugWinItem* item )
{
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_A ) )
  {
    

    gamesystem::GameManager * game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData  * game_data = game_manager->GetGameData();
    savedata::MyStatus* my_status = game_data->GetPlayerStatus();
    pml::pokepara::CoreParam * core_param = game_data->GetPlayerParty()->GetMemberPointer( m_pos );
    
    poke_tool::PokeMemory::Set( static_cast<poke_tool::PokeMemory::Event>(m_code), m_data, core_param, my_status );

    xy_snd::PlaySE( SEQ_SE_DECIDE1 );
  }
}

wchar_t* PokemonMemory::Draw_Set( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = gfl::debug::DebugWin_GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls",item->GetName() );
  return workStr;
}

GFL_NAMESPACE_END(xy_debug)
#endif //PM_DEBUG
