//============================================================================================
/**
 * @file		CharacterPane.cpp
 * @brief		LN^[yC
 *
 * namespace	app::pss::pss_top_list::
 */
//============================================================================================

#include "CharacterPane.h"


namespace app {
namespace pss {
namespace pss_top_list {



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
PssCommentWindow::PssCommentWindow( void )
{
  Reset();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
PssCommentWindow::~PssCommentWindow(void)
{

}


//--------------------------------------------------------------------------------------------
/**
 * @brief  oϐ̏
 *
 * @param  none
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void PssCommentWindow::Reset( void )
{
  const savedata::Config* config = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetGameData()->GetConfig();
  const savedata::Config::MSG_SPEED msgSpeed = config->GetMsgSpeed();

  // \xݒɍ킹ĕ\ԂύX
  if( msgSpeed == savedata::Config::MSG_FAST ){
    m_waitTimer = WAIT_TIME;
  }
  else if( msgSpeed == savedata::Config::MSG_NORMAL ){
    m_waitTimer = WAIT_TIME * 3 / 2;
  }
  else{
    m_waitTimer = WAIT_TIME * 2;
  }

  m_alpha     = 0;
  m_isFadeOut = false;
  m_isActive  = false;
  m_posX      = 0;
  m_posY      = 0;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  ZbgAbv
 *
 * @param  heap   q[v
 * @param  view   \ΏۂƂȂView
 * @param  layout CAEgID
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void PssCommentWindow::Setup(  app::util::Heap * heap, app::ui::UIView* view, u32 layout )
{
  m_heap     = heap;
  m_view     = view;
  m_layoutId = layout;

  app::util::G2DUtil* g2dUtil = view->GetG2DUtil();
  g2dUtil->SetPaneVisible( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_PLATE_00, false );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  Jn
 *
 * @note   Ŏw肵́ÄɃRs[܂
 *
 * @param  name    vC[
 * @param  comment \Ώە
 * @param  posX    \wWl
 * @param  posY    \xWl
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void PssCommentWindow::Start( const gfl::str::STRCODE* name, const gfl::str::STRCODE* comment, s16 posX, s16 posY )
{
  Reset();

  m_isActive = true;
  m_posX     = posX;
  m_posY     = posY;

  if( m_view != NULL )
  {
    app::util::G2DUtil* g2dUtil = m_view->GetG2DUtil();
    gfl::str::StrBuf    buf( 64, m_heap->pHeap );

    buf.SetStr( name );
    g2dUtil->SetRegisterWord( 0, buf, WordSet::GRAMMER_NEUTRAL, WordSet::FORM_NONE, LANG_NULL );
    buf.SetStr( comment );
    g2dUtil->SetRegisterWord( 1, buf, WordSet::GRAMMER_NEUTRAL, WordSet::FORM_NONE, LANG_NULL );
    m_view->SetTextboxPaneMessage( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_TEXT_00, msg_pss_20_00_01 );

    // ftHg̓At@l0ɐݒ
    g2dUtil->SetPaneAlpha( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_PLATE_00, 0 );
    g2dUtil->SetPaneAlpha( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_TEXT_00,  0 );

    // \ON
    g2dUtil->SetPaneVisible( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_PLATE_00, true );

    // \ʒuݒ
    gfl::math::VEC3 pos;
    pos.x = posX;
    pos.y = posY;
    pos.z = 0.0f;
    m_view->SetPanePos( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_PLATE_00, &pos );
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  ~
 *
 * @param  none
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void PssCommentWindow::Stop( void )
{
  Reset();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   LtO̎擾
 *
 * @param   none
 *
 * @return  LȂtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssCommentWindow::IsActive( void ) const
{
  return m_isActive;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Abvf[g
 *
 * @param   none
 *
 * @return  \Ȃtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssCommentWindow::Update(void)
{
  if( IsActive() )
  {
    if( m_isFadeOut )
    {
      if( m_alpha > SUB_ALPHA )
      {
        m_alpha -= (SUB_ALPHA*2);
      }
      else
      {
        Reset();
        app::util::G2DUtil* g2dUtil = m_view->GetG2DUtil();
        g2dUtil->SetPaneVisible( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_PLATE_00, false );
      }
    }
    else
    {
      if( m_alpha < 100 )
      {
        m_alpha += SUB_ALPHA;
      }
      else if( m_waitTimer > 0 ){
        m_waitTimer--;
      }
      else{
        m_isFadeOut = true;
      }
    }
    gfl::core::Math::Clamp( &m_alpha, 0, 100 );
  }

  return IsActive();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief `揈
 *
 * @param none
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void PssCommentWindow::Draw( void )
{
  if( IsActive() && (m_view!=NULL) )
  {
    app::util::G2DUtil* g2dUtil = m_view->GetG2DUtil();
    g2dUtil->SetPaneAlpha( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_PLATE_00, m_alpha*200/100 );
    g2dUtil->SetPaneAlpha( m_layoutId, PANENAME_PSS_LOWER_PANE_NAME_TEXT_00,  m_alpha*255/100 );
  }
}


}		// pss_top_list
}		// pss
}		// app
