//============================================================================================
/**
 * @file		gts_util.cpp
 * @brief		GTSʏ֘A
 * @author	Akito Mori
 * @date		12.08.03
 *
 * namespace	app::gts::
 *
 */
//============================================================================================
#include "netapp/gts/gts.h"
#include "app/box/box.h"

#include "gts_util.h"

namespace netapp{
namespace gts{



	//------------------------------------------------------------------------------------------
	/**
	 * @brief		gCʒuƈʒu|Pp[^n
	 *
	 * @param		heap            q[v
	 * @param		pSaveBoxPokemon BOX|PZ[uf[^
	 * @param		pPokeParty      莝|PZ[uf[^
	 * @param		tray            gCʒu
	 * @param		pos             ʒu
	 *
	 * @return	pml::pokeparam::PokemonParam ͎
	 */
	//------------------------------------------------------------------------------------------
pml::pokepara::PokemonParam *GtsUtil::GetPokemonParam( app::util::Heap * heap, savedata::BoxPokemon *pSaveBoxPokemon, 
                                                       pml::PokeParty *pPokeParty, int tray, int pos )
{
  pml::pokepara::PokemonParam *param; 

  // 莝
  if( tray==app::box::BOX_END_SELECT_TRAY_PARTY ){
    param = GFL_NEW(heap->pHeap) pml::pokepara::PokemonParam( heap->pHeap );
    pml::pokepara::PokemonParam *tmp = pPokeParty->GetMemberPointer( pos );
    param->CopyFrom( *tmp );

  // {bNX
  }else if(tray>=0 && tray<savedata::BOX::TRAY_MAX){
    pml::pokepara::CoreParam *core = GFL_NEW(heap->pHeap) pml::pokepara::CoreParam( heap->pHeap );
    pSaveBoxPokemon->GetPokemon( core, tray, pos );
    param = GFL_NEW(heap->pHeap) pml::pokepara::PokemonParam( heap->pHeap, *core );
    GFL_DELETE core;
  }else{
    GFL_ASSERT(0);
  }

  return param;
}

}// gts
}// netapp
