//==============================================================================

#include "LoveDebug.h"

/**
 * @file	LoveDebug.cpp
 * @brief	
 * @author	kimura_shin
 * @data	2012/08/01, 15:06
 */
// =============================================================================

#if PM_DEBUG
// \̃bZ[WX^WI֘A
#include "message/debug_message.gaix"
#include "arc_def.h"
#include "message/debug/msg_debug_menu.h"
#include "kawaigari/love_main.h"

namespace kawaigari {

s32 LoveDebug::s_FoodId = 0;

//-----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
DebugMenu::DebugMenu( void )
{
	for( int i = 0; i < GROUP_ID_MAX; i++ ){
		m_pGroup[i] = NULL;
	}
}

//-----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
DebugMenu::~DebugMenu( void )
{
	this->RemoveMenu( );
}

//-----------------------------------------------------------------------------
/**
 *	@brief  CX^X𐶐
 *
 *	@param	gfl::heap::HeapBase* heap q[v
 *	@param  gamesystem::GameManager* gman Q[}l[W
 *
 *	@retval NX
 */
//-----------------------------------------------------------------------------
DebugMenu* DebugMenu::CreateInstance( gfl::heap::HeapBase* heap, gamesystem::GameManager* gman )
{
	//  Fieldmap* love = gman->GetFieldmap();

	DebugMenu* dbgmenu = GFL_NEW( heap ) DebugMenu( );

	dbgmenu->m_pEvent = NULL;
	dbgmenu->m_pGameManager = gman;
	dbgmenu->m_bAddMenu = false;
	gfl::core::Debug::PrintConsole( "init debug love\n" );

	// fobOEBhE
	//  dbgmenu->AddMenu();
	return dbgmenu;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  j[ǉ
 */
//-----------------------------------------------------------------------------
void DebugMenu::AddMenu( void )
{
	gfl::core::Debug::PrintConsole( "add menu\n" );
	if( m_bAddMenu ){
		return;
	}
	m_bAddMenu = true;

	gfl::heap::HeapBase * heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_DEBUG )->GetLowerHandle( );

	// 񃏁[N
//	m_pStrWork = GFL_NEW( heap ) gfl::str::StrBuf( 256, heap );
#    if 0 // 
	// ObjCode̊m
	{
		u32 dat = GARC_message_objcode_DAT;
		m_pObjCodeMsgData = GFL_NEW( heap )
			gfl::str::MsgData( ARCID_MESSAGE,
							   dat, heap, gfl::str::MsgData::LOAD_FULL );
	}
#    endif

	//  gfl::str::StrBuf* pStrBufTmp = GFL_NEW( heap ) gfl::str::StrBuf( FIELD_DEBUG_MESSAGE_STR_BUF_SIZE, heap );

	// bZ[Wf[^̊mہAœnĂq[vł͖AfobN̈悩擾
	gfl::heap::HeapBase * messageHeap( gfl::heap::Manager::GetHeapByHeapId( HEAPID_DEBUG )->GetLowerHandle( ) );
	gfl::str::MsgData* pMsgData = GFL_NEW( messageHeap ) gfl::str::MsgData(
																			ARCID_DEBUG_MESSAGE,
																			GARC_debug_message_debug_menu_DAT,
																			messageHeap,
																			gfl::str::MsgData::LOAD_FULL
																			);

	// 
	{
		this->AddGroup( pMsgData, DebMenu_Love_Main, GROUP_ID_ROOT, GROUP_ID_NULL );
		// P[L
		{
			this->AddGroup( pMsgData, DebMenu_Love_Food, GROUP_ID_FOOD_ID, GROUP_ID_ROOT );
//			this->AddUpdateFunc( pMsgData, DebMenu_Field_HairSet, this, DebugWinFunc_HairSet, NULL, GROUP_ID_F );
			this->AddValueInt( pMsgData, DebMenu_Love_Food_00, &LoveDebug::s_FoodId, 0, 25, 1, GROUP_ID_FOOD_ID );
		}
	}

	GFL_SAFE_DELETE( pMsgData );

}

//-----------------------------------------------------------------------------
/**
 *	@brief  j[폜
 */
//-----------------------------------------------------------------------------
void DebugMenu::RemoveMenu( void )
{
	if( m_bAddMenu ){
		for( int i = GROUP_ID_MAX - 1; i >= 0; --i ){
			GFL_ASSERT( m_pGroup[i] ); // ̂̂͂Ȃ͂
			gfl::debug::DebugWin_RemoveGroup( m_pGroup[i] );
			m_pGroup[i] = NULL;
		}

		// ObjCodebZ[W
//		GFL_DELETE m_pObjCodeMsgData;
//		m_pObjCodeMsgData = NULL;

		// ėpSTRBUF
//		GFL_DELETE m_pStrWork;
//		m_pStrWork = NULL;

		m_bAddMenu = false;
	}
}

//-----------------------------------------------------------------------------
/**
 *	@brief  j[(+tB[hڂ폜)
 */
//-----------------------------------------------------------------------------
void DebugMenu::CloseMenu( void )
{
	gfl::debug::DebugWin_CloseWindow( );
	RemoveMenu( );
}

//-----------------------------------------------------------------------------
/**
 *	@brief  O[vo^
 *
 *	@param	group_name           O[v
 *	@param	group_id             o^O[vID
 *	@param	parent_id            O[v̐eID
 */
//-----------------------------------------------------------------------------
void DebugMenu::AddGroup( const wchar_t* group_name, GROUP_ID group_id, GROUP_ID parent_id )
{
  gfl::debug::DebugWinGroup* parent = NULL;

  GFL_ASSERT( group_id < GROUP_ID_MAX );
  GFL_ASSERT( m_pGroup[ group_id ] == NULL );

  if( parent_id != GROUP_ID_NULL )
  {
    GFL_ASSERT( parent_id < GROUP_ID_MAX );
    parent = m_pGroup[ parent_id ];
  }

  m_pGroup[ group_id ] = gfl::debug::DebugWin_AddGroup( group_name, parent );
}
void DebugMenu::AddGroup( gfl::str::MsgData *msgData,  u32 rabel_id, GROUP_ID group_id, GROUP_ID parent_id )
{
  gfl::debug::DebugWinGroup* parent = NULL;

  GFL_ASSERT( msgData );
  GFL_ASSERT( group_id < GROUP_ID_MAX );
  GFL_ASSERT( m_pGroup[ group_id ] == NULL );

  if( parent_id != GROUP_ID_NULL )
  {
    GFL_ASSERT( parent_id < GROUP_ID_MAX );
    parent = m_pGroup[ parent_id ];
  }
  m_pGroup[ group_id ] = gfl::debug::DebugWin_AddGroup( msgData, rabel_id, parent );
}
//-----------------------------------------------------------------------------
/**
 *	@brief  ڒǉF֐
 *
 *	@param	const wchar_t* name  ږ
 *	@param	work                 [NAhX
 *	@param	update_func          XV֐
 *	@param	draw_func            `֐
 *	@param	group_id             o^O[vID
 */
//-----------------------------------------------------------------------------
void DebugMenu::AddUpdateFunc( const wchar_t* name, void* work, gfl::debug::DebugWinUpdateFunc update_func, gfl::debug::DebugWinDrawFunc draw_func, GROUP_ID group_id )
{
	GFL_ASSERT( group_id < GROUP_ID_MAX );
	GFL_ASSERT( m_pGroup[ group_id ] ); // ̂̂͂Ȃ͂
	gfl::debug::DebugWin_AddItemUpdateFunc( m_pGroup[ group_id ], name, work, update_func, draw_func, gfl::heap::Manager::GetHeapByHeapId( HEAPID_DEBUG )->GetLowerHandle( ) ); // ڂƂ̃mېHEAPID_DEBUGHEAPID_DEBUGWINɕUB
}
void DebugMenu::AddUpdateFunc( gfl::str::MsgData *msgData, u32 rabel_id, void* work, gfl::debug::DebugWinUpdateFunc update_func, gfl::debug::DebugWinDrawFunc draw_func, GROUP_ID group_id )
{
	GFL_ASSERT( group_id < GROUP_ID_MAX );
	GFL_ASSERT( m_pGroup[ group_id ] ); // ̂̂͂Ȃ͂
	gfl::debug::DebugWin_AddItemUpdateFunc( m_pGroup[ group_id ], msgData, rabel_id, work, update_func, draw_func, gfl::heap::Manager::GetHeapByHeapId( HEAPID_DEBUG )->GetLowerHandle( ) ); // ڂƂ̃mېHEAPID_DEBUGHEAPID_DEBUGWINɕUB
}

//-----------------------------------------------------------------------------
/**
 *	@brief  ڒǉF
 *
 *	@param	const wchar_t* name   ږ
 *	@param	target                Ώۂ̐lւ̃|C^
 *	@param  min                   ŏl
 *	@param  max                   ől
 *  @param  step                  ړ(R10{AL100{ALR1000{ő)
 *	@param	group_id              o^O[vID
 *
 *  @return DebugWinItemValueInt<int>* ߂lɑ΂SetChangedValueFuncĂԂƐlϓ̊֐ݒł܂
 */
//-----------------------------------------------------------------------------
gfl::debug::DebugWinItemValueInt<int>* DebugMenu::AddValueInt( const wchar_t* name, int* target, int min, int max, int step, GROUP_ID group_id )
{
  GFL_ASSERT( group_id < GROUP_ID_MAX );
  GFL_ASSERT( m_pGroup[ group_id ] ); // ̂̂͂Ȃ͂

  return gfl::debug::DebugWin_AddItemValueInt( m_pGroup[ group_id ], name, target, min, max, step );  // ڂƂ̃mېHEAPID_DEBUGHEAPID_DEBUGWINɕUB
}
gfl::debug::DebugWinItemValueInt<int>* DebugMenu::AddValueInt( gfl::str::MsgData *msgData, u32 rabel_id, int* target, int min, int max, int step, GROUP_ID group_id )
{
  GFL_ASSERT( group_id < GROUP_ID_MAX );
  GFL_ASSERT( m_pGroup[ group_id ] ); // ̂̂͂Ȃ͂

  return gfl::debug::DebugWin_AddItemValueInt( m_pGroup[ group_id ], msgData, rabel_id, target, min, max, step );  // ڂƂ̃mېHEAPID_DEBUGHEAPID_DEBUGWINɕUB
}
//-----------------------------------------------------------------------------
/**
 *	@brief  fobOj[I҂CxgĂяo
 *
 *	@param	evman  Cxg}l[W
 */
//-----------------------------------------------------------------------------
void DebugMenu::CallEvent( void )
{
  gamesystem::GameEventManager* evman = m_pGameManager->GetGameEventManager();
//  GFL_ASSERT( m_pEvent == NULL );
  m_pEvent = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventDebugMenu>( evman );
}

//=============================================================================
// EventDebugMenu
//=============================================================================

//--------------------------------------------------------------
/**
 * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
 * @param   p_gman       Q[}l[W[NX
 * @retval  true  NĂ悢
 * @retval  false NȂ
 */
//--------------------------------------------------------------
bool EventDebugMenu::BootChk( gamesystem::GameManager* p_gman )
{
  GFL_UNUSED( p_gman );
  return true;
}

//--------------------------------------------------------------
/**
 * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
 * @param   p_gman       Q[}l[W[NX
 */
//--------------------------------------------------------------
void EventDebugMenu::InitFunc(gamesystem::GameManager* p_gman )
{
	gfl::core::Debug::PrintConsole( "init event debug\n" );
  GFL_UNUSED( p_gman );
}

//--------------------------------------------------------------
/**
 * @brief   Ăяo֐ z֐
 * @param   p_gman       Q[}l[W[NX
 * @return  GMEVENT_RESULT  Cxg֐̖߂l
 */
//--------------------------------------------------------------
gamesystem::GMEVENT_RESULT EventDebugMenu::MainFunc(gamesystem::GameManager* p_gman)
{
	gfl::core::Debug::PrintConsole( "main event debug\n" );
  switch( m_Seq )
  {
    case 0 :
		MainProc::GetMainProc()->GetDebugMenu()->AddMenu();
      m_Seq++;
      break;

    case 1 :
      if( gfl::debug::DebugWin_IsOpen() == false )
      {
        MainProc::GetMainProc()->GetDebugMenu()->ClearEvent();
        MainProc::GetMainProc()->GetDebugMenu()->RemoveMenu();
        return gamesystem::GMEVENT_RES_FINISH;
	  }
      break;
  }

  return gamesystem::GMEVENT_RES_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Ăяo֐ z֐
 * @param   p_gman       Q[}l[W[NX
 */
//--------------------------------------------------------------
void EventDebugMenu::EndFunc(gamesystem::GameManager* p_gman )
{
  GFL_UNUSED( p_gman );
}

}

#endif
