//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		poke_tool_PokeMemory.cpp
 *	@brief  |P̋LAZbgE擾NX
 *	@author	Toru=Nagihashi
 *	@date		2012.08.03
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <savedata/MyStatus.h>
#include <system/gfl_use.h>
#include <poke_tool/poke_tool_PokeMemory.h>

#include "pokemon_memory.cdat"

#include <arc/message.gaix>
#include <message/msg_pokemon_memory.h>
#include <pm_version.h>

GFL_NAMESPACE_BEGIN(poke_tool)

//---------------------------------------------------------------------------------
// ݒ
//---------------------------------------------------------------------------------
/**
 * @brief LZbg
 *
 * @param event Cxgԍ(pokemon_memory,hɂenum Event)
 * @param data  f[^iCxgԍɂĂ̂قȂj
 * @param core_param  Zbg|P
 * @param mystatus  ̃Xe[^Xieʗpj
 */
void PokeMemory::Set( Event event, int data, pml::pokepara::CoreParam * core_param, const savedata::MyStatus *mystatus )
{
  if( mystatus->IsMyPokemon( *core_param ) )
  {
    //e
    PokeMemory::SetCore( core_param, pml::pokepara::MEMORIES_CODE_WITH_PARENT, pml::pokepara::MEMORIES_DATA_WITH_PARENT, pml::pokepara::MEMORIES_FEEL_WITH_PARENT, pml::pokepara::MEMORIES_LEVEL_WITH_PARENT, event, data );
  }
  else
  {
    //eȊO
    PokeMemory::SetCore( core_param, pml::pokepara::MEMORIES_CODE_WITH_OTHERS, pml::pokepara::MEMORIES_DATA_WITH_OTHERS, pml::pokepara::MEMORIES_FEEL_WITH_OTHERS, pml::pokepara::MEMORIES_LEVEL_WITH_OTHERS, event, data );
  }
}
//---------------------------------------------------------------------------------
// 擾
//---------------------------------------------------------------------------------
/**
 * @brief eƂ̋L擾
 * @param msg_data  bZ[Wf[^
 * @param core_param  L擾|P
 * @param heap  e|pq[v
 * @param strbuf  bZ[W󂯎
 * 
 * @note msgdata쐬Awordset쐬Awordseto^AexpandĂ܂B
 */
void PokeMemory::GetParentMemoryStrings( const pml::pokepara::CoreParam * core_param, gfl::heap::HeapBase *heap, gfl::str::StrBuf *strbuf )
{
  PokeMemory::GetStringsCore( core_param, NULL, heap, pml::pokepara::MEMORIES_CODE_WITH_PARENT, pml::pokepara::MEMORIES_DATA_WITH_PARENT, pml::pokepara::MEMORIES_FEEL_WITH_PARENT, pml::pokepara::MEMORIES_LEVEL_WITH_PARENT, strbuf );
}
/**
 * @brief eȊOƂ̋L擾
 *
 * @param msg_data  bZ[Wf[^
 * @param core_param  L擾|P
 * @param mystatus ̃Xe[^XiPo^pj
 * @param heap  e|pq[v
 * @param strbuf  bZ[W󂯎
 * 
 * @note msgdata쐬Awordset쐬Awordseto^AexpandĂ܂B
 */
void PokeMemory::GetOtherMemoryStrings( const pml::pokepara::CoreParam * core_param, const savedata::MyStatus *mystatus, gfl::heap::HeapBase *heap, gfl::str::StrBuf *strbuf )
{
  PokeMemory::GetStringsCore( core_param, mystatus, heap, pml::pokepara::MEMORIES_CODE_WITH_OTHERS, pml::pokepara::MEMORIES_DATA_WITH_OTHERS, pml::pokepara::MEMORIES_FEEL_WITH_OTHERS, pml::pokepara::MEMORIES_LEVEL_WITH_OTHERS, strbuf );
}

//---------------------------------------------------------------------------------
// PRIVATE
//---------------------------------------------------------------------------------
/**
 * @brief Zbg
 *
 * @param core_param  Zbg|P
 * @param code  R[h
 * @param data  f[^
 * @param feel  tB[
 * @param level x
 * @param new_event VCxg
 * @param new_data  Vf[^
 */
void PokeMemory::SetCore( pml::pokepara::CoreParam * core_param, pml::pokepara::Memories code, pml::pokepara::Memories data, pml::pokepara::Memories feel, pml::pokepara::Memories level, Event new_event, int new_data )
{
  GFL_ASSERT( EVENT_NONE < new_event && new_event < EVENT_MAX );

  u32 src_event = core_param->GetMemories( code );
  u32 src_level = core_param->GetMemories( level );
  u32 new_level = pokemon_memory_data[ new_event ].level;
  
  u32 happen = 1+xy_system::GflUse::GetPublicRand( 100 );
  u32 percent = pokemon_memory_data[ new_event ].percent;
  
  u32 src_rand = xy_system::GflUse::GetPublicRand( 256 );
  u32 new_rand = xy_system::GflUse::GetPublicRand( 256 );

  NAGI_PRINT( "LZbgNGXg\n" );
  NAGI_PRINT( "ÂL event=%d lv=%d\n", src_event, src_level );
  NAGI_PRINT( "VL event=%d lv=%d\n", new_event, new_level );

  //OK
  if( pokemon_memory_data[ new_event ].force == 1 )
  {
    NAGI_PRINT( "L̐ \n" );
    goto POKEMEMORY_SET_SUCCESS;
  }

  //VL̔`FbN
  if( !( percent >= happen ) )
  {
    NAGI_PRINT( "L̐s@ %d >= %d\n", percent, happen );
    return;
  }
  
  //Âvof[^HȂȂΊi[
  if( src_event == EVENT_NONE )
  {
    NAGI_PRINT( "L̐ ÂLȂ\n" );
    goto POKEMEMORY_SET_SUCCESS;
  }
  
  //YȂL`FbN
  if( src_level >= MEMORY_LEVEL_MAX )
  {
    NAGI_PRINT( "L̐s@YȂ" );
    return;
  }

  //voۃR[hH
  if( src_event == new_event )
  {
    NAGI_PRINT( "L̐ R[h\n" );
    return;
  }
  
  //ÂLƐVx`FbN
  if( src_level >  new_level + 1 )
  {
    NAGI_PRINT( "L̐ x`FbN\n" );
    return;
  }
  
  //ÂLƐVL̐킢
  
  NAGI_PRINT( "L̐ src r=%d l=%d new r=%d l=%d\n", src_rand, src_level, new_rand, new_level );
  if( src_level * src_rand
    < new_level * new_rand )
  {
    //VL̂ŃZbg
    goto POKEMEMORY_SET_SUCCESS;
  }
  else
  {
    //ÂL̉lȂ̂ŃxAbv
    if( ++src_level >= MEMORY_LEVEL_MAX )
    {
      src_level = MEMORY_LEVEL_MAX;
    }
    NAGI_PRINT( "L̐ ÂL@level=%d\n", src_level );
    core_param->SetMemories( level, src_level );
    return ;
  }
  
  //Zbg
POKEMEMORY_SET_SUCCESS:
  NAGI_PRINT( "L̐ VL\n" );
  
  //C𐶐
  u32 feel_num = 0;
  for( int i = 0; i < 32; ++i )
  {
    if( pokemon_memory_data[ new_event ].feel_bit & 1 << i )
    {
      ++feel_num;
    }
  }
  GFL_ASSERT( feel_num );
  
  u32 new_feel_index  = xy_system::GflUse::GetPublicRand( feel_num );
  u32 new_feel = 0;
  bool is_ok  = false;
  for( int i = 0; i < 32; ++i )
  {
    if( pokemon_memory_data[ new_event ].feel_bit & 1 << i )
    {
      if( i == new_feel_index )
      {
        new_feel  = i;
        is_ok = true;
      }
    }
  }
  
  GFL_ASSERT( is_ok );
  
  core_param->SetMemories( code, new_event );
  core_param->SetMemories( data, new_data );
  core_param->SetMemories( feel, new_feel );
  core_param->SetMemories( level, new_level );

}

/**
 * @brief 擾
 *
 * @param core_param  |P
 * @param mystatus  vC[iNULLŃ|PƂj
 * @param heap  q[v
 * @param code  ۃR[h擾
 * @param data  f[^擾
 * @param feel    tB[擾
 * @param level x擾
 * @param strbuf  󂯎
 */
void PokeMemory::GetStringsCore( const pml::pokepara::CoreParam * core_param, const savedata::MyStatus *mystatus, gfl::heap::HeapBase *heap, pml::pokepara::Memories code_idx, pml::pokepara::Memories data_idx, pml::pokepara::Memories feel_idx, pml::pokepara::Memories level_idx, gfl::str::StrBuf *strbuf )
{
  gfl::str::MsgData * msg_data = GFL_NEW(heap->GetLowerHandle()) gfl::str::MsgData( ARCID_MESSAGE, GARC_message_pokemon_memory_DAT, heap->GetLowerHandle() );
  WordSet * wordset = GFL_NEW(heap->GetLowerHandle()) WordSet( heap->GetLowerHandle() );
  
  gfl::str::StrBuf* temp  = GFL_NEW(heap->GetLowerHandle() ) gfl::str::StrBuf( 128, heap->GetLowerHandle() );
  
  //|P
  wordset->RegisterPokeNickName( 0, core_param );
  
  //vC[
  if( mystatus == NULL )
  {
    core_param->GetParentName( temp );
    wordset->RegisterWord( 1, *temp, WordSet::GRAMMER_NONE, WordSet::FORM_SINGLE, xy::GetLang() );
  }
  else
  {
    wordset->RegisterPlayerName( 1, mystatus );
  }
  
  //f[^
  u32 data = core_param->GetMemories( data_idx );
  u32 code = core_param->GetMemories( code_idx );
  switch( pokemon_memory_data[ code ].data_type )
  {	
  default:
  case DATA_TYPE_ZONE_NO: // ꏊ
    GFL_ASSERT(0);
  case DATA_TYPE_NONE:
    //ȂɂȂ
    break;
  case DATA_TYPE_ITEM_NO: // ACe
    wordset->RegisterItemName( 2, data );
    break;
  case DATA_TYPE_MONS_NO: // |P
    wordset->RegisterPokeMonsNameNo( 2, static_cast<MonsNo>(data) );
    break;
  case DATA_TYPE_SKILL_NO:// Z
    wordset->RegisterWazaName( 3, data );
    break;
    //@todoɂ񂶂
  }
  
  //C
  u32 feel = core_param->GetMemories( feel_idx );
  u32 feel_msg = POKEMEMORY_FEEL_01 + feel;
  if( feel_msg >= POKEMEMORY_FEEL_END )
  {
    feel_msg  = POKEMEMORY_FEEL_01;
  }
  msg_data->GetString( feel_msg , *temp );
  wordset->RegisterWord( 4, *temp, WordSet::GRAMMER_NONE, WordSet::FORM_SINGLE, xy::GetLang() );
  
  //ǂH
  u32 level = core_param->GetMemories( level_idx );
  u32 level_msg = POKEMEMORY_STR_01 + level;
  if( level_msg >= POKEMEMORY_STR_END )
  {
    level_msg = POKEMEMORY_STR_07;
  }
  msg_data->GetString( level_msg, *temp );
  wordset->RegisterWord( 5, *temp, WordSet::GRAMMER_NONE, WordSet::FORM_SINGLE, xy::GetLang() );
  
  u32 code_msg = POKEMEMORY_EVENT_00 + code;
  if( code_msg >= POKEMEMORY_EVENT_END )
  {
    code_msg = POKEMEMORY_EVENT_00;
  }
  msg_data->GetString( code_msg, *temp );
  wordset->Expand( strbuf, temp );

  GFL_DELETE temp;
  GFL_DELETE wordset;
  GFL_DELETE msg_data;
}

GFL_NAMESPACE_END(poke_tool)
