#if !defined( __PSS_PROFILE_MENU_BAR_H__ )
#define __PSS_PROFILE_MENU_BAR_H__
//============================================================================================
/**
 * @file		pss_profile_menu_bar.h
 * @brief   PSSvtB[j[o[pTuVIEWNX
 * @author	Hisanao Suzuki
 */
//============================================================================================
#pragma	once

#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>
#include <app/ui/UIPlayerIcon.h>

#include "PssProfileMenuBarListener.h"

namespace app {
namespace pss {
namespace pss_profile {


/**
 * @brief   PSSvtB[pVIEWNX
 */
class MenuBar : public app::ui::UIView, public app::ui::UIInputListener
{
public:
  /**
  * @brief CAEgID
  */
  typedef enum {
    PSS_PROFILE_LAYOUT_ID_BAR,
    PSS_PROFILE_LAYOUT_ID_MAX,
  }LAYOUT_ID;

private:
  /**
  * @brief {^ID
  */
  typedef enum
  {
    E_BUTTON_BACK,
    E_BUTTON_MY_ICON,
    E_BUTTON_CHECKMARK,
    //
    BUTTON_NUM
  }E_BUTTON_INDEX;

  /**
  * @brief {Aj
  */
  typedef enum
  {
    E_ANMID_CHECKMARK_OFF,
    E_ANMID_CHECKMARK_ON,
    //
    E_ANIME_BUTTON_RELEASE,
    E_ANIME_BUTTON_CANCEL,
    E_ANIME_BUTTON_TOUCH,
    E_ANIME_BUTTON_ACTIVE,
    E_ANIME_BUTTON_PASSIVE,
    //
    E_ANMID_MAX,
  }E_ANIME_ID;

  /**
  * @brief LAj
  */
  typedef enum
  {
    E_SHARE_ANIME_BUTTON_RELEASE = E_ANMID_MAX,
    E_SHARE_ANIME_BUTTON_CANCEL  = (E_SHARE_ANIME_BUTTON_RELEASE+BUTTON_NUM+PssProfileCategoryManager::FRAME_PANE_MAX+(PssProfileEnqueteFrameManager::FRAME_PANE_MAX*2)),
    E_SHARE_ANIME_BUTTON_TOUCH   = (E_SHARE_ANIME_BUTTON_CANCEL+BUTTON_NUM +PssProfileCategoryManager::FRAME_PANE_MAX+(PssProfileEnqueteFrameManager::FRAME_PANE_MAX*2)),
    E_SHARE_ANIME_BUTTON_ACTIVE  = (E_SHARE_ANIME_BUTTON_TOUCH+BUTTON_NUM  +PssProfileCategoryManager::FRAME_PANE_MAX+(PssProfileEnqueteFrameManager::FRAME_PANE_MAX*2)),
    E_SHARE_ANIME_BUTTON_PASSIVE = (E_SHARE_ANIME_BUTTON_ACTIVE+BUTTON_NUM +PssProfileCategoryManager::FRAME_PANE_MAX+(PssProfileEnqueteFrameManager::FRAME_PANE_MAX*2)),
    E_SHARE_ANMID_MAX            = (E_SHARE_ANIME_BUTTON_PASSIVE+BUTTON_NUM+PssProfileCategoryManager::FRAME_PANE_MAX+(PssProfileEnqueteFrameManager::FRAME_PANE_MAX*2)),
  }SHARE_ANIME_ID;

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		RXgN^
   *
   * @param   heap          q[v
   * @param   layout        ėp郌CAEgVXeiNULL̏ꍇ͐VKɍ쐬j
   * @param   isUpperFade   ʂMASKtF[hہitrueFMASKtF[h\Afalse:MASK\j
   * @param   playerIconMgr vC[ACR}l[W
   * @param   personal      ^[QbgL
   * @param   messageData   p郁bZ[Wf[^BNULLȂVK쐬
   * @param   wordset       p郏[hZbgBNULLȂVK쐬
   */
  //--------------------------------------------------------------------------------------------
  MenuBar( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout,
               xy_system::player_icon::PlayerIconManager* playerIconMgr,
               netapp::pss::PssPersonalData* personal, gfl::str::MsgData *messageData, WordSet *wordset );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		fXgN^
   */
  //--------------------------------------------------------------------------------------------
  virtual ~MenuBar(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   thCxgpXi̓o^
   *
   * @param   listener o^CxgXi
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetPssProfileMenuBarListener( PssProfileMenuBarListener* listener );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ACRI{^̗Lݒ
   *
   * @param   isEnableButton ACRI{^LtO
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetEnableIconButton( bool isEnableButton );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Cɓ`FbN}[N̐ݒ
   *
   * @param   isFavorite Cɓ`FbN̕ύX
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetFavoriteCheckMark( bool isFavorite );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ʉ̃j[o[XV
   *
   * @param   none
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void UpdateBottomMenuBar( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ʏ㕔̃j[o[̕\ݒ
   *
   * @param   isVisible \Ȃtruew
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetTopMenuVisible( bool isVisible );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ʏ㕔j[o[̍擾
   *
   * @return  ʏ㕔j[o[̍
   */
  //--------------------------------------------------------------------------------------------
  float GetTopMenuHeight( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ʉj[o[̍擾
   *
   * @return  ʉj[o[̍
   */
  //--------------------------------------------------------------------------------------------
  float GetBottomMenuHeight( void );

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		Abvf[g
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  virtual void Update(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		`
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  virtual void Draw(void);

public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);

private:

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   LN^[̐ݒ
   *
   * @param   name L
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetCharacterName( const gfl::str::STRCODE *name );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Aj[V̊Jn
   *
   * @param animeId Aj[VID
   */
  //--------------------------------------------------------------------------------------------
  void StartAnime( u32 animeId );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief		2D֘A쐬
  *
  * @param		heap		q[v
  *
  * @return	none
  */
  //--------------------------------------------------------------------------------------------
  void Initialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout, gfl::str::MsgData *messageData, WordSet *wordset );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ButtonManageȑ
   */
  //--------------------------------------------------------------------------------------------
  void InitButtonManager( app::util::Heap * heap );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief   vC[ACReNX`̐ݒ
  *
  * @param   layout        pCAEgVXeBNULLȂVK쐬
  * @param   playerIconMgr vC[ACR}l[W
  * @param   personal      l
  *
  * @return  none
  */
  //--------------------------------------------------------------------------------------------
  void SetPlayerIcon( app::util::Heap * heap, xy_system::player_icon::PlayerIconManager* playerIconMgr, netapp::pss::PssPersonalData* personal );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief   LAj̐
  *
  * @param   none
  */
  //--------------------------------------------------------------------------------------------
  void CreateShareAnime( void );

private:
  static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[E_ANMID_MAX];     //!< Aje[u
	static const app::ui::ButtonInfo        BUTTON_PANE_LIST[BUTTON_NUM];   //!< {^j[pyC
	//
	app::util::Heap*                m_heap;               //!< q[vGA
  app::ui::UIPlayerIcon*          m_playerIcon;         //!< vC[ACR
	PssProfileMenuBarListener*      m_uiListener;         //!< UICxgXi
	bool                            m_isEnableFavorite;   //!< Cɓ{^LtO
	bool                            m_isFavorite;         //!< Cɓ`FbN
};


}	// pss_profile
}	// pss
}	// app



#endif // __PSS_PROFILE_GRAPHIC_H__
