//============================================================================================
/**
 * @file		pss_profile_menu_bar.cpp
 * @brief		PSSvtB[j[o[pVIEWNX
 * @author  Hisanao Suzuki
 *
 */
//============================================================================================
#include "pss_profile_main.h"
#include "pss_profile_menu_bar.h"
#include "pss_profile_snd_def.h"
#include "pss_profile_res.h"
#include "pss_profile_res_pane.h"

#include <arc/arc_def.h>
#include <arc/fieldmenu_pss_tex.gaix>
#include <message/msg_pss_profile.h>
#include <message/message.gaix>

#include "category/PssProfileCategoryManager.h"
#include "category/PssProfileEnqueteCategory.h"
#include "enquete/PssProfileEnqueteFrameManager.h"

namespace app {
namespace pss {
namespace pss_profile {


//============================================================================================
//	萔`
//============================================================================================
//{^j[pyC
const app::ui::ButtonInfo MenuBar::BUTTON_PANE_LIST[MenuBar::BUTTON_NUM] =
{
  // ߂
  {
    PANENAME_PROFILE_BAR_LOWER_PANE_RETURN_ICON,    // picture_pane
    PANENAME_PROFILE_BAR_LOWER_PANE_BACK_BOUND,     // bound_pane
    MenuBar::E_SHARE_ANIME_BUTTON_TOUCH+0,                   // hold_anime_index
    MenuBar::E_SHARE_ANIME_BUTTON_CANCEL+0,                  // release_anime_index
    MenuBar::E_SHARE_ANIME_BUTTON_RELEASE+0,                 // select_anime_index
    MenuBar::E_SHARE_ANIME_BUTTON_ACTIVE+0,                  // active_anime_index
    MenuBar::E_SHARE_ANIME_BUTTON_PASSIVE+0,                 // passive_anime_index
  },
  // MYACR
  {
    PANENAME_PROFILE_BAR_LOWER_PANE_FACE1,          // picture_pane
    PANENAME_PROFILE_BAR_LOWER_PANE_MY_ICON,        // bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,       // hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // passive_anime_index
  },
  // `FbN}[N
  {
    PANENAME_PROFILE_BAR_LOWER_PANE_CHECKMARK,      // picture_pane
    PANENAME_PROFILE_BAR_LOWER_PANE_CHECK_BOUND,    // bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,       // hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,       // passive_anime_index
  },
};



// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex MenuBar::LowerAnmIndex[MenuBar::E_ANMID_MAX] =
{
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_CHECKMARK_01_BCLAN,
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_CHECKMARK_02_BCLAN,
  //
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_RELEASE_BCLAN,
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_CANSEL_BCLAN,
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_TOUCH_BCLAN,
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_ACTIVE_BCLAN,
  LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_PASSIVE_BCLAN,
};




//--------------------------------------------------------------------------------------------
/**
 * @brief   RXgN^
 *
 * @param   heap          q[v
 * @param   layout        ėp郌CAEgVXeiNULL̏ꍇ͐VKɍ쐬j
 * @param   playerIconMgr vC[ACR}l[W
 * @param   personal      ^[QbgL
 * @param   pssKind       ^[QbgL
 * @param   messageData    p郁bZ[Wf[^BNULLȂVK쐬
 * @param   wordset        p郏[hZbgBNULLȂVK쐬
 */
//--------------------------------------------------------------------------------------------
MenuBar::MenuBar( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout,
             xy_system::player_icon::PlayerIconManager* playerIconMgr,
             netapp::pss::PssPersonalData* personal, gfl::str::MsgData *messageData, WordSet *wordset ) :
             app::ui::UIView(heap,heap->pDevHeapAllocator,heap->pDevHeapAllocator)
{
  m_heap             = heap;
  m_uiListener       = NULL;
  m_isEnableFavorite = !personal->IsRelatonMe();  // głȂ΂Cɓo^\

  CreateGraphicsSystem( heap );
  Initialize2D( heap, layout, messageData, wordset );
  CreateShareAnime();
  InitButtonManager( heap );

  // Cɓ`FbN{bNX̏
  SetButtonEnable( PANENAME_PROFILE_BAR_LOWER_PANE_CHECK_BOUND, m_isEnableFavorite );

  // vC[
  SetCharacterName( personal->GetName() );
  SetPlayerIcon( heap, playerIconMgr, personal );

  UpdateBottomMenuBar();

  SetInputListener( this );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ButtonManageȑ
 */
//--------------------------------------------------------------------------------------------
void MenuBar::InitButtonManager( app::util::Heap * heap )
{
  u32 basePaneNum = sizeof(BUTTON_PANE_LIST) / sizeof(BUTTON_PANE_LIST[0]);

  CreateButtonManager( heap, GetLayoutWork(PSS_PROFILE_LAYOUT_ID_BAR), BUTTON_PANE_LIST, basePaneNum );

  // ߂{^SEݒ
  m_button_manager->SetButtonSelectSE( PANENAME_PROFILE_BAR_LOWER_PANE_RETURN_ICON, PSS_PROFILE_SE_CANCEL );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MenuBar::~MenuBar(void)
{
  if( m_playerIcon != NULL )
  {
    GFL_DELETE( m_playerIcon );
    m_playerIcon = NULL;
  }

	Delete2D();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   thCxgpXi̓o^
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::SetPssProfileMenuBarListener( PssProfileMenuBarListener* listener )
{
  m_uiListener = listener;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Cɓ`FbN}[N̐ݒ
 *
 * @param   isFavorite Cɓ`FbN̕ύX
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::SetFavoriteCheckMark( bool isFavorite )
{
  m_isFavorite = isFavorite;
  UpdateBottomMenuBar();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ACRI{^̗Lݒ
 *
 * @param   isEnableButton ACRI{^LtO
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::SetEnableIconButton( bool isEnableButton )
{
  m_g2dUtil->SetPaneVisible( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_PSS_ICON1, isEnableButton );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::Update(void)
{
  app::ui::UIView::Update();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::Draw(void)
{
  m_g2dUtil->Draw2D( m_graphicSystem, PSS_PROFILE_LAYOUT_ID_BAR );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   LAj̐
 *
 * @param   none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::CreateShareAnime( void )
{
  gfl::grp::g2d::LytWk* pLytWk = GetLayoutWork( PSS_PROFILE_LAYOUT_ID_BAR );
  u32 releaseAnimeNum = 0;
  u32 cancelAnimeNum  = 0;
  u32 touchAnimeNum   = 0;
  u32 activeAnimeNum  = 0;
  u32 passiveAnimeNum = 0;

  // {^pAj
  for( u32 i = 0; i < BUTTON_NUM; i++ )
  {
    gfl::grp::g2d::LytPaneIndex paneIdx = BUTTON_PANE_LIST[i].picture_pane;

    if( BUTTON_PANE_LIST[i].active_anime_index == app::tool::ButtonManager::ANIMATION_NULL )
    {
      releaseAnimeNum++;
      cancelAnimeNum++;
      touchAnimeNum++;
      activeAnimeNum++;
      passiveAnimeNum++;
      continue;
    }
    releaseAnimeNum += pLytWk->CreateShareAnime( E_SHARE_ANIME_BUTTON_RELEASE+i,
                                                 LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_RELEASE_BCLAN,
                                                 1, PANENAME_PROFILE_BAR_LOWER_GROUP_BUTTON_ANIME, paneIdx );
    cancelAnimeNum  += pLytWk->CreateShareAnime( E_SHARE_ANIME_BUTTON_CANCEL+i,
                                                 LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_CANSEL_BCLAN,
                                                 1, PANENAME_PROFILE_BAR_LOWER_GROUP_BUTTON_ANIME, paneIdx );
    touchAnimeNum   += pLytWk->CreateShareAnime( E_SHARE_ANIME_BUTTON_TOUCH+i,
                                                 LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_TOUCH_BCLAN,
                                                 1, PANENAME_PROFILE_BAR_LOWER_GROUP_BUTTON_ANIME, paneIdx );
    activeAnimeNum  += pLytWk->CreateShareAnime( E_SHARE_ANIME_BUTTON_ACTIVE+i,
                                                 LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_ACTIVE_BCLAN,
                                                 1, PANENAME_PROFILE_BAR_LOWER_GROUP_BUTTON_ANIME, paneIdx );
    passiveAnimeNum += pLytWk->CreateShareAnime( E_SHARE_ANIME_BUTTON_PASSIVE+i,
                                                 LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_RELEASE_BCLAN,
                                                 1, PANENAME_PROFILE_BAR_LOWER_GROUP_BUTTON_ANIME, paneIdx );
  }

  u32 totalAnimeNum = BUTTON_NUM;

  // check error!
  GFL_ASSERT( (releaseAnimeNum==totalAnimeNum) && (cancelAnimeNum==totalAnimeNum) && \
              (touchAnimeNum==totalAnimeNum) && (activeAnimeNum==totalAnimeNum) && (passiveAnimeNum==totalAnimeNum) );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ʏ㕔̃j[o[̕\ݒ
 *
 * @param   isVisible \Ȃtruew
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::SetTopMenuVisible( bool isVisible )
{
  m_g2dUtil->SetPaneVisible( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_TITLE_BG, isVisible );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ʏ㕔j[o[̍擾
 *
 * @return  ʏ㕔j[o[̍
 */
//--------------------------------------------------------------------------------------------
float MenuBar::GetTopMenuHeight( void )
{
  const nw::ut::Rect catRect   = m_g2dUtil->GetPaneRect( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_WINDOW_01_01 );
  return gfl::math::Abs(catRect.GetHeight());
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ʉj[o[̍擾
 *
 * @return  ʉj[o[̍
 */
//--------------------------------------------------------------------------------------------
float MenuBar::GetBottomMenuHeight( void )
{
  const nw::ut::Rect barRect   = m_g2dUtil->GetPaneRect( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_TOUCH_BAR );
  return gfl::math::Abs(barRect.GetHeight());
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ʉ̃j[o[XV
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::UpdateBottomMenuBar( void )
{
  m_g2dUtil->SetPaneVisible( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_CHECKMARK, m_isEnableFavorite );

  // Cɓ{^L
  if( m_isEnableFavorite )
  {
    StartAnime( m_isFavorite ? E_ANMID_CHECKMARK_ON : E_ANMID_CHECKMARK_OFF );

    SetTextboxPaneMessage( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_CHECK_TEXT,
                          m_isFavorite ? pss_profile_00_04 : pss_profile_00_03 );
  }
  // vC[g̏ꍇ
  else
  {
    SetTextboxPaneMessage( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_CHECK_TEXT, pss_profile_00_02 );
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   LN^[̐ݒ
 *
 * @param   name L
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::SetCharacterName( const gfl::str::STRCODE *name )
{
  SetTextboxPaneString( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_NAME_TEXT, name );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Aj[V̊Jn
 *
 * @param animeId Aj[VID
 */
//--------------------------------------------------------------------------------------------
void MenuBar::StartAnime( u32 animeId )
{
  m_g2dUtil->StopAnime( PSS_PROFILE_LAYOUT_ID_BAR, animeId, false);
  m_g2dUtil->StartAnime( PSS_PROFILE_LAYOUT_ID_BAR, animeId );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::Initialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout, gfl::str::MsgData *messageData, WordSet *wordset )
{
  // A[JCuIDe[u
  static const app::util::G2DUtil::LYT_RES_DATA resTbl[] = {
    { ARCID_PSS_PROFILE_GRA, 0, 0 }
  };

  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
    { // 
      0,
      LYTRES_PSS_PROFILE_RES_PROFILE_BAR_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      E_SHARE_ANMID_MAX,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
  };

  Create2D( heap, layout, PSS_PROFILE_LAYOUT_ID_MAX, resTbl, GFL_NELEMS(resTbl),
            layoutData, GFL_NELEMS(layoutData),  messageData, wordset );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   vC[ACReNX`̐ݒ
 *
 * @param   layout        pCAEgVXeBNULLȂVK쐬
 * @param   playerIconMgr vC[ACR}l[W
 * @param   personal      l
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MenuBar::SetPlayerIcon( app::util::Heap * heap, xy_system::player_icon::PlayerIconManager* playerIconMgr, netapp::pss::PssPersonalData* personal )
{
  m_playerIcon = GFL_NEW( heap->pHeap ) app::ui::UIPlayerIcon( heap->pHeap, heap->pDevHeap,
                                          this, playerIconMgr,
                                          PSS_PROFILE_LAYOUT_ID_BAR,
                                          PANENAME_PROFILE_BAR_LOWER_PANE_FACE1,
                                          LYTRES_PSS_PROFILE_RES_FACE1_BCLIM  );

  m_playerIcon->ReplacePlayerIconTexture( personal->GetIconID(), personal->GetFasshionInfo() );

  // vC[ACRwi
  m_g2dUtil->SetPaneVisible( PSS_PROFILE_LAYOUT_ID_BAR, PANENAME_PROFILE_BAR_LOWER_PANE_PSS_ICON1, !m_isEnableFavorite );
}


//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool MenuBar::OnLayoutPaneEvent( const u32 painId )
{
  switch( painId )
  {
    // ߂{^
    case  PANENAME_PROFILE_BAR_LOWER_PANE_RETURN_ICON:
      if( m_uiListener != NULL ){
        m_uiListener->OnMenuBarBackIconAction();
      }
      return false;

    // vC[ACR
    case  PANENAME_PROFILE_BAR_LOWER_PANE_FACE1:
      if( m_uiListener != NULL ){
        m_uiListener->OnMenuBarSelectedPlayerIconAction();
      }
      return false;

    // Cɓ{^
    case  PANENAME_PROFILE_BAR_LOWER_PANE_CHECKMARK:
      {
        m_isFavorite = !m_isFavorite;
        UpdateBottomMenuBar();

        if( m_uiListener != NULL ){
          m_uiListener->OnMenuBarSelectedFavoriteAction( m_isFavorite );
        }
      }
      return false;
  }

  return true;
}


//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool MenuBar::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  if( m_uiListener != NULL )
  {
    if( pKey->IsTrigger( gfl::ui::BUTTON_B ) )
    {
      m_button_manager->StartSelectedAct( PANENAME_PROFILE_BAR_LOWER_PANE_RETURN_ICON ); // {^Ƃɂ
      return false;
    }
  }
  return true;
}



}	// pss_profile
}	// pss
}	// app
