//============================================================================================
/**
 * @file		gts_panelist.h
 * @brief		yCXgiOEʁExwj
 * @author	Akito Mori
 * @date		12.08.02
 *
 * namespace	app::gts::
 *
 */
//============================================================================================
#if !defined( __GTS_PANELIST_H__ )
#define __GTS_PANELIST_H__

#include <pm_version.h>
#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include "app/tool/app_tool_panelist.h"

namespace netapp {
  namespace gts {

  class GtsPaneList : public app::tool::PaneList::CallBack
  {
    public:
    /// PANELIST[h
    enum LIST_MODE {
      LIST_POKENAME_TOPWORD,    ///< |Piqj
      LIST_POKENAME_2NDWORD,    ///< |Piꉹj
      LIST_POKENAME,            ///< |P
      LIST_SEX,                 ///< 
      LIST_LEVEL_BAND,          ///< xw
    };
    
    GtsPaneList( app::util::Heap *heap );
    ~GtsPaneList( void );
    void InitializePokeName( app::ui::UIView *uiview, 
                             int layoutId,
                             const app::tool::PaneList::PANE_DATA *paneList, 
                             int paneNum,
                             MonsNo *pokemon_list, 
                             u16 pokenum, 
                             gfl::str::MsgData *monsname_msg);
    void Initialize( app::ui::UIView *uiview, int layoutId, int list_mode, 
                     const app::tool::PaneList::PANE_DATA *paneList, int paneNum, 
                     int param, u16 *hitnum );
    u32  Update(void);
    u32  GetItemPos( void );
    int  GetPanelistNum( int list_type, int param=0 );

    const u32 *Get2ndWordTable();
    const u32 *GetTopWordTable();
    const u32 *GetSexTable();
    const u32 *GetLevelTable();
    int   GetSearchTopWord( int word_top, int word_2nd );

    private:
    /// PANELISTR[obN
    void CallBack_ItemChange( void * work, u32 pos1, u32 pos2 );
    void CallBack_ListWrite( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos );
    void CallBack_CursorOff( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos );
    void CallBack_CursorMove( void * work, const app::tool::PaneList::PANE_DATA * cur_pane, u32 pane_index, u32 pos );

    private:
    app::tool::PaneList *m_panelist;
    app::util::Heap     *m_heap;         ///< q[v
    int                 m_list_mode;     ///< Xg[h
    app::ui::UIView     *m_uiview; ;     ///< ĂяoUIVIEW|C^
    MonsNo              *m_pokemon_list; ///< |P̍ۂɎgpY|Pz
    u16                 m_pokenum;       ///< m_pokemon_list̑傫
    u16                 m_topword;       ///< Pڂ̎q
    gfl::str::MsgData   *m_monsname_msg; ///< |PbZ[Wf[^
    int                 m_layout_id;     ///< uiviewɓo^Ă郌CAEgf[^IDiPj
    u16                 *m_hit_table;
  };




  }	// gts
}	// netapp
#endif // __GTS_PANELIST_H__
