//============================================================================================
/**
 * @file    gts_panelist.cpp
 * @brief   GTSpyCXgi|PEʁExwj
 * @author  Akito Mori
 * @date    12.08.02
 *
 * namespace  app::gts::
 *
 */
//============================================================================================

#include "gts_panelist.h"

namespace netapp {
namespace gts {


static const u32 panelist_topword_tbl[]={
  msg_gts_02A_003,  // 
  msg_gts_02A_008,  // 
  msg_gts_02A_013,  // 
  msg_gts_02A_018,  // 
  msg_gts_02A_023,  // 
  msg_gts_02A_028,  // 
  msg_gts_02A_033,  // 
  msg_gts_02A_038,  // 
  msg_gts_02A_041,  // 
  msg_gts_02A_046,  // 
  msg_gts_02_007,   // ǂ
};

static const u32 panelist_2ndword_tbl[]={
  5, // 
  5, // 
  5, // 
  5, // 
  5, // 
  5, // 
  5, // 
  3, // 
  5, // 
  1, // 
  1, // iȂ)
};


static const u32 panelist_sex_tbl[]={
  msg_gts_02C_002,  // ɂȂ
  msg_gts_02C_003,  // 
  msg_gts_02C_004,  // 
  msg_gts_02_007,   // ǂ
};

static  const u32 panelist_level_tbl[]={
  msg_gts_02D_002,  // ɂȂ
  msg_gts_02D_003,  // P`PO
  msg_gts_02D_004,  // PP`QO
  msg_gts_02D_005,  // QP`RO
  msg_gts_02D_006,  // RP`SO
  msg_gts_02D_007,  // SP`TO
  msg_gts_02D_008,  // TP`UO
  msg_gts_02D_009,  // UP`VO
  msg_gts_02D_010,  // VP`WO
  msg_gts_02D_011,  // WP`XO
  msg_gts_02D_012,  // XP`
  msg_gts_02_007,   // ǂ
};


GtsPaneList::GtsPaneList( app::util::Heap * heap )
{
  m_heap = heap;
}

GtsPaneList::~GtsPaneList(void)
{
  GFL_DELETE m_panelist;
}

//=============================================================================================
/**
 * @brief	  yCXgi|PȊOj
 *
 * @param   heap		
 * @param   lytWk		
 * @param   list_mode		
 * @param   paneList		
 * @param   num		
 *
 * @retval  app::tool::PaneList *		
 */
//=============================================================================================
void GtsPaneList::Initialize( app::ui::UIView *uiview, int layoutId,
                              int list_mode, const app::tool::PaneList::PANE_DATA *paneList, int paneNum, 
                              int param, u16 *hit_table )
{
  app::tool::PaneList::SETUP_PARAM setupParam={
    m_heap->pHeap, uiview->GetLayoutWork( layoutId ),
    paneList,
    paneNum,
    
    11,                                     // ۂɎgp郊Xg̍ڐiyC̐ł͂Ȃj
    6,                                      // J[\͈́iʂɂ͂ݏo镔ۂɓ郊Xg̐j
    1,                                      // J[\ʒu ( 0 ` listPosMax-1 ͈̔ )
    0,                                      // XN[ʒu ( 0 ` valMax-listPosMax-1 ͈̔ )
                                            // ԉɃJ[\ʒuԂŎn߂̂ł΁AlistScroll+listpos
                                            // valMax-1ɂȂ悤ɂݒ肷B
    60.0,                                   // yC̃ftHgYW ( listPos = 0 ̈ʒũyCW )
                                            // ̍WŎw肵ꏊɂyC`JnʒũyCɂȂ
    150.0,                                  // yCXTCY(CAEgffB^[ŌɊmFj
    30.0,                                   // yCYTCY(CAEgffB^[ŌɊmFj

    -1.0,                                   // ̕\EiXg͂ݏoĂȂǂ̏ꍇ-1A
                                            // ʂɓĂꍇ0)
    app::tool::PaneList::PAGE_SKIP_NONE,    // y[WXLbv[h
    false,                                  // [vtO true = [v
    false,                                  // Lb`tO true = L
                                            
    SEQ_SE_SELECT1,                         // J[\ړSE
                                            
    this,                                   // R[obN֐
    NULL,                                 // R[obN֐ɓn[N
  };

  GFL_PRINT("ڐ=%d\n", setupParam.paneListMax);
  m_list_mode = list_mode;
  m_layout_id = layoutId;
  m_uiview    = uiview;
  m_topword   = param;    // iqj
  m_hit_table = hit_table;   // qbg
  setupParam.valMax = GetPanelistNum( list_mode, param );
  m_panelist  = GFL_NEW( m_heap->pHeap ) app::tool::PaneList( &setupParam );
//  return GFL_NEW( heap->pHeap ) app::tool::PaneList( &setupParam );
  
}

//=============================================================================================
/**
 * @brief	  |PIpXg
 *
 * @param   heap      
 * @param   lytWk     
 * @param   list_mode 
 * @param   paneList  
 * @param   num		
 *
 * @retval  app::tool::PaneList *		
 */
//=============================================================================================
void GtsPaneList::InitializePokeName( app::ui::UIView *uiview, int layoutId,
                                      const app::tool::PaneList::PANE_DATA *paneList, int paneNum,
                                      MonsNo *pokemon_list, u16 pokenum, gfl::str::MsgData *monsname_msg )
{
  app::tool::PaneList::SETUP_PARAM setupParam={
    m_heap->pHeap, uiview->GetLayoutWork( layoutId ),
    paneList,
    paneNum,
    
    11,                                     // ۂɎgp郊Xg̍ڐiyC̐ł͂Ȃj
    6,                                      // J[\͈́iʂɂ͂ݏo镔ۂɓ郊Xg̐j
    1,                                      // J[\ʒu ( 0 ` listPosMax-1 ͈̔ )
    0,                                      // XN[ʒu ( 0 ` valMax-listPosMax-1 ͈̔ )
                                            // ԉɃJ[\ʒuԂŎn߂̂ł΁AlistScroll+listpos
                                            // valMax-1ɂȂ悤ɂݒ肷B
    60.0,                                   // yC̃ftHgYW ( listPos = 0 ̈ʒũyCW )
                                            // ̍WŎw肵ꏊɂyC`JnʒũyCɂȂ
    150.0,                                  // yCXTCY(CAEgffB^[ŌɊmFj
    30.0,                                   // yCYTCY(CAEgffB^[ŌɊmFj

    -1.0,                                   // ̕\EiXg͂ݏoĂȂǂ̏ꍇ-1A
                                            // ʂɓĂꍇ0)
    app::tool::PaneList::PAGE_SKIP_NONE,    // y[WXLbv[h
    false,                                  // [vtO true = [v
    false,                                  // Lb`tO true = L
                                            
    SEQ_SE_SELECT1,                         // J[\ړSE
                                            
    this,                                   // R[obN֐
    NULL,                                   // R[obN֐ɓn[N
  };

  GFL_PRINT("ڐ=%d\n", setupParam.paneListMax);
  m_list_mode    = LIST_POKENAME;
  m_pokemon_list = pokemon_list;
  m_pokenum      = pokenum;
  m_layout_id    = layoutId;
  m_uiview       = uiview;
  m_monsname_msg = monsname_msg;
  setupParam.valMax = GetPanelistNum( m_list_mode );
  m_panelist = GFL_NEW( m_heap->pHeap ) app::tool::PaneList( &setupParam );
//  return GFL_NEW( heap->pHeap ) app::tool::PaneList( &setupParam );
  
}



int GtsPaneList::GetPanelistNum( int list_type, int param )
{
  int num;
  switch( list_type ){
  case LIST_POKENAME_TOPWORD:    // |Piqj
    return GFL_NELEMS( panelist_topword_tbl );
  case LIST_POKENAME_2NDWORD:    // |Piqj
    return panelist_2ndword_tbl[param];
  case LIST_POKENAME:            // |P
    return m_pokenum;
  case LIST_SEX:                 // 
    return GFL_NELEMS( panelist_sex_tbl );
  case LIST_LEVEL_BAND:          // xw
    return GFL_NELEMS( panelist_level_tbl );
  default:
    GFL_ASSERT(0);
  }

  return 0;
}

// XV
u32 GtsPaneList::Update(void)
{
  GFL_ASSERT( m_panelist );
  return m_panelist->Update();
}

// J[\ʒu擾
u32 GtsPaneList::GetItemPos( void )
{
  GFL_ASSERT( m_panelist );

  return m_panelist->GetItemPos();
}


//------------ PANELISTR[obN-----------------
//=============================================================================================
/**
 * @brief J[\ړ̃R[obN֐
 *
 * @param   work		
 * @param   pos1		
 * @param   pos2		
 */
//=============================================================================================
void GtsPaneList::CallBack_ItemChange( void * work, u32 pos1, u32 pos2 )
{
  
}
//=============================================================================================
/**
 * @brief J[\\ɂR[obN֐
 *
 * @param   work		
 * @param   pane		
 * @param   pane_index		
 * @param   pos		
 */
//=============================================================================================
void GtsPaneList::CallBack_ListWrite( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
 //
  switch(m_list_mode){
  case LIST_POKENAME_TOPWORD:
    m_uiview->SetTextboxPaneMessage( m_layout_id,
                                 pane[pane_index].text,
                                 panelist_topword_tbl[pos] );
    break;
  case LIST_POKENAME_2NDWORD:
    {
      app::util::G2DUtil *g2dUtil = m_uiview->GetG2DUtil();
      int wordpos = GetSearchTopWord( m_topword, 0 );
      m_uiview->SetTextboxPaneMessage( m_layout_id,
                                   pane[pane_index].text,
                                   panelist_topword_tbl[m_topword]+pos );

      if( m_hit_table[wordpos+pos]==0 ){
        gfl::grp::ColorU8 top( 100,100,100, 200 );
        gfl::grp::ColorU8 bottom( 50,50,50, 255 );
        g2dUtil->SetTextBoxPaneColor( m_layout_id, pane[pane_index].text, top, bottom );
      }else{
        gfl::grp::ColorU8 top( 0,0,0,255 );
        gfl::grp::ColorU8 bottom( 0,0,0,255 );
        g2dUtil->SetTextBoxPaneColor( m_layout_id, pane[pane_index].text, top, bottom );
      }

    }
    break;
  case LIST_POKENAME:
    {
      gfl::str::StrBuf *monsname = GFL_NEW_LOW( m_heap->pHeap ) gfl::str::StrBuf( pml::MONS_NAME_LENGTH+1, m_heap->pHeap );
      m_monsname_msg->GetString( m_pokemon_list[pos], *monsname );
      m_uiview->SetTextboxPaneString( m_layout_id,
                                    pane[pane_index].text,
                                    monsname );
      GFL_DELETE monsname;
    }
    break;
  case LIST_SEX:
    m_uiview->SetTextboxPaneMessage( m_layout_id,
                                   pane[pane_index].text,
                                   panelist_sex_tbl[pos] );
    break;
  case LIST_LEVEL_BAND:
    m_uiview->SetTextboxPaneMessage( m_layout_id,
                                   pane[pane_index].text,
                                   panelist_level_tbl[pos] );
    break;
  default:
    GFL_ASSERT(0);
    break;
  }
  
}

//=============================================================================================
/**
 * @brief Xg̍ڂ`悷R[obN֐
 *
 * @param   work		
 * @param   pane		
 * @param   pane_index		
 * @param   pos		
 */
//=============================================================================================
void GtsPaneList::CallBack_CursorOff( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
  
}
//=============================================================================================
/**
 * @brief ւpR[obN֐
 *
 * @param   work		
 * @param   cur_pane		
 * @param   pane_index		
 * @param   pos		
 */
//=============================================================================================
void GtsPaneList::CallBack_CursorMove( void * work, const app::tool::PaneList::PANE_DATA * cur_pane, u32 pane_index, u32 pos )
{
  
}


// ee[ũ|C^Ԃ
// q
const u32 *GtsPaneList::GetTopWordTable()
{
  return panelist_topword_tbl;

}
// ꉹ
const u32 *GtsPaneList::Get2ndWordTable()
{
  return panelist_2ndword_tbl;
}
// 
const u32 *GtsPaneList::GetSexTable()
{
  return panelist_sex_tbl;

}
// x
const u32 *GtsPaneList::GetLevelTable()
{
  return panelist_level_tbl;

}

// 擾
int GtsPaneList::GetSearchTopWord( int word_top, int word_2nd )
{
  int count=0, result;
  for(int i=0;i<word_top;i++){
    count += panelist_2ndword_tbl[i];
  }
  result = count + word_2nd;
  return result;
}


} // gts
} // netapp
