
#include "EditTimeSelect.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

//--------------------------------------------------------------------
EditTimeSelect::EditTimeSelect(EditLowerTopView* owner, int count) : 
m_owner(owner),
m_result(RESULT_NONE),
m_state(SCROLL_NONE),
m_second(count),
m_scroll_speed(0),
m_scroll_time(0),
m_local_cursor(0),
m_drag_flag(false)
{
  // XN[ۂ̕擾Ă
  app::util::G2DUtil* util = m_owner->GetG2DUtil();
  gfl::math::VEC3 pos1 = util->GetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_00);
  gfl::math::VEC3 pos2 = util->GetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_01);
  // 100 ̂͂
  m_scroll_width = pos2.x - pos1.x;
  
  // JeSI߂ĂǍ`łȂ炸Ib𒆉ɂ`ɂ邩A
  // 炩̕@m_local_cursor𕜌KvKvł
      gfl::math::VEC3 pos(0,0,0); pos.x = -1*m_second * m_scroll_width;
      util->SetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_POS, &pos);
  
  m_touch = GFL_NEW(m_owner->GetHeap()->pHeap) app::tool::TouchPanelOperator(
    m_owner->GetTouchPanel(),
    gamesystem::FRAMEMODE_30
  );
}

//--------------------------------------------------------------------
EditTimeSelect::~EditTimeSelect()
{
  GFL_DELETE m_touch;
}

//--------------------------------------------------------------------
void EditTimeSelect::Update()
{
  // ^b`
  m_touch->Update();
  
  if(m_touch->IsDecide() && m_state == SCROLL_NONE)
  {
  // Ă
    m_result = RESULT_TOUCHED;
    m_touch->GetDecideValue(&m_touched_pos);
  }
  else
  if(m_touch->IsDrag())
  {
  // hbOłȂ
    m_result = RESULT_NONE;
    
    gfl::math::VEC2 v1;
    gfl::math::VEC2 v2;
    m_touch->GetDragStartValue(&v1);
    if(!m_drag_flag)
    {
      m_drag_start_pos = v1;
      m_result = RESULT_DRAGING;//hack
      m_drag_flag = true;
    }
    m_touch->GetDragNowValue(&v2);
    if(v2.x - m_drag_start_pos.x > 15 )
    {
      this->ScrollLeft();
      m_drag_start_pos = v2;
    }
    else
    if(v2.x - m_drag_start_pos.x < -15)
    {
      this->ScrollRight();
      m_drag_start_pos = v2;
    }
  }
  else
  {
    m_result = RESULT_NONE;
    m_drag_flag = false;
  }
  
  // L[
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_RIGHT))
  {
    if(m_local_cursor == 1)
    {
      this->ScrollRight();
    }
    else if(m_second != 10)
    {
      ++m_local_cursor;
      m_owner->SetCursorPosCount(m_second + m_local_cursor);
    }
  }
  else
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_LEFT))
  {
    if(m_second == 10 || m_local_cursor == -1)
    {
      this->ScrollLeft();
    }
    else if(m_second != 0)
    {
      --m_local_cursor;
      m_owner->SetCursorPosCount(m_second + m_local_cursor);
    }
  }
  // XN[łȂ΃L[͂̃`FbNs
  switch(m_state)
  {
  case SCROLL_NONE:
    //else
    if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_A))
    {
      // {^ꂽ̂ŁAʂɌݎwĂbZbg
      m_result = (Result)(m_second+m_local_cursor);
    }
    else
    if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_B))
    {
      // LZ{^ꂽ
      m_result = (Result)RESULT_CANCEL;
    }
    break;
    
  case SCROLL_RIGHT:
  case SCROLL_LEFT:
    // XN[
    --m_scroll_time;
    
    if(m_scroll_time <= 0)
    {
      // ڕWbɃZbg
      app::util::G2DUtil* util = m_owner->GetG2DUtil();
      gfl::math::VEC3 pos(0,0,0); pos.x = -1*m_second * m_scroll_width;
      util->SetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_POS, &pos);
      
      m_state = SCROLL_NONE;
      m_scroll_speed = 0;
    }
    else
    {
      app::util::G2DUtil* util = m_owner->GetG2DUtil();
      gfl::math::VEC3 pos = util->GetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_00);
      pos.x += m_scroll_speed;
      util->SetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_POS, &pos);
    }
    break;
  }
}
//--------------------------------------------------------------------
void EditTimeSelect::ScrollLeft()
{
  if(m_second <= 1){return;}
  
  m_state = SCROLL_LEFT;
  --m_second;
  // 5t[œB
  m_scroll_time = 3;
  
  // 5t[œB邽߂ɒXs[h𒲐
  app::util::G2DUtil* util = m_owner->GetG2DUtil();
  gfl::math::VEC3 pos = util->GetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_00);
  float now_pos = pos.x;
  float target_pos = -1*m_second * m_scroll_width;
  m_scroll_speed = (target_pos - now_pos) / m_scroll_time;
}
void EditTimeSelect::ScrollRight()
{
  if(m_second >= 9){return;}
  
  m_state = SCROLL_RIGHT;
  ++m_second;
  // 5t[œB
  m_scroll_time = 3;
  
  // 5t[œB邽߂ɒXs[h𒲐
  app::util::G2DUtil* util = m_owner->GetG2DUtil();
  gfl::math::VEC3 pos = util->GetPanePos(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_00);
  float now_pos = pos.x;
  float target_pos = -1*m_second * m_scroll_width;
  m_scroll_speed = (target_pos - now_pos) / m_scroll_time;
}


GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)
