
#include "EditTimeBar.h"


#include "lyt/layout.h"
#include "lyt/layout_pane.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

//------------------------------------------------------------------------------
// con, des
//------------------------------------------------------------------------------
EditTimeBar::EditTimeBar( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout )
:
app::ui::UIView(heap),
m_heap(heap),
m_speed(0),
m_time(0),
m_pause(false),
m_pos(0),
m_pos_init(0),
m_width(0)
{
  gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
  m_graphicSystem = gm->GetGraphicsSystem();
  
  // CAEg{̂̍쐬
  this->CreateLayout(layout);
  
  // XN[ʒuL
  gfl::math::VEC3 v = m_g2dUtil->GetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS);
  m_pos_init = v.x;
  m_pos = m_pos_init;
  
  // XN[Xs[hۑ
  gfl::math::VEC3 v2 = m_g2dUtil->GetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_P_COUNT_01);
  //m_width = (v2.x - v.x);
  m_width = 50;
  m_speed = -1 * m_width / 30.0f;
  
  GFL_PRINT("m_pos_init = %d, m_width = %d, m_speed = %f\n", m_pos_init, m_width, m_speed);
}


EditTimeBar::~EditTimeBar()
{
  this->DeleteLayout();
}

//------------------------------------------------------------------------------
// Update, Draw
//------------------------------------------------------------------------------
void EditTimeBar::Update()
{
  //m_cursor->SetPos(m_g2dUtil->GetLayoutWork(0), PANENAME_P_VIDEO01_UPPER_PANE_COURSOL_POS);
  m_cursor->Update();
  UIView::Update();
  
  ++m_time;
  if(m_time == 10*30){m_pause = true;}
  
  if(m_pause){return;}
  
  m_pos += m_speed;
  
  // Aj[VGO
  gfl::math::VEC3 pos = m_g2dUtil->GetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS);
  pos.x += m_speed;
  m_g2dUtil->SetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS, &pos);
  
}

void EditTimeBar::Draw()
{
  m_g2dUtil->Draw2D(m_graphicSystem, 0);
  m_cursor->Draw(m_graphicSystem, gfl::grp::DISPLAY_UPPER);
}

//------------------------------------------------------------------------------
// ʒũZbgȂ
//------------------------------------------------------------------------------
void EditTimeBar::SetBGVisible(bool b)
{
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_UPPER_PANE_TITLE_BG, b);
}

void EditTimeBar::SetTimeVisible(bool b)
{
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS, b);
}

void EditTimeBar::SetTime(int time)
{
  m_time = time * 30;
  m_pause = true;
  
  m_pos = m_pos_init + m_speed * m_time;
  gfl::math::VEC3 pos = m_g2dUtil->GetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS);
  pos.x = m_pos;
  m_g2dUtil->SetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS, &pos);
}

void EditTimeBar::StartAutoScroll(int time)
{
  this->SetTime(time);
  m_pause = false;
}
void EditTimeBar::StartAutoScrollByFrame(int frame)
{
  m_time = frame;
  
  m_pos = m_pos_init + m_speed * m_time;
  gfl::math::VEC3 pos = m_g2dUtil->GetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS);
  pos.x = m_pos;
  m_g2dUtil->SetPanePos(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_POS, &pos);
  
  m_pause = false;
}

//------------------------------------------------------------------------------
// CAEg̍쐬E폜
//------------------------------------------------------------------------------
void EditTimeBar::CreateLayout(gfl::grp::g2d::LytSys* layout)
{
  static const app::util::G2DUtil::LYT_RES_DATA tbl[] = {
    { ARCID_PROMOTION,         0, LYTRES_MSG_WINDOW_RES_END, app::util::G2DUtil::ATTACH_ROOT },
  };
  static const gfl::grp::g2d::LytArcIndex anim[] = {
  };
  static const app::util::G2DUtil::LYTWK_DATA data[] = {
    {
      0,
      LYTRES_LAYOUT_P_VIDEO01_UPPER_BCLYT,
      anim,
      GFL_NELEMS(anim),
      GFL_NELEMS(anim),
      false,
      app::util::G2DUtil::SETUP_UPPER,
      true, // \ݒ
    },
  };
  
  // CAEg{̂̍쐬
  this->Create2D(
    m_heap,
    layout,
    GFL_NELEMS(data),
    tbl,
    GFL_NELEMS(tbl),
    data, GFL_NELEMS(data),
    NULL
  );
  
  // l̃Zbg
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_00, 0, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_01, 1, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_02, 2, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_03, 3, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_04, 4, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_05, 5, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_06, 6, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_07, 7, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_08, 8, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_09, 9, 2);
  m_g2dUtil->SetTextBoxPaneNumber(0, PANENAME_P_VIDEO01_UPPER_PANE_COUNT_TEXT_10, 10, 2);
  
  // J[\̍쐬
  m_cursor = GFL_NEW(m_heap->pHeap) app::tool::MenuCursor(m_g2dUtil->GetLayoutSystem());
  m_cursor->LoadLayoutResource(m_heap->pHeap, m_heap->pDevHeapAllocator);
  static const gfl::grp::g2d::LytWkSetUp CURSOR_SETUP = {
    gfl::math::VEC3( 0, -100, 0 ), // pos
    gfl::math::VEC2( 1, 1 ), // scale
    gfl::math::VEC3( 0, 0, 0 ), // rotate
    1, // priority
  };
  m_cursor->CreateLayoutWork(&CURSOR_SETUP, false);
  
  UIView::Update();
  UIView::Update();
  UIView::Update();
  
  // J[\̓Aʒu0bڂɃZbg
  m_cursor->SetVisible(true);
  m_cursor->StartAnime(gamesystem::FRAMEMODE_30);
  m_cursor->SetSize(30,30);
  
}

void EditTimeBar::DeleteLayout()
{
  m_cursor->DeleteLayoutWork();
  m_cursor->ReleaseLayoutResource();
  GFL_DELETE m_cursor;
  this->Delete2D();
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

