
#include "EditSceneTest.h"
#include "Scene.h"
#include "Main.h"
#include "arc/promoeffect.gaix"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

static const Edit s_modeltype[] = 
{
  {
    L"lf",
    MODEL_TRAINER
  },
  {
    L"|Pf",
    MODEL_POKEMODEL
  },
};

static const Edit s_motion[] = 
{
  {
    L"BA01_TOUJYOU01",
    TRMOT_OTHER_BA01_TOUJYOU01
  },
  {
    L"BA40_POSE01",
    TRMOT_OTHER_BA40_POSE01
  },
  {
    L"BA55_VIDEOLOOP01",
    TRMOT_OTHER_BA55_VIDEOLOOP01
  },
  {
    L"BA55_VIDEOWAIT01",
    TRMOT_OTHER_BA55_VIDEOWAIT01
  },
  {
    L"BA55_VIDEOPOSE01ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA01
  },
  {
    L"BA55_VIDEOPOSE01[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB01
  },
  {
    L"BA55_VIDEOPOSE02ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA02
  },
  {
    L"BA55_VIDEOPOSE02[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB02
  },
  {
    L"BA55_VIDEOPOSE03ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA03
  },
  {
    L"BA55_VIDEOPOSE03[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB03
  },
  {
    L"BA55_VIDEOPOSE04ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA04
  },
  {
    L"BA55_VIDEOPOSE04[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB04
  },
  {
    L"BA55_VIDEOPOSE05ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA05
  },
  {
    L"BA55_VIDEOPOSE05[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB05
  },
  {
    L"BA55_VIDEOPOSE06ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA06
  },
  {
    L"BA55_VIDEOPOSE06[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB06
  },
  {
    L"BA55_VIDEOPOSE07ꎮ",
    TRMOT_OTHER_BA55_VIDEOPOSEA07
  },
  {
    L"BA55_VIDEOPOSE07[v",
    TRMOT_OTHER_BA55_VIDEOPOSEB07
  },
  
  {
    L"MODEL_ANIME_KW_WAIT",
    poke_tool::MODEL_ANIME_KW_WAIT
  },
  {
    L"MODEL_ANIME_RESPOND",
    poke_tool::MODEL_ANIME_RESPOND
  },
  {
    L"MODEL_ANIME_TURN_A",
    poke_tool::MODEL_ANIME_TURN_A
  },
  {
    L"MODEL_ANIME_TURN_B",
    poke_tool::MODEL_ANIME_TURN_B
  },
  {
    L"MODEL_ANIME_DROWSE_A",
    poke_tool::MODEL_ANIME_DROWSE_A
  },
  {
    L"MODEL_ANIME_DROWSE_B",
    poke_tool::MODEL_ANIME_DROWSE_B
  },
  {
    L"MODEL_ANIME_DROWSE_C",
    poke_tool::MODEL_ANIME_DROWSE_C
  },
  {
    L"MODEL_ANIME_SLEEP_A",
    poke_tool::MODEL_ANIME_SLEEP_A
  },
  {
    L"MODEL_ANIME_SLEEP_B",
    poke_tool::MODEL_ANIME_SLEEP_B
  },
  {
    L"MODEL_ANIME_HATE",
    poke_tool::MODEL_ANIME_HATE
  },
  {
    L"MODEL_ANIME_QUESTION",
    poke_tool::MODEL_ANIME_QUESTION
  },
  {
    L"MODEL_ANIME_HAPPY_A",
    poke_tool::MODEL_ANIME_HAPPY_A
  },
  {
    L"MODEL_ANIME_HAPPY_B",
    poke_tool::MODEL_ANIME_HAPPY_B
  },
  {
    L"MODEL_ANIME_HAPPY_C",
    poke_tool::MODEL_ANIME_HAPPY_C
  },
  {
    L"MODEL_ANIME_MOVE_A",
    poke_tool::MODEL_ANIME_MOVE_A
  },
  {
    L"MODEL_ANIME_MOVE_B",
    poke_tool::MODEL_ANIME_MOVE_B
  },
  {
    L"MODEL_ANIME_MOVE_C",
    poke_tool::MODEL_ANIME_MOVE_C
  },
  {
    L"MODEL_ANIME_MOVE_D",
    poke_tool::MODEL_ANIME_MOVE_D
  },
  {
    L"MODEL_ANIME_LONELY",
    poke_tool::MODEL_ANIME_LONELY
  },
  {
    L"MODEL_ANIME_PLAY_A",
    poke_tool::MODEL_ANIME_PLAY_A
  },
  {
    L"MODEL_ANIME_PLAY_B",
    poke_tool::MODEL_ANIME_PLAY_B
  },
  {
    L"MODEL_ANIME_MAD",
    poke_tool::MODEL_ANIME_MAD
  },
  {
    L"MODEL_ANIME_EAT_A",
    poke_tool::MODEL_ANIME_EAT_A
  },
  {
    L"MODEL_ANIME_EAT_B",
    poke_tool::MODEL_ANIME_EAT_B
  },
  {
    L"MODEL_ANIME_EAT_C",
    poke_tool::MODEL_ANIME_EAT_C
  },
  {
    L"MODEL_ANIME_TOUCH",
    poke_tool::MODEL_ANIME_TOUCH
  },
};

static const Edit s_rotate[] = 
{
  {
    L"ʌ",
    ROTATE_FIXED_FRONT
  },
  {
    L"",
    ROTATE_FIXED_LEFT
  },
  {
    L"E",
    ROTATE_FIXED_RIGHT
  },
  {
    L"",
    ROTATE_FIXED_BACK
  },
  {
    L"Eɉ葱",
    ROTATE_LEFT
  },
  {
    L"ɉ葱",
    ROTATE_RIGHT
  },
};
static const Edit s_eye[] = 
{
  {
    L"",
    TRPARTMOT_EYE_EYE01_FRONT
  },
  {
    L"ʔ",
    TRPARTMOT_EYE_EYE01_HALF
  },
  {
    L"",
    TRPARTMOT_EYE_EYE01_CLOSE
  },
  {
    L"Ă",
    TRPARTMOT_EYE_EYE01_UP
  },
  {
    L"Ă",
    TRPARTMOT_EYE_EYE01_DOWN
  },
  {
    L"EĂ",
    TRPARTMOT_EYE_EYE01_RIGHT
  },
  {
    L"Ă",
    TRPARTMOT_EYE_EYE01_LEFT
  },
  {
    L"X}C",
    TRPARTMOT_EYE_EYE01_SMILE
  },
  {
    L"_ɏu",
    TRPARTMOT_EYE_EYEMOT01_BLINK
  },
};
static const Edit s_mouth[] = {
  {
    L"ftHg",
    TRPARTMOT_MOUTH_MOUTH01_DEFAULT_CLOSE
  },
  {
    L"ftHgJ",
    TRPARTMOT_MOUTH_MOUTH01_DEFAULT_HALF
  },
  {
    L"ftHgSJ",
    TRPARTMOT_MOUTH_MOUTH01_DEFAULT_FULL
  },
  {
    L"lKeBu",
    TRPARTMOT_MOUTH_MOUTH01_NEGATIVE_CLOSE
  },
  {
    L"lKeBuJ",
    TRPARTMOT_MOUTH_MOUTH01_NEGATIVE_HALF
  },
  {
    L"lKeBuSJ",
    TRPARTMOT_MOUTH_MOUTH01_NEGATIVE_FULL
  },
  {
    L"lKeBu",
    TRPARTMOT_MOUTH_MOUTH01_NEGATIVE_TEETH
  },
  {
    L"|WeBu",
    TRPARTMOT_MOUTH_MOUTH01_POSITIVE_CLOSE
  },
  {
    L"|WeBuJ",
    TRPARTMOT_MOUTH_MOUTH01_POSITIVE_HALF
  },
  {
    L"|WeBuSJ",
    TRPARTMOT_MOUTH_MOUTH01_POSITIVE_FULL
  },
  {
    L"|WeBu",
    TRPARTMOT_MOUTH_MOUTH01_POSITIVE_TEETH
  },
  {
    L"ւ̎",
    TRPARTMOT_MOUTH_MOUTH01_HENOJI
  },
  {
    L"J",
    TRPARTMOT_MOUTH_MOUTH01_AMAZED
  },
  {
    L"ftHgׂ",
    TRPARTMOT_MOUTH_MOUTHMOT01_TALK
  },
  {
    L"sɂׂ",
    TRPARTMOT_MOUTH_MOUTHMOT02_TALK
  },
  {
    L"Ȃׂ",
    TRPARTMOT_MOUTH_MOUTHMOT03_TALK
  },
};
static const Edit s_bgm[] = {
  {
    L"STRM_BGM_PVD_01",
    0
  },
  {
    L"STRM_BGM_PVD_02",
    1
  },
  {
    L"STRM_BGM_PVD_03",
    2
  },
};

static const Edit s_se[] = {
  {
    L"SEQ_SE_PVD_001",
    0
  },
  {
    L"SEQ_SE_PVD_002",
    1
  },
  {
    L"SEQ_SE_PVD_003",
    2
  },
  {
    L"SEQ_SE_PVD_004",
    3
  },
  {
    L"SEQ_SE_PVD_005",
    4
  },
  {
    L"SEQ_SE_PVD_006",
    5
  },
  {
    L"SEQ_SE_PVD_007",
    6
  },
  {
    L"SEQ_SE_PVD_008",
    7
  },
  {
    L"SEQ_SE_PVD_009",
    8
  },
  {
    L"SEQ_SE_PVD_010",
    9
  },
  {
    L"SEQ_SE_PVD_011",
    10
  },
  {
    L"SEQ_SE_PVD_012",
    11
  },
  {
    L"SEQ_SE_PVD_013",
    12
  },
  {
    L"SEQ_SE_PVD_014",
    13
  },
  {
    L"SEQ_SE_PVD_015",
    14
  },
  {
    L"SEQ_SE_PVD_016",
    15
  },
  {
    L"SEQ_SE_PVD_017",
    16
  },
  {
    L"SEQ_SE_PVD_018",
    17
  },
  {
    L"SEQ_SE_PVD_019",
    18
  },
  {
    L"SEQ_SE_PVD_020",
    19
  },
  {
    L"SEQ_SE_PVD_021",
    20
  },
  {
    L"SEQ_SE_PVD_022",
    21
  },
  {
    L"SEQ_SE_PVD_023",
    22
  },
  {
    L"SEQ_SE_PVD_024",
    23
  },
  {
    L"SEQ_SE_PVD_025",
    24
  },
  {
    L"SEQ_SE_PVD_026",
    25
  },
  {
    L"SEQ_SE_PVD_027",
    26
  },
  {
    L"SEQ_SE_PVD_028",
    27
  },
  {
    L"SEQ_SE_PVD_029",
    28
  },
  {
    L"SEQ_SE_PVD_030",
    29
  },
};

static const Edit s_camera[] = 
{
  {
    L"_videopose01_BCCAM",
    GARC_promotion_cam_ba55_videopose01_BCCAM
  },
  {
    L"_videopose02_BCCAM",
    GARC_promotion_cam_ba55_videopose02_BCCAM
  },
  {
    L"_videopose03_BCCAM",
    GARC_promotion_cam_ba55_videopose03_BCCAM
  },
  {
    L"_videopose04_BCCAM",
    GARC_promotion_cam_ba55_videopose04_BCCAM
  },
};
/*
static const Edit s_text[] = 
{
  {
    L"",
    TELOP_TEXT_HIDE
  },
  {
    L"w҂̃g[i[x",
    TELOP_TEXT_KITAI
  },
  {
    L"w̖x",
    TELOP_TEXT_SONONAMO
  },
  {
    L"w̉낵ˁx",
    TELOP_TEXT_YOROSHIKU
  },
  {
    L"w}WŁIx",
    TELOP_TEXT_MAJIDE
  },
};
*/
static const Edit s_text[] = 
{
  {
    L"",
    0
  },
  {
    L"w҂̃g[i[x",
    1
  },
  {
    L"w̖x",
    2
  },
  {
    L"w̉낵ˁx",
    3
  },
  {
    L"w}WŁIx",
    4
  },
};
static const Edit s_text_anime[] = 
{
  {
    L"XN[",
    TELOP_ANIME_TOP,
  },
  {
    L"]",
    TELOP_ANIME_BOTTOM,
  },
  {
    L"O",
    TELOP_ANIME_COME,
  },
};
/*
static const Edit s_text_pos[] = 
{
  {
    L"",
    TELOP_POS_CENTER
  },
  {
    L"",
    TELOP_POS_LEFT
  },
  {
    L"E",
    TELOP_POS_RIGHT
  },
  {
    L"",
    TELOP_POS_TOP
  },
  {
    L"",
    TELOP_POS_TOP | TELOP_POS_LEFT
  },
  {
    L"E",
    TELOP_POS_TOP | TELOP_POS_RIGHT
  },
  {
    L"",
    TELOP_POS_BOTTOM
  },
  {
    L"",
    TELOP_POS_BOTTOM | TELOP_POS_LEFT
  },
  {
    L"E",
    TELOP_POS_BOTTOM | TELOP_POS_RIGHT
  },
};
*/

static const Edit s_bg[] = 
{
  {
    L"bg001()",
    GARC_promotion_bg001_BCTEX
  },
  {
    L"bg002()",
    GARC_promotion_bg002_BCTEX
  },
  {
    L"bg003(/)",
    GARC_promotion_bg003_BCTEX
  },
};

static const Edit s_blightness[] = 
{
  {
    L"ӂ",
    BG_BLIGHTNESS_MAX
  },
  {
    L"₭",
    BG_BLIGHTNESS_HIGH
  },
  {
    L"炢",
    BG_BLIGHTNESS_MIDDLE
  },
  {
    L"قڂ",
    BG_BLIGHTNESS_LOW
  },
  {
    L"܂",
    BG_BLIGHTNESS_MIN
  },
};

#define TMP(x) {L###x,x},
static const Edit s_particle[] = 
{
  TMP(GARC_wazaeff_particle_ea002_BCPTL)
  TMP(GARC_wazaeff_particle_ea004_BCPTL)
  TMP(GARC_wazaeff_particle_es007_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es010_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ew097_at_ca_wind01_BCPTL)
};
#undef TMP

int findIndex(int id, const Edit* table, int length)
{
  for(int i = 0; i < length; ++i)
  {
    if(id == table[i].id){return i;}
  }
  return -1;
}
wchar_t* findText(int id, const Edit* table, int length)
{
  if(id == -1){return L"-";}
  for(int i = 0; i < length; ++i)
  {
    if(id == table[i].id){return table[i].text;}
  }
  return L"error";
}
void EditTestScene::Enter()
{
  m_second = 0;
  m_cursor = CURSOR_MIN;
}

bool EditTestScene::Update()
{
  if(m_owner->GetButton()->IsTrigger(gfl::ui::BUTTON_X))
  {
    this->RandomRecord(m_second);
  }
  if(m_owner->GetButton()->IsTrigger(gfl::ui::BUTTON_Y))
  {
    this->ClearRecord(m_second);
  }
  
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_UP))
  {
    --m_cursor;
    if(m_cursor < CURSOR_MIN){m_cursor = CURSOR_MAX;}
  }
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_DOWN))
  {
    ++m_cursor;
    if(m_cursor > CURSOR_MAX){m_cursor = CURSOR_MIN;}
  }
  
  // b𑀍
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_L))
  {
    --m_second;
    if(m_second < 0){m_second = 0;}
  }
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_R))
  {
    ++m_second;
    if(m_second == RECORD_SIZE){m_second = RECORD_SIZE-1;}
  }
  switch(m_cursor)
  {
  case CURSOR_SECOND:
    break;
    
  case CURSOR_MODELTYPE:
  case CURSOR_MOTION:
  case CURSOR_ROTATION:
  case CURSOR_EYE:
  case CURSOR_MOUTH:
  case CURSOR_BGM:
  case CURSOR_SE:
  case CURSOR_CAMERA:
  case CURSOR_PARTICLE:
  case CURSOR_TEXT:
  case CURSOR_TEXT_ANIME:
  //case CURSOR_TEXT_POS:
  case CURSOR_BG:
  case CURSOR_BLIGHTNESS:
    {
      int index = this->GetIndexWithCursor(m_cursor);
      if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_LEFT))
      {
        --index;
        this->SetParamWithCursorAndIndex(m_cursor, index);
      }
      if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_RIGHT))
      {
        ++index;
        this->SetParamWithCursorAndIndex(m_cursor, index);
      }
      
    }
    break;
  }
  
  if(m_owner->GetButton()->IsTrigger(gfl::ui::BUTTON_B))
  {
    m_owner->SetNext<SelectScene>();
  }
  return true;
}

int EditTestScene::GetIndexWithCursor(int cursor)
{
  switch(cursor)
  {
  case CURSOR_MODELTYPE:
    return findIndex(m_owner->GetRecord()[m_second].model.model, s_modeltype, GFL_NELEMS(s_modeltype));
  case CURSOR_MOTION:
    return findIndex(m_owner->GetRecord()[m_second].model.motion, s_motion, GFL_NELEMS(s_motion));
  case CURSOR_ROTATION:
    return findIndex(m_owner->GetRecord()[m_second].model.rotation, s_rotate, GFL_NELEMS(s_rotate));
  case CURSOR_EYE:
    return findIndex(m_owner->GetRecord()[m_second].model.eye, s_eye, GFL_NELEMS(s_eye));
  case CURSOR_MOUTH:
    return findIndex(m_owner->GetRecord()[m_second].model.mouth, s_mouth, GFL_NELEMS(s_mouth));
  case CURSOR_BGM:
    return findIndex(m_owner->GetRecord()[m_second].bgm, s_bgm, GFL_NELEMS(s_bgm));
  case CURSOR_SE:
    return findIndex(m_owner->GetRecord()[m_second].se, s_se, GFL_NELEMS(s_se));
  case CURSOR_CAMERA:
    return findIndex(m_owner->GetRecord()[m_second].camera, s_camera, GFL_NELEMS(s_camera));
  case CURSOR_PARTICLE:
    return findIndex(m_owner->GetRecord()[m_second].particle, s_particle, GFL_NELEMS(s_particle));
  case CURSOR_TEXT:
    return findIndex(m_owner->GetRecord()[m_second].telop[0].text, s_text, GFL_NELEMS(s_text));
  case CURSOR_TEXT_ANIME:
    return findIndex(m_owner->GetRecord()[m_second].telop[0].effect, s_text_anime, GFL_NELEMS(s_text_anime));
  //case CURSOR_TEXT_POS:
  //  return findIndex(m_owner->GetRecord()[m_second].telop[0].pos, s_text_pos, GFL_NELEMS(s_text_pos));
  case CURSOR_BG:
    return findIndex(m_owner->GetRecord()[m_second].background.bg, s_bg, GFL_NELEMS(s_bg));
  case CURSOR_BLIGHTNESS:
    return findIndex(m_owner->GetRecord()[m_second].background.blightness, s_blightness, GFL_NELEMS(s_blightness));
  }
  GFL_ASSERT(1);
  return -1;
}

void EditTestScene::SetParamWithCursorAndIndex(int cursor, int index)
{
  int value = -1;
  switch(cursor)
  {
  case CURSOR_MODELTYPE:
    if(index >= (int)GFL_NELEMS(s_modeltype)){return;}
    if(index >= 0){value = s_modeltype[index].id;}
    m_owner->GetRecord()[m_second].model.model= value;
    break;
  case CURSOR_MOTION:
    if(index >= (int)GFL_NELEMS(s_motion)){return;}
    if(index >= 0){value = s_motion[index].id;}
    m_owner->GetRecord()[m_second].model.motion = value;
    break;
  case CURSOR_ROTATION:
    if(index >= (int)GFL_NELEMS(s_rotate)){return;}
    if(index >= 0){value = s_rotate[index].id;}
    m_owner->GetRecord()[m_second].model.rotation = value;
    break;
  case CURSOR_EYE:
    if(index >= (int)GFL_NELEMS(s_eye)){return;}
    if(index >= 0){value = s_eye[index].id;}
    m_owner->GetRecord()[m_second].model.eye = value;
    break;
  case CURSOR_MOUTH:
    if(index >= (int)GFL_NELEMS(s_mouth)){return;}
    if(index >= 0){value = s_mouth[index].id;}
    m_owner->GetRecord()[m_second].model.mouth = value;
    break;
  case CURSOR_BGM:
    if(index >= (int)GFL_NELEMS(s_bgm)){return;}
    if(index >= 0){value = s_bgm[index].id;}
    m_owner->GetRecord()[m_second].bgm = value;
    break;
  case CURSOR_SE:
    if(index >= (int)GFL_NELEMS(s_se)){return;}
    if(index >= 0){value = s_se[index].id;}
    m_owner->GetRecord()[m_second].se = value;
    break;
  case CURSOR_CAMERA:
    if(index >= (int)GFL_NELEMS(s_camera)){return;}
    if(index >= 0){value = s_camera[index].id;}
    m_owner->GetRecord()[m_second].camera = value;
    break;
  case CURSOR_PARTICLE:
    if(index >= (int)GFL_NELEMS(s_particle)){return;}
    if(index >= 0){value = s_particle[index].id;}
    m_owner->GetRecord()[m_second].particle = value;
    break;
  case CURSOR_TEXT:
    if(index >= (int)GFL_NELEMS(s_text)){return;}
    if(index >= 0){value = s_text[index].id;}
    m_owner->GetRecord()[m_second].telop[0].text = value;
    break;
  case CURSOR_TEXT_ANIME:
    if(index >= (int)GFL_NELEMS(s_text_anime)){return;}
    if(index >= 0){value = s_text_anime[index].id;}
    m_owner->GetRecord()[m_second].telop[0].effect = value;
    break;
    /*
  case CURSOR_TEXT_POS:
    if(index >= (int)GFL_NELEMS(s_text_pos)){return;}
    if(index >= 0){value = s_text_pos[index].id;}
    m_owner->GetRecord()[m_second].telop[0].pos = value;
    break;
    */
  case CURSOR_BG:
    if(index >= (int)GFL_NELEMS(s_bg)){return;}
    if(index >= 0){value = s_bg[index].id;}
    m_owner->GetRecord()[m_second].background.bg = value;
    break;
  case CURSOR_BLIGHTNESS:
    if(index >= (int)GFL_NELEMS(s_blightness)){return;}
    if(index >= 0){value = s_blightness[index].id;}
    m_owner->GetRecord()[m_second].background.blightness = value;
    break;
  }
  GFL_ASSERT(1);
}

void EditTestScene::Exit()
{
}

void EditTestScene::Draw()
{
  gfl::grp::util::DrawUtil::SetTextScale(0.4,0.4);
  
  gfl::grp::util::DrawUtil::DrawText(0, 0, L"<<< ҏWj[ >>>");
  gfl::grp::util::DrawUtil::DrawText(0, 20, L"@@[L] bOց@@@@bƂ[R]");
  
  Record rec = m_owner->GetRecord()[m_second];
  
  int y = 40; int y_add = 15;
  if(y+y_add * m_cursor > 215){y -= y+y_add * m_cursor - 215;}
  gfl::grp::util::DrawUtil::DrawText(0, y+15*m_cursor, L"r");
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@bF%d", m_second);
  y += y_add;
  
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@fށF%ls", findText(rec.model.model, s_modeltype, GFL_NELEMS(s_modeltype)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@f̃[VF%ls", findText(rec.model.motion, s_motion, GFL_NELEMS(s_motion)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@f̌@@@F%ls", findText(rec.model.rotation, s_rotate, GFL_NELEMS(s_rotate)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@ځ@@@@@@@@F%ls", findText(rec.model.eye, s_eye, GFL_NELEMS(s_eye)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@@@@@@@@@F%ls", findText(rec.model.mouth, s_mouth, GFL_NELEMS(s_mouth)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@afl@@@@@@F%ls", findText(rec.bgm, s_bgm, GFL_NELEMS(s_bgm)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@rd@@@@@@@F%ls", findText(rec.se, s_se, GFL_NELEMS(s_se)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@J@@@@@@F%ls", findText(rec.camera, s_camera, GFL_NELEMS(s_camera)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@p[eBN@@@F%ls", findText(rec.particle, s_particle, GFL_NELEMS(s_particle)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@ebveLXg@F%ls", findText(rec.telop[0].text, s_text, GFL_NELEMS(s_text)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@ebvAj@@F%ls", findText(rec.telop[0].effect, s_text_anime, GFL_NELEMS(s_text_anime)));
  //gfl::grp::util::DrawUtil::DrawText(0, y, L"@ebvʒu@@@F%ls", findText(rec.telop[0].pos, s_text_pos, GFL_NELEMS(s_text_pos)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@wi@@@@@@@F%ls", findText(rec.background.bg, s_bg, GFL_NELEMS(s_bg)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@wïÂ@@@@F%ls", findText(rec.background.blightness, s_blightness, GFL_NELEMS(s_blightness)));
  y += y_add;
}


void EditTestScene::ClearRecord(int sec)
{
  m_owner->GetRecord()[sec].model.model = -1;
  m_owner->GetRecord()[sec].model.motion = -1;
  m_owner->GetRecord()[sec].model.rotation = -1;
  m_owner->GetRecord()[sec].model.eye = -1;
  m_owner->GetRecord()[sec].model.mouth = -1;
  m_owner->GetRecord()[sec].background.bg = -1;
  m_owner->GetRecord()[sec].background.blightness = -1;
  m_owner->GetRecord()[sec].bgm = -1;
  m_owner->GetRecord()[sec].se = -1;
  m_owner->GetRecord()[sec].camera = -1;
  m_owner->GetRecord()[sec].particle = -1;
  m_owner->GetRecord()[sec].effect = -1;
  m_owner->GetRecord()[sec].telop[0].text = -1;
  m_owner->GetRecord()[sec].telop[0].effect = -1;
  m_owner->GetRecord()[sec].telop[1].text = -1;
  m_owner->GetRecord()[sec].telop[1].effect = -1;
}
void EditTestScene::ClearAll()
{
  for(int i = 0; i < RECORD_SIZE; ++i)
  {
    this->ClearRecord(i);
  }
}

void EditTestScene::RandomRecord(int sec)
{
  /*
  gfl::math::Random rnd;
  rnd.Initialize();
  SetParamWithCursorAndIndex(CURSOR_MOTION, rnd.Next(GFL_NELEMS(s_motion))-1);
  SetParamWithCursorAndIndex(CURSOR_ROTATION, rnd.Next(GFL_NELEMS(s_rotate))-1);
  SetParamWithCursorAndIndex(CURSOR_EYE, rnd.Next(GFL_NELEMS(s_eye))-1);
  SetParamWithCursorAndIndex(CURSOR_MOUTH, rnd.Next(GFL_NELEMS(s_mouth))-1);
  SetParamWithCursorAndIndex(CURSOR_BG, rnd.Next(GFL_NELEMS(s_bg))-1);
  SetParamWithCursorAndIndex(CURSOR_BLIGHTNESS, rnd.Next(GFL_NELEMS(s_blightness))-1);
  SetParamWithCursorAndIndex(CURSOR_BGM, rnd.Next(GFL_NELEMS(s_bgm))-1);
  SetParamWithCursorAndIndex(CURSOR_SE, rnd.Next(GFL_NELEMS(s_se))-1);
  SetParamWithCursorAndIndex(CURSOR_CAMERA, rnd.Next(GFL_NELEMS(s_camera))-1);
  SetParamWithCursorAndIndex(CURSOR_PARTICLE, rnd.Next(GFL_NELEMS(s_particle))-1);
  SetParamWithCursorAndIndex(CURSOR_TEXT, rnd.Next(GFL_NELEMS(s_text))-1);
  SetParamWithCursorAndIndex(CURSOR_TEXT_ANIME, rnd.Next(GFL_NELEMS(s_text_anime))-1);
  m_owner->GetRecord()[sec].model.model = -1;
  m_owner->GetRecord()[sec].effect = -1;
  m_owner->GetRecord()[sec].telop[0].pos = -1;
  */
}
void EditTestScene::RandomAll()
{
  for(int i = 0; i < RECORD_SIZE; ++i)
  {
    this->RandomRecord(i);
  }
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)
