//------------------------------------------------------------------------------
//  UĨgbv
//------------------------------------------------------------------------------
#ifndef __EDIT_LOWER_TOP_VIEW_H__
#define __EDIT_LOWER_TOP_VIEW_H__

#include <gflib.h>
#include "app/ui/UIView.h"
#include "app/tool/app_tool_MenuCursor.h"
#include "app/tool/app_tool_ButtonManager.h"
#include "app/tool/app_tool_CursorManager.h"
#include "app/ui/UITouchBarView.h"
#include "app/ui/UITouchBarListener.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

class Main;
class EditTimeSelect;

enum Category
{
  CATEGORY_NONE = -1,
  
  CATEGORY_BG = 0,
  CATEGORY_POSE,
  CATEGORY_FACE,
  CATEGORY_BGM,
  CATEGORY_SE,
  
  CATEGORY_MODEL,
  CATEGORY_EFFECT,
  CATEGORY_CAMERA,
  CATEGORY_TELOP,
  CATEGORY_DELETE,
};

class EditLowerTopView : public app::ui::UIView, public app::ui::UITouchBarListener
{
public:
  enum Result
  {
    RESULT_SELECTING_TIME = -100,
    RESULT_SELECTING_CATEGORY,
    RESULT_EXIT,
    RESULT_DECIDE = 0,
  };
  
public:
  EditLowerTopView( Main* main, app::util::Heap * heap, gfl::grp::g2d::LytSys* layout, gfl::ui::DeviceManager* device, Category category, int time);
  ~EditLowerTopView();
  
  virtual void Draw();
  virtual void Update();
  
  virtual bool OnSelectedButton(u32 buttonID);
  
  Result GetResult(){return m_result;}
  int GetSelectedTime(){return m_count;}
  
  //------------------------------------------------------------------
public:
  // JeSIEBhE̕\؂ւ
  void ShowCategoryMenu();
  void HideCategoryMenu();
  
  // bZ[W\
  void DispMessage(int msg_id);
  
  // J[\̈ʒuZbg // @todo protected̕悢H
  void SetCursorPos(int pane_id);
  void SetCursorPosCount(int index);
  
  
  //
  gfl::ui::Button* GetButton(){return m_device->GetButton(0);}
  gfl::ui::TouchPanel* GetTouchPanel(){return m_device->GetTouchPanel(0);}
  app::util::Heap* GetHeap(){return m_heap;}
private:
  // CAEg̍쐬
  void CreateLayout(  gfl::grp::g2d::LytSys* layout );
  // CAEg̍폜
  void DeleteLayout();
  
  // bZ[WEBhE̍쐬
  void CreateMessageWindow();
  void DeleteMessageWindow();
  
  // J[\
  void CreateTimeSelectCursor();
  void DeleteTimeSelectCursor();
  
  // J[\
  void CreateCategoryCursor();
  void DeleteCategoryCursor();
  
  // R[h̍폜
  void ClearRecord(int second);
  
  void UpdateCategoryCheck();
  
private:
  Main* m_main;
  gfl::ui::DeviceManager* m_device;
  app::util::Heap* m_heap;
  
  // ʎ擾p
  Result m_result;
  
  // ^b`o[
  app::ui::UITouchBarView* m_touch;
  
  // ԑIp
  int m_count;
  EditTimeSelect* m_time_select;
  
  // ԑIAJ[\\p
  app::tool::MenuCursor* m_cursor;
  
  // JeSIAJ[\p
  app::tool::ButtonManager* m_button_manager;
  app::tool::CursorManager* m_cursor_manager;
  
  enum State
  {
    STATE_TIME_SELECT,
    STATE_CATEGORY_SELECT,
  };
  
  State m_state;
  
  
public:
  // Aj`
  enum
  {
    ANIM_DUMMY_ACTIVE,
    ANIM_DUMMY_CANCEL,
    ANIM_DUMMY_PASSIVE,
    ANIM_DUMMY_RELEASE,
    ANIM_DUMMY_HOLD,
    ANIM_DUMMY_TOUCH,
    
    ANIM_EVENT01_ACTIVE,
    ANIM_EVENT01_CANCEL,
    ANIM_EVENT01_PASSIVE,
    ANIM_EVENT01_RELEASE,
    ANIM_EVENT01_HOLD,
    ANIM_EVENT01_TOUCH,
    
    ANIM_EVENT02_ACTIVE,
    ANIM_EVENT02_CANCEL,
    ANIM_EVENT02_PASSIVE,
    ANIM_EVENT02_RELEASE,
    ANIM_EVENT02_HOLD,
    ANIM_EVENT02_TOUCH,
    
    ANIM_EVENT03_ACTIVE,
    ANIM_EVENT03_CANCEL,
    ANIM_EVENT03_PASSIVE,
    ANIM_EVENT03_RELEASE,
    ANIM_EVENT03_HOLD,
    ANIM_EVENT03_TOUCH,
    
    ANIM_EVENT04_ACTIVE,
    ANIM_EVENT04_CANCEL,
    ANIM_EVENT04_PASSIVE,
    ANIM_EVENT04_RELEASE,
    ANIM_EVENT04_HOLD,
    ANIM_EVENT04_TOUCH,
    
    ANIM_EVENT05_ACTIVE,
    ANIM_EVENT05_CANCEL,
    ANIM_EVENT05_PASSIVE,
    ANIM_EVENT05_RELEASE,
    ANIM_EVENT05_HOLD,
    ANIM_EVENT05_TOUCH,
    
    ANIM_EVENT06_ACTIVE,
    ANIM_EVENT06_CANCEL,
    ANIM_EVENT06_PASSIVE,
    ANIM_EVENT06_RELEASE,
    ANIM_EVENT06_HOLD,
    ANIM_EVENT06_TOUCH,
    
    ANIM_EVENT07_ACTIVE,
    ANIM_EVENT07_CANCEL,
    ANIM_EVENT07_PASSIVE,
    ANIM_EVENT07_RELEASE,
    ANIM_EVENT07_HOLD,
    ANIM_EVENT07_TOUCH,
    
    ANIM_EVENT08_ACTIVE,
    ANIM_EVENT08_CANCEL,
    ANIM_EVENT08_PASSIVE,
    ANIM_EVENT08_RELEASE,
    ANIM_EVENT08_HOLD,
    ANIM_EVENT08_TOUCH,
    
    ANIM_EVENT09_ACTIVE,
    ANIM_EVENT09_CANCEL,
    ANIM_EVENT09_PASSIVE,
    ANIM_EVENT09_RELEASE,
    ANIM_EVENT09_HOLD,
    ANIM_EVENT09_TOUCH,
    
    ANIM_EVENT10_ACTIVE,
    ANIM_EVENT10_CANCEL,
    ANIM_EVENT10_PASSIVE,
    ANIM_EVENT10_RELEASE,
    ANIM_EVENT10_HOLD,
    ANIM_EVENT10_TOUCH,
  };
};
GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__EDIT_LOWER_TOP_VIEW_H__

