
#include "EditLowerTopView.h"
#include "common_res/msg_window_res.h"
#include "lyt/layout.h"
#include "lyt/layout_pane.h"
#include "message/msg_promo_video_system.h"

#include "EditTimeSelect.h"



GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)


static const int COUNT_PANE[] = 
{
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_00,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_01,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_02,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_03,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_04,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_05,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_06,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_07,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_08,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_09,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_10,
};
static const int COUNT_TEXT_PANE[] = 
{
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_00,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_01,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_02,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_03,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_04,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_05,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_06,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_07,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_08,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_09,
  PANENAME_P_VIDEO01_LOWER_PANE_COUNT_TEXT_10,
};
static const int CATEGORY_PANE[] = 
{
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_01,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_02,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_03,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_04,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_05,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_06,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_07,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_08,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_09,
  PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_10,
};

static const int CATEGORY_MESSAGE_ID[] = 
{
  pvd_make09,
  pvd_make94,
  pvd_make172,
  pvd_make30,
  pvd_make63,
  
  pvd_make200,
  pvd_make149,
  pvd_make204,
  pvd_make224,
  pvd_make199,
};

struct ButtonData
{
  int id;
  int pane_index;
  int hold_anime;
  int release_anime;
  int select_anime;
  /*
  int id;
  int pane_index;
  int hold_anime;
  int release_anime;
  int select_anime;
  */
};

static const ButtonData BUTTON_DATA[] = {
  {
    CATEGORY_BG,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_01,
    EditLowerTopView::ANIM_EVENT01_HOLD,
    EditLowerTopView::ANIM_EVENT01_RELEASE,
    EditLowerTopView::ANIM_EVENT01_TOUCH,
  },
  {
    CATEGORY_POSE,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_02,
    EditLowerTopView::ANIM_EVENT02_HOLD,
    EditLowerTopView::ANIM_EVENT02_RELEASE,
    EditLowerTopView::ANIM_EVENT02_TOUCH,
  },
  {
    CATEGORY_FACE,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_03,
    EditLowerTopView::ANIM_EVENT03_HOLD,
    EditLowerTopView::ANIM_EVENT03_RELEASE,
    EditLowerTopView::ANIM_EVENT03_TOUCH,
  },
  {
    CATEGORY_BGM,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_04,
    EditLowerTopView::ANIM_EVENT04_HOLD,
    EditLowerTopView::ANIM_EVENT04_RELEASE,
    EditLowerTopView::ANIM_EVENT04_TOUCH,
  },
  {
    CATEGORY_SE,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_05,
    EditLowerTopView::ANIM_EVENT05_HOLD,
    EditLowerTopView::ANIM_EVENT05_RELEASE,
    EditLowerTopView::ANIM_EVENT05_TOUCH,
  },
  {
    CATEGORY_MODEL,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_06,
    EditLowerTopView::ANIM_EVENT06_HOLD,
    EditLowerTopView::ANIM_EVENT06_RELEASE,
    EditLowerTopView::ANIM_EVENT06_TOUCH,
  },
  {
    CATEGORY_EFFECT,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_07,
    EditLowerTopView::ANIM_EVENT07_HOLD,
    EditLowerTopView::ANIM_EVENT07_RELEASE,
    EditLowerTopView::ANIM_EVENT07_TOUCH,
  },
  {
    CATEGORY_CAMERA,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_08,
    EditLowerTopView::ANIM_EVENT08_HOLD,
    EditLowerTopView::ANIM_EVENT08_RELEASE,
    EditLowerTopView::ANIM_EVENT08_TOUCH,
  },
  {
    CATEGORY_TELOP,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_09,
    EditLowerTopView::ANIM_EVENT09_HOLD,
    EditLowerTopView::ANIM_EVENT09_RELEASE,
    EditLowerTopView::ANIM_EVENT09_TOUCH,
  },
  {
    CATEGORY_DELETE,
    PANENAME_P_VIDEO01_LOWER_PANE_EVENT_ICON_10,
    EditLowerTopView::ANIM_EVENT10_HOLD,
    EditLowerTopView::ANIM_EVENT10_RELEASE,
    EditLowerTopView::ANIM_EVENT10_TOUCH,
  },
};


static const app::tool::CursorManager::MOVE_DATA CURSOR_DATA[] = {
  {
    CATEGORY_BG, //㉺Ȅ
    {CATEGORY_BG, CATEGORY_MODEL, CATEGORY_BG, CATEGORY_POSE}
  },
  {
    CATEGORY_POSE, //㉺Ȅ
    {CATEGORY_POSE, CATEGORY_EFFECT, CATEGORY_BG, CATEGORY_FACE}
  },
  {
    CATEGORY_FACE, //㉺Ȅ
    {CATEGORY_FACE, CATEGORY_CAMERA, CATEGORY_POSE, CATEGORY_BGM}
  },
  {
    CATEGORY_BGM, //㉺Ȅ
    {CATEGORY_BGM, CATEGORY_TELOP, CATEGORY_FACE, CATEGORY_SE}
  },
  {
    CATEGORY_SE, //㉺Ȅ
    {CATEGORY_SE, CATEGORY_DELETE, CATEGORY_BGM, CATEGORY_SE}
  },
  //
  {
    CATEGORY_MODEL, //㉺Ȅ
    {CATEGORY_BG, CATEGORY_MODEL, CATEGORY_MODEL, CATEGORY_EFFECT}
  },
  {
    CATEGORY_EFFECT, //㉺Ȅ
    {CATEGORY_POSE, CATEGORY_EFFECT, CATEGORY_MODEL, CATEGORY_CAMERA}
  },
  {
    CATEGORY_CAMERA, //㉺Ȅ
    {CATEGORY_FACE, CATEGORY_CAMERA, CATEGORY_EFFECT, CATEGORY_TELOP}
  },
  {
    CATEGORY_TELOP, //㉺Ȅ
    {CATEGORY_BGM, CATEGORY_TELOP, CATEGORY_CAMERA, CATEGORY_DELETE}
  },
  {
    CATEGORY_DELETE, //㉺Ȅ
    {CATEGORY_SE, CATEGORY_DELETE, CATEGORY_TELOP, CATEGORY_DELETE}
  },
};
//------------------------------------------------------------------------------
EditLowerTopView::EditLowerTopView( Main* main, app::util::Heap * heap, gfl::grp::g2d::LytSys* layout, gfl::ui::DeviceManager* device, Category category, int time ) : 
app::ui::UIView(heap),
m_main(main),
m_device(device),
m_heap(heap),
m_result(RESULT_SELECTING_TIME),
m_touch(NULL),
m_count(time),
m_state(STATE_TIME_SELECT)
{
  gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
  m_graphicSystem = gm->GetGraphicsSystem();
  
  // CAEg{̂̍쐬
  this->CreateLayout(layout);
  
  // Ԃł̓JeSEBhE\ȂĂ悢
  if(category == CATEGORY_NONE)
  {
    this->HideCategoryMenu();
  }
  else
  {
    this->ShowCategoryMenu();
    this->SetCursorPos(CATEGORY_PANE[category]);
    m_cursor_manager->SetPos(category);
  }
  
  // ͂߂̃bZ[W\
  // bo[0`10̐Zbg
  // @todo 1̐͒낦ɂďoc
  for(int i = 0; i <= 10; ++i)
  {
    m_g2dUtil->SetTextBoxPaneNumber(0, COUNT_TEXT_PANE[i], i, 2);
  }
}

EditLowerTopView::~EditLowerTopView()
{
  this->DeleteLayout();
}
//------------------------------------------------------------------------------
bool EditLowerTopView::OnSelectedButton(u32 button)
{
  GFL_PRINT("touch bar: selected: %d\n", button);
  switch(button)
  {
  case app::ui::UITouchBarView::BUTTON_ID_RETURN:
    switch(m_state)
    {
    case STATE_TIME_SELECT:
      m_result = RESULT_EXIT;
      break;
    case STATE_CATEGORY_SELECT:
      this->HideCategoryMenu();
      break;
    }
    break;

  // @todo UITouchBarViewRewind{^̒ǉ҂
  //case app::ui::UITouchBarView::BUTTON_REWIND:
  case app::ui::UITouchBarView::BUTTON_ID_SEARCH:
    break;
  }
  return false;
}
//------------------------------------------------------------------------------
void EditLowerTopView::Update()
{
  m_cursor->Update();
  
  UIView::Update();
  
  switch(m_state)
  {
  case STATE_TIME_SELECT:
    {
      m_time_select->Update();
      int ret = m_time_select->GetResult();
      if(ret == EditTimeSelect::RESULT_TOUCHED)
      {
        for(int i = 0; i <= 10; ++i)
        {
          bool hit = m_g2dUtil->GetHitPane(0, COUNT_PANE[i], m_time_select->GetTouchedPos().x, m_time_select->GetTouchedPos().y, false);
          if(hit)
          {
            m_count = i;
            this->ShowCategoryMenu();
            break;
          }
        }
      }
      else
      if(ret == EditTimeSelect::RESULT_DRAGING)
      {
        for(int i = 0; i <= 10; ++i)
        {
          bool hit = m_g2dUtil->GetHitPane(0, COUNT_PANE[i], m_time_select->GetDragPos().x, m_time_select->GetDragPos().y, false);
          if(hit)
          {
            this->SetCursorPosCount(i);
            break;
          }
        }
      }
      if(ret >= 0)
      {
        // bIꂽuԂł
        m_count = ret;
        this->ShowCategoryMenu();
      }
    }
    break;
  case STATE_CATEGORY_SELECT:
    {
      // ^b`o[
      switch(m_button_manager->Update())
      {
      case app::tool::ButtonManager::UPDATE_STATE_IDLE://ĂȂ
        break;
      case app::tool::ButtonManager::UPDATE_STATE_HOLDING://Ă
        this->SetCursorPos(CATEGORY_PANE[m_button_manager->GetHoldingButtonId()]);
        m_cursor_manager->SetPos(m_button_manager->GetHoldingButtonId());
        m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO01_LOWER_PANE_TEXT_00, CATEGORY_MESSAGE_ID[m_button_manager->GetHoldingButtonId()]);
        break;
      case app::tool::ButtonManager::UPDATE_STATE_SELECT_ANIME_PLAYING://IJn
        return;
      case app::tool::ButtonManager::UPDATE_STATE_SELECTED://Iꂽ
        m_cursor_manager->SetPos(m_button_manager->GetSelectedButtonId());
        // ʂۑ
        if(m_button_manager->GetSelectedButtonId() == CATEGORY_DELETE)
        {
          // @todo ŊmFEBhEoׂ
          
          this->ClearRecord(m_count);
          
          m_g2dUtil->StartAnime(0, ANIM_EVENT10_ACTIVE);
          
          if(m_count == 10)
          {
            m_g2dUtil->SetRegisterNumber(0, m_count, 2);
          }
          else
          {
            m_g2dUtil->SetRegisterNumber(0, m_count, 1);
          }
          m_g2dUtil->SetTextBoxPaneStringExpand(0, PANENAME_P_VIDEO01_LOWER_PANE_TEXT_00, pvd_make08);
        }
        else
        {
          m_result = (Result)(RESULT_DECIDE + m_button_manager->GetSelectedButtonId());
        }
        break;
      }
      
      // L[
      if(m_cursor_manager->MainRepeat() == app::tool::CursorManager::RET_MOVE)
      {
        this->SetCursorPos(CATEGORY_PANE[m_cursor_manager->GetPos()]);
        m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO01_LOWER_PANE_TEXT_00, CATEGORY_MESSAGE_ID[m_cursor_manager->GetPos()]);
      }
      if(m_device->GetButton(0)->IsTrigger(gfl::ui::BUTTON_A))
      {
        this->SetCursorPos(CATEGORY_PANE[m_cursor_manager->GetPos()]);
        m_button_manager->StartSelectedAct(m_cursor_manager->GetPos());
      }
    }
    break;
  }
  
  // ^b`o[
  // ɎĂȂƁAL[͂ƓɋNĂ܂
  m_touch->Update();
}
//------------------------------------------------------------------------------
void EditLowerTopView::Draw()
{
  m_touch->Draw();
  m_g2dUtil->Draw2D(m_graphicSystem, 0);
  if(m_cursor != NULL){m_cursor->Draw(m_graphicSystem, gfl::grp::DISPLAY_LOWER);}
}

//------------------------------------------------------------------------------
// OĂ΂
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// JeSj[̕\
void EditLowerTopView::ShowCategoryMenu()
{
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_P_WINDOW_BG, true);
  
  // ɁAbo[\ɂĂ
  for(int i = 0; i <= 10; ++i)
  {
    m_g2dUtil->SetPaneVisible(0, COUNT_PANE[i], false);
  }
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_POS, false);
  
  this->DeleteTimeSelectCursor();
  this->CreateCategoryCursor();
  
  // uCxg̓eIłv
  m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO01_LOWER_PANE_TEXT_00, pvd_make03);
  
  // J[\ʒu
  this->SetCursorPos(CATEGORY_PANE[0]);
  
  this->UpdateCategoryCheck();
  
  
  m_state = STATE_CATEGORY_SELECT;
  m_result = RESULT_SELECTING_CATEGORY;
}
//------------------------------------------------------------------------------
// JeSj[̔\
void EditLowerTopView::HideCategoryMenu()
{
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_P_WINDOW_BG, false);
  
  // ɁAbo[\Ă
  for(int i = 0; i <= 10; ++i)
  {
    m_g2dUtil->SetPaneVisible(0, COUNT_PANE[i], true);
  }
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_COUNT_POS, true);
  
  this->DeleteCategoryCursor();
  this->CreateTimeSelectCursor();
  
  // uCxgꂽbIłv
  m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO01_LOWER_PANE_TEXT_00, pvd_make02);
  
  // J[\ʒu
  this->SetCursorPos(COUNT_PANE[m_count]);
  
  m_state = STATE_TIME_SELECT;
  m_result = RESULT_SELECTING_TIME;
}

//------------------------------------------------------------------------------
// J[\ʒũZbg
void EditLowerTopView::SetCursorPos(int pane_id)
{
  m_cursor->Put(m_g2dUtil->GetLayoutWork(0), pane_id);
}
void EditLowerTopView::SetCursorPosCount(int index)
{
  this->SetCursorPos(COUNT_PANE[index]);
}
//------------------------------------------------------------------------------
// CreateDestroy
//------------------------------------------------------------------------------
void EditLowerTopView::CreateLayout(gfl::grp::g2d::LytSys* layout )
{
  static const app::util::G2DUtil::LYT_RES_DATA tbl[] = {
    { ARCID_PROMOTION,         0, LYTRES_MSG_WINDOW_RES_END, app::util::G2DUtil::ATTACH_ROOT },
    { ARCID_COMMON_MSGWINDOW,  0,                         0, app::util::G2DUtil::ATTACH_RESOURCE  }, // 01: ʃ\[X: bZ[WEBhE
  };
  static const gfl::grp::g2d::LytArcIndex anim[] = {
    LYTRES_LAYOUT_P_VIDEO01_LOWER_ACTIVE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO01_LOWER_CANSEL_BCLAN,
    LYTRES_LAYOUT_P_VIDEO01_LOWER_PASSIVE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO01_LOWER_RELEASE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO01_LOWER_TOUCH_RELEASE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO01_LOWER_TOUCH_BCLAN,
  };
  static const app::util::G2DUtil::LYTWK_DATA data[] = {
    {
      0,
      LYTRES_LAYOUT_P_VIDEO01_LOWER_BCLYT,
      anim,
      GFL_NELEMS(anim),
      GFL_NELEMS(anim) * 11,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true, // \ݒ
    },
  };
  
  
  this->Create2D(
    m_heap,
    layout,
    GFL_NELEMS(data),
    tbl,
    GFL_NELEMS(tbl),
    data, GFL_NELEMS(data),
    GARC_message_promo_video_system_DAT
  );
  
  // LAj̐ݒ
  // LAjݒ
  app::util::LytUtil::ShareAnimeDesc desc[10*6];
  for(int i = 0; i < 10; ++i)
  {
    for(int j = 0; j < 6; ++j)
    {
      int index = j + i*6;
      desc[index].start_anime_index = ANIM_EVENT01_ACTIVE + index;
      desc[index].max_share_num = 1;
      desc[index].anime_data = j;
      desc[index].share_group_index = PANENAME_P_VIDEO01_LOWER_GROUP_BUTTON_ANIME;
      desc[index].share_pane_index = CATEGORY_PANE[i];
    }
  }
  m_g2dUtil->CreateShareAnime(0, desc, GFL_NELEMS(desc));
  
  // bZ[WEBhE
  this->CreateMessageWindow();
  
  // ^b`o[
  {
    // @todo ^b`o[r[Ɋ߂{^߁ABUTON_SEARCHgpĂ̂ŁA㍷ւ
    static const app::ui::UITouchBarView::SETUP touch_setup[] = {
      {app::ui::UITouchBarView::BUTTON_ID_RETURN, PANENAME_P_VIDEO01_LOWER_PANE_RETURN_ICON_POS},
      {app::ui::UITouchBarView::BUTTON_ID_SEARCH, PANENAME_P_VIDEO01_LOWER_PANE_REWIND_ICON_POS},
    };
    
    m_touch = GFL_NEW(m_heap->pHeap) app::ui::UITouchBarView(
      m_heap,
      this->GetGraphicSystem(),
      layout,
      this->GetLayoutWork(0),
      touch_setup,
      GFL_NELEMS(touch_setup)
    );
    
    m_touch->SetListener(this);
  }
  
  
  // J[\̍쐬
  if(m_cursor == NULL)
  {
    m_cursor = GFL_NEW(m_heap->pHeap) app::tool::MenuCursor(m_g2dUtil->GetLayoutSystem());
    m_cursor->LoadLayoutResource(m_heap->pHeap, m_heap->pDevHeapAllocator);
    static const gfl::grp::g2d::LytWkSetUp CURSOR_SETUP = {
      gfl::math::VEC3( 0, -290, 0 ), // pos
      gfl::math::VEC2( 1, 1 ), // scale
      gfl::math::VEC3( 0, 0, 0 ), // rotate
      1, // priority
    };
    m_cursor->CreateLayoutWork(&CURSOR_SETUP, false);
    
    // J[\̓Aʒu0bڂɃZbg
    m_cursor->SetVisible(true);
    m_cursor->StartAnime(gamesystem::FRAMEMODE_30);
    this->SetCursorPos(COUNT_PANE[0]);
  }
}

void EditLowerTopView::DeleteLayout()
{
  // bI}l[WcĂ폜Ă
  this->DeleteTimeSelectCursor();
  this->DeleteCategoryCursor();
  
  // J[\̍폜
  if(m_cursor)
  {
    m_cursor->DeleteLayoutWork();
    m_cursor->ReleaseLayoutResource();
    GFL_DELETE(m_cursor);
    m_cursor = NULL;
  }
  
  
  // ^b`o[
  GFL_DELETE m_touch;
  
  // bZ[WEBhE
  this->DeleteMessageWindow();  
  // {̂
  this->Delete2D();
}
//------------------------------------------------------------------------------
// bZ[WEBhE쐬
//------------------------------------------------------------------------------
void EditLowerTopView::CreateMessageWindow()
{
  static const gfl::grp::g2d::LytPaneIndex table[] = {
    PANENAME_P_VIDEO01_LOWER_PANE_TEXT_00,
    PANENAME_P_VIDEO01_LOWER_PANE_TEXT_01,
  };
  m_g2dUtil->CreateMessageWindow(m_device, 0, table, 0, m_heap);
}

void EditLowerTopView::DeleteMessageWindow()
{
  m_g2dUtil->DeleteMessageWindow();
}

//------------------------------------------------------------------------------
// bIJ[\ERg[
//------------------------------------------------------------------------------
void EditLowerTopView::CreateTimeSelectCursor()
{
  // Ԑ@̍쐬
  if(m_time_select == NULL)
  {
    m_time_select = GFL_NEW(m_heap->pHeap) EditTimeSelect(this, m_count);
  }
}
void EditLowerTopView::DeleteTimeSelectCursor()
{
  // Ԑ@̍폜
  if(m_time_select)
  {
    GFL_DELETE m_time_select;
    m_time_select = NULL;
  }
}

//------------------------------------------------------------------------------
// JeSIJ[\ERg[
//------------------------------------------------------------------------------
void EditLowerTopView::CreateCategoryCursor()
{
  // {^}l[W̍쐬
  if(m_button_manager == NULL)
  {
    m_button_manager = GFL_NEW(m_heap->pHeap) app::tool::ButtonManager(
      m_heap->pHeap,
      m_device,
      10
    );
    gfl::grp::g2d::LytWk* wk = this->GetLayoutWork(0);
    for(int i = 0; i < 10; ++i)
    {
      m_button_manager->AddButton(
        m_heap->pHeap,
        BUTTON_DATA[i].id,
        wk,
        BUTTON_DATA[i].pane_index,
        BUTTON_DATA[i].hold_anime,
        BUTTON_DATA[i].release_anime,
        BUTTON_DATA[i].select_anime,
        NULL
      );
    }
  }
  
  // J[\}l[W̍쐬
  if(m_cursor_manager == NULL)
  {
    m_cursor_manager = GFL_NEW(m_heap->pHeap) app::tool::CursorManager(
      CURSOR_DATA,
      10,
      m_heap->pHeap
    );
  }
}

void EditLowerTopView::DeleteCategoryCursor()
{
  if(m_button_manager)
  {
    GFL_DELETE m_button_manager;
    m_button_manager = NULL;
  }
  
  if(m_cursor_manager)
  {
    GFL_DELETE m_cursor_manager;
    m_cursor_manager = NULL;
  }
}

  
void EditLowerTopView::ClearRecord(int second)
{
  Record& rec = m_main->GetRecord()[second];
  Record rec2;
  rec = rec2;
  
  this->UpdateCategoryCheck();
}


void EditLowerTopView::UpdateCategoryCheck()
{
  // bAR[hāACxgo^Ă镔Ƀ`FbNIA
  // Cxg̃̕`FbN\ɂB
  Record& rec = m_main->GetRecord()[m_count];
  
  // wi
  if(rec.background.bg != -1 || rec.background.blightness != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_01, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_01, false);
  
  // |[Y
  if(rec.model.motion != -1 || rec.model.rotation != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_02, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_02, false);
  
  // \
  if(rec.model.eye != -1 || rec.model.mouth != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_03, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_03, false);
  
  // BGM
  if(rec.bgm != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_04, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_04, false);
  
  // SE
  if(rec.se != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_05, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_05, false);
  
  // |P
  if(rec.model.model != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_06, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_06, false);
  
  // GtFNg
  if(rec.effect != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_07, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_07, false);
  
  // J
  if(rec.camera != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_08, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_08, false);
  
  // ebv
  if(rec.telop[0].text != -1 || rec.telop[0].effect != -1)
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_09, true);
  else
    m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_09, false);
  
  // 폜
  m_g2dUtil->SetPaneVisible(0, PANENAME_P_VIDEO01_LOWER_PANE_CHECK_10, false);
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)
