
#include "EditItemSelectScroller.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

//------------------------------------------------------------------------------
// con, des
//------------------------------------------------------------------------------
EditItemSelectScroller::EditItemSelectScroller(EditItemSelect* owner) :
m_owner(owner),
m_result(RESULT_NONE)
{
  m_heap = owner->GetHeap();
  
  // XN[擾Ă
  // ͈̃yC̍ł
  app::util::G2DUtil* util = m_owner->GetLayout();
  nw::lyt::Size size = util->GetSize(0, PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_01);
  m_scroll_height = size.height;
  
  m_touch = GFL_NEW(m_heap->pHeap) app::tool::TouchPanelOperator(m_owner->GetTouchPanel(), gamesystem::FRAMEMODE_30);
}

EditItemSelectScroller::~EditItemSelectScroller()
{
  for(List::iterator it = m_list.begin(); it != m_list.end(); ++it)
  {
    GFL_DELETE(&*it);
  }
  m_list.clear();
  
  GFL_DELETE m_touch;
}


//------------------------------------------------------------------------------
// Update
//------------------------------------------------------------------------------
void EditItemSelectScroller::Update()
{
  // J[\ʒũZbg
  if(m_state == SCROLL_NONE)
  {
    switch(m_mode)
    {
    case EditItemSelect::MODE_SCROLL:
      m_owner->SetCursorPos(m_owner->GetPaneID(m_mode, m_pos.y));
      break;
    case EditItemSelect::MODE_2SCROLL:
      m_owner->SetCursorPos(m_owner->GetPaneID(m_mode, m_pos.y * 2 + m_pos.x));
      break;
    }
  }
  
  // ^b`
  m_touch->Update();
  
  if(m_touch->IsDecide())
  {
    // 肵
    m_touch->GetDecideValue(&m_touched_pos);
    // ǂ̃{^ꂽ̃`FbNs
    int count = 4;if(m_mode == EditItemSelect::MODE_2SCROLL){count = 8;}
    for(int i = 0;i < count; ++i)
    {
      bool hit = m_owner->GetLayout()->GetHitPane(0, m_owner->GetPaneID(m_mode, i), m_touched_pos.x, m_touched_pos.y, false);
      if(hit)
      {
        // ړ̃J[\̍W߂
        gfl::math::VEC2 v;
        v.y = i;
        if(m_mode == EditItemSelect::MODE_2SCROLL){v.y = i/2; v.x = i%2;}
        
        // ɃJ[\ꏊȂ猈AłȂȂvr[
        if(v == m_pos)
        {
          m_result = (Result)(m_scroll_count + m_pos.y);
          if(m_mode == EditItemSelect::MODE_2SCROLL)
          {
            m_result = (Result)(2*m_scroll_count + m_pos.y*2 + m_pos.x);
          }
          m_check = (int)m_result;
          this->UpdateText();
        }
        else
        {
          m_pos = v;
          this->RequirePreview();
        }
      }
    }
  }
  else
  if(m_touch->IsDrag())
  {
  // hbOłȂ
    m_result = RESULT_NONE;
    
    gfl::math::VEC2 v1;
    gfl::math::VEC2 v2;
    m_touch->GetDragStartValue(&v1);
    if(!m_drag_flag)
    {
      m_drag_start_pos = v1;
      m_result = RESULT_DRAGING;//hack
      m_drag_flag = true;
    }
    m_touch->GetDragNowValue(&v2);
    if(v2.y - m_drag_start_pos.y > 10 )
    {
      this->ScrollUp();
      m_drag_start_pos = v2;
    }
    else
    if(v2.y - m_drag_start_pos.y < -10)
    {
      this->ScrollDown();
      m_drag_start_pos = v2;
    }
  }
  else
  {
    m_result = RESULT_NONE;
    m_drag_flag = false;
  }
  
  
  
  // L[
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_LEFT))
  {
    if(m_pos.x != 0){m_pos.x = 0; this->RequirePreview();}
  }
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_RIGHT))
  {
    // 2񃂁[hȂƖ
    if(m_mode != EditItemSelect::MODE_SCROLL)
    {
      // ԉ܂ōsĂ疳
      if(m_pos.y*2 + m_pos.x+1 != m_list.size())
      {
        if(m_pos.x != 1){m_pos.x = 1; this->RequirePreview();}
      }
    }
  }
  // XN[łȂ΁AL[͂ɂ錈󂯕t
  if(m_owner->GetButton()->IsTrigger(gfl::ui::BUTTON_A))
  {
    // @todo {^ꂽ̂ŁA{^̃Aj[VJn
    // @todo AƂ肠{^Aj͕ۗ
    m_result = (Result)(m_scroll_count + m_pos.y);
    if(m_mode == EditItemSelect::MODE_2SCROLL)
    {
      m_result = (Result)(2*m_scroll_count + m_pos.y*2 + m_pos.x);
    }
    m_check = (int)m_result;
    this->UpdateText();
  }
  
  
  // L[͂ɂJ[\ړ
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_UP))
  {
    if(m_pos.y > 0){--m_pos.y; this->RequirePreview();}
    else{this->ScrollUp(); this->RequirePreview();}
  }
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_DOWN))
  {
    // 2񃂁[h
    if(m_mode != EditItemSelect::MODE_SCROLL)
    {
      // ԉ܂ōsĂ疳
      if(2*m_scroll_count + m_pos.y*2 + m_pos.x+2 < m_list.size())
      {
        if(m_pos.y < 3){++m_pos.y; this->RequirePreview();}
        else
        {
          this->ScrollDown();
          this->RequirePreview();
        }
      }
    }
    // 1񃂁[h
    else
    {
      // ԉ܂ōsĂ疳
      if(m_scroll_count + m_pos.y+1 < m_list.size())
      {
        if(m_pos.y < 3){++m_pos.y; this->RequirePreview();}
        else
        {
          this->ScrollDown();
          this->RequirePreview();
        }
      }
    }
  }
  
  // XN[
  switch(m_state)
  {
  case SCROLL_NONE:
    break;
  case SCROLL_DOWN:
  case SCROLL_UP:
    // XN[Ԃ炷
    --m_scroll_time;
    if(m_scroll_time <= 0)
    {
      // ڕWʒuɃZbg(̎_ł͍Wʒuɂ͂)
      //m_scroll_pos = 1 * m_scroll_count * m_scroll_height;
      m_scroll_pos = m_scroll_pos_init;
      this->UpdateText();
      int pane = PANENAME_P_VIDEO02_LOWER_PANE_P1_POS;
      if(m_mode == EditItemSelect::MODE_SCROLL){pane = PANENAME_P_VIDEO02_LOWER_PANE_P3_POS;}
      gfl::math::VEC3 pos(0,0,0); pos.y = m_scroll_pos;
      m_owner->GetLayout()->SetPanePos(0, pane, &pos);
      
      m_scroll_speed = 0;
      m_state = SCROLL_NONE;
    }
    else
    {
      m_scroll_pos += m_scroll_speed;
      if(m_scroll_pos - m_scroll_pos_init >= m_scroll_height)
      {
        // KȏړȂA\̃Abvf[gs
        m_scroll_pos -= m_scroll_height;
        this->UpdateText();
      }
      if(m_scroll_pos_init - m_scroll_pos >= m_scroll_height)
      {
        m_scroll_pos += m_scroll_height;
        this->UpdateText();
      }
      int pane = PANENAME_P_VIDEO02_LOWER_PANE_P1_POS;
      if(m_mode == EditItemSelect::MODE_SCROLL){pane = PANENAME_P_VIDEO02_LOWER_PANE_P3_POS;}
      gfl::math::VEC3 pos = m_owner->GetLayout()->GetPanePos(0, pane); pos.y = m_scroll_pos;
      m_owner->GetLayout()->SetPanePos(0, pane, &pos);
    }
    break;
  }
}


//------------------------------------------------------------------------------
// XN[֘A
//------------------------------------------------------------------------------
void EditItemSelectScroller::ScrollUp()
{
  if(m_scroll_count == 0){return;}
  
  m_state = SCROLL_DOWN;
  // Iɂ́Aɗ_łɈړ
  --m_scroll_count;
  this->UpdateText();
  //--m_scroll_count;
  //--m_scroll_count;
  
  // 5t[œB
  m_scroll_time = 3;
  // 5t[œB邽߂̃Xs[h𒲐
  app::util::G2DUtil* util = m_owner->GetG2DUtil();
  //float target_pos = 1 * m_scroll_count * m_scroll_height;
  //m_scroll_speed = -(target_pos - m_scroll_pos) / m_scroll_time;
  m_scroll_speed = m_scroll_height / m_scroll_time;
  
  int pane = PANENAME_P_VIDEO02_LOWER_PANE_P1_POS;
  if(m_mode == EditItemSelect::MODE_SCROLL){pane = PANENAME_P_VIDEO02_LOWER_PANE_P3_POS;}
  gfl::math::VEC3 pos(0,0,0); pos.y = m_scroll_pos_init+m_scroll_height-1;
  m_owner->GetLayout()->SetPanePos(0, pane, &pos);
}
void EditItemSelectScroller::ScrollDown()
{
  if(m_mode == EditItemSelect::MODE_2SCROLL && 2*m_scroll_count + m_pos.y*2 + m_pos.x+2 >= m_list.size()){return;}
  if(m_mode == EditItemSelect::MODE_SCROLL && m_scroll_count + m_pos.y+1 >= m_list.size()){return;}
  
  m_state = SCROLL_DOWN;
  
  m_scroll_pos = m_scroll_pos_init;
  int pane = PANENAME_P_VIDEO02_LOWER_PANE_P1_POS;
  if(m_mode == EditItemSelect::MODE_SCROLL){pane = PANENAME_P_VIDEO02_LOWER_PANE_P3_POS;}
  gfl::math::VEC3 pos(0,0,0); pos.y = m_scroll_pos;
  m_owner->GetLayout()->SetPanePos(0, pane, &pos);
  this->UpdateText();
  
  // Iɂ́Aɗ_łɈړ
  ++m_scroll_count;
  
  // 5t[œB
  m_scroll_time = 3;
  // 5t[œB邽߂̃Xs[h𒲐
  app::util::G2DUtil* util = m_owner->GetG2DUtil();
  //float target_pos = 1 * m_scroll_count * m_scroll_height;
  //m_scroll_speed = (target_pos - m_scroll_pos) / m_scroll_time;
  m_scroll_speed = m_scroll_height / m_scroll_time;
  
  
}
//------------------------------------------------------------------------------
// ֘A
//------------------------------------------------------------------------------
void EditItemSelectScroller::Initialize(EditItemSelect::ViewMode mode, int check)
{
  m_mode = mode;
  m_check = check;
  
  // XN[ʒuc
  int pane;
  if(m_mode == EditItemSelect::MODE_2SCROLL){pane = PANENAME_P_VIDEO02_LOWER_PANE_P1_POS;}
  else{pane = PANENAME_P_VIDEO02_LOWER_PANE_P3_POS;}
  gfl::math::VEC3 pos = m_owner->GetLayout()->GetPanePos(0, pane);
  
  m_scroll_pos_init = pos.y;
  m_scroll_pos = pos.y;
}

void EditItemSelectScroller::Add(int result_id, int msg_id)
{
  Data* data = GFL_NEW(m_heap->pHeap) Data(result_id, msg_id);
  m_list.push_back(data);
}

void EditItemSelectScroller::AddTelop(int result_id, int msg_id)
{
  Data* data = GFL_NEW(m_heap->pHeap) Data(result_id, msg_id, true);
  m_list.push_back(data);
}

void EditItemSelectScroller::Create()
{
  
  // ォ珇ԂɁAbZ[W͂Ă
  this->UpdateText();
  
  // J[\ʒũZbg
  m_pos.x = 0; m_pos.y = 0;
  m_owner->SetCursorPos(m_owner->GetPaneID(m_mode, 0));
}

//------------------------------------------------------------------------------
// XN[󋵂lAK؂ȃeLXgbZ[W̃Zbgs
//------------------------------------------------------------------------------
void EditItemSelectScroller::UpdateText()
{
  // ܂AԍŏɕKvm
  int start = 0;
  int end = 0;
  switch(m_mode)
  {
  case EditItemSelect::MODE_2SCROLL:
    start = 2*m_scroll_count;
    end = start + 12;
    break;
  case EditItemSelect::MODE_SCROLL:
    start = m_scroll_count;
    end = start + 6;
    break;
  }
  
  List::Iterator it = m_list.begin();
  int i = 0; int local = 0;
  for(; i < m_list.size(); ++i)
  {
    if(i < start){++it;continue;}
    if(i == end){break;}
    m_owner->GetLayout()->SetPaneVisible(0, m_owner->GetPaneID(m_mode, local), true);
    if(!it->is_telop)
    {
      m_owner->GetLayout()->SetTextBoxPaneString(0, m_owner->GetTextPaneID(m_mode, local), it->msg);
    }
    else
    {
      // ebv
      m_owner->GetLayout()->SetTextBoxPaneString(0, m_owner->GetTextPaneID(m_mode, local), m_owner->GetMain()->GetTelopStrBuf(it->result));
    }
    if(m_check == i)//it->result)
    {
      GFL_PRINT("\n\nm_check = %d, i = %d, it->result = %d\n\n\n", m_check, i, it->result);
      // I𒆁F`FbN
      m_owner->GetLayout()->SetPaneVisible(0, m_owner->GetCheckPaneID(m_mode, local), true);
    }
    else
    {
      // I𒆂ł͂Ȃ̂ŁA`FbNO
      m_owner->GetLayout()->SetPaneVisible(0, m_owner->GetCheckPaneID(m_mode, local), false);
    }
    // @todo NewACRݒ肷
    ++it;
    ++local;
  }
  if(local != end-start)
  {
    for(; local < end-start; ++local)
    {
      m_owner->GetLayout()->SetPaneVisible(0, m_owner->GetPaneID(m_mode, local), false);
    }
  }
}

//------------------------------------------------------------------------------
// vr[v
//------------------------------------------------------------------------------
void EditItemSelectScroller::RequirePreview()
{
  int id = 0;
  if(m_mode == EditItemSelect::MODE_2SCROLL){id = m_scroll_count * 2 + m_pos.x + m_pos.y * 2;}
  else{id = m_scroll_count + m_pos.y;}
  m_owner->RequirePreview(id);
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)
